/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.codeeditor;

import java.util.ArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import oracle.bpm.cil.CilException;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.compiler.InvalidLanguageException;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.TemplateParameter;
import oracle.bpm.editor.EditorDocument;
import oracle.bpm.fusion.studio.codeeditor.FusionDocumentListener;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.compile.ExpressionCompiler;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.javatools.editor.BasicDocument;
import org.jetbrains.annotations.NotNull;

public class FusionDocument
extends BasicDocument
implements EditorDocument {
    private DataDeclarationContainer context;
    private ArrayList<CilException> errors = new ArrayList();
    private ArrayList<FusionDocumentListener> listeners = new ArrayList();
    private MethodTypeDescription method;
    private CatalogType resultType;
    private int timestamp;

    public FusionDocument(@NotNull DataDeclarationContainer context, CatalogType resultType) {
        this.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FusionDocument.this.timestamp++;
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FusionDocument.this.timestamp++;
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FusionDocument.this.timestamp++;
            }
        });
        this.context = context;
        this.resultType = resultType;
    }

    public void addFusionDocumentListener(FusionDocumentListener listener) {
        this.listeners.add(listener);
    }

    public void removeFusionDocumentListener(FusionDocumentListener listener) {
        this.listeners.remove(listener);
    }

    public Sequence<CilException> getErrors() {
        return CollectionUtils.asSequence(this.errors);
    }

    public char[] getChars() throws BadLocationException {
        return this.getText(0, this.getLength()).toCharArray();
    }

    public String getLineTextOfOffset(int offset) throws BadLocationException {
        return this.getText(0, offset);
    }

    public void removeText(int start, int length) throws BadLocationException {
        this.remove(start, length);
    }

    public void replaceText(int offset, int length, String replacement) throws BadLocationException {
        this.remove(offset, length);
        this.insertString(offset, replacement, new SimpleAttributeSet());
    }

    public LanguageSpec getLanguage() {
        try {
            return LanguageSpec.getLanguageSpec((String)this.getMethod().getCodeLanguage());
        }
        catch (InvalidLanguageException e) {
            throw new RuntimeException(e);
        }
    }

    public void setMethod(MethodTypeDescription method) {
        this.method = method;
    }

    public MethodTypeDescription getMethod() {
        return this.method != null ? this.method : ExpressionCompiler.buildMethod((DataDeclarationContainer)this.context, (CatalogType)this.resultType);
    }

    public void beforeCompilation() {
        this.errors.clear();
        this.fireCompilationStarted();
    }

    public void addError(CilException exception, long parsed) {
        this.errors.add(exception);
    }

    public void afterCompilation() {
        this.fireCompilationFinished();
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void touch() {
        ++this.timestamp;
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        return this.getLineFromOffset(offset) + 1;
    }

    public boolean isExpressionRequired() {
        return false;
    }

    public boolean activateTemplateMark(int offset, boolean avoidEmptyMarks) {
        return false;
    }

    public void addTemplateMark(TemplateParameter parameter) {
    }

    public void addTemplateMark(int offset, int length) {
    }

    public void clearTemplateMarks() {
    }

    public void addWarning(CilException exception, long parsed) {
    }

    public boolean hasTemplateMarks() {
        return false;
    }

    public void updateCompilationStatus() {
    }

    public void usage(int offset, int length, int type) {
    }

    public void select(int start, int end) {
    }

    public <T> T as(Class<T> targetType) {
        return null;
    }

    private void fireCompilationStarted() {
        for (FusionDocumentListener listener : this.listeners) {
            listener.compilationStarted();
        }
    }

    private void fireCompilationFinished() {
        for (FusionDocumentListener listener : this.listeners) {
            listener.compilationFinished();
        }
    }
}

