/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.codeeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.BreakPoint;
import oracle.bpm.compiler.CodeDebugger;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.compiler.LineBreakPoint;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.editor.CodeFixHandler;
import oracle.bpm.editor.EditorContext;
import oracle.bpm.editor.EditorDocument;
import oracle.bpm.editor.EditorSupport;
import oracle.bpm.editor.UndoRedoListener;
import oracle.bpm.fusion.studio.codeeditor.FusionDocument;
import oracle.bpm.fusion.studio.codeeditor.codecompletion.CompletionInsightPlugin;
import oracle.bpm.fusion.studio.codeeditor.syntaxhighlight.SyntaxHighlightPlugin;
import oracle.bpm.fusion.studio.codeeditor.underline.UnderlinePlugin;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.KeyListener;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.ToolTipProvider;
import oracle.javatools.editor.plugins.EditorPlugin;
import org.jetbrains.annotations.NotNull;

public class FusionCodeEditor
extends JPanel
implements CodeEditor,
Serializable {
    private EditorContext context;
    private BasicEditorPane editor;
    private ArrayList<oracle.bpm.ui.event.FocusListener> focusListeners = new ArrayList();
    private static final long serialVersionUID = 8905207765536994221L;

    public FusionCodeEditor(@NotNull DataDeclarationContainer context, CatalogType resultType) {
        this.editor = new BasicEditorPane();
        FusionDocument fusionDocument = new FusionDocument(context, resultType);
        this.editor.setDocument((Document)((Object)fusionDocument));
        this.getContext().setDocument((EditorDocument)fusionDocument, true);
        this.editor.installPlugin((EditorPlugin)new SyntaxHighlightPlugin());
        this.editor.installPlugin((EditorPlugin)new CompletionInsightPlugin());
        UnderlinePlugin underlinePlugin = new UnderlinePlugin();
        this.editor.installPlugin((EditorPlugin)underlinePlugin);
        this.editor.addToolTipProvider((ToolTipProvider)underlinePlugin);
        this.editor.putBooleanProperty("insight-manual-complete-single", true);
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane((Component)this.editor);
        scrollPane.setVerticalScrollBarPolicy(22);
        JViewport viewport = scrollPane.getViewport();
        viewport.setScrollMode(1);
        this.add((Component)scrollPane, "Center");
        this.initListeners();
    }

    public BasicEditorPane getTextEditor() {
        return this.editor;
    }

    public EditorDocument getEditorDocument() {
        Document doc = this.editor.getDocument();
        return doc instanceof FusionDocument ? (FusionDocument)((Object)doc) : null;
    }

    public LanguageSpec getLanguage() {
        return this.getEditorDocument().getLanguage();
    }

    public void touch() {
        this.getEditorDocument().touch();
    }

    public void setCaretPosition(int offset) {
        this.editor.setCaretPosition(offset);
    }

    public int getCaretPosition() {
        return this.editor.getCaretPosition();
    }

    public void setEditable(boolean editable) {
        this.editor.setEditable(editable);
    }

    public boolean isEditable() {
        return this.editor.isEditable();
    }

    public String getSelectedText() {
        return this.editor.getSelectedText();
    }

    public int getSelectionEnd() {
        return this.editor.getSelectionEnd();
    }

    public int getSelectionStart() {
        return this.editor.getSelectionStart();
    }

    public void setText(String text) {
        this.editor.setText(text);
    }

    public String getText() {
        return this.editor.getText();
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this.editor.getText(offset, length);
    }

    public void select(int start, int end) {
        this.editor.select(start, end);
    }

    public UiComponent getView() {
        return UiComponent.get((Object)this);
    }

    public void addFocusListener(final oracle.bpm.ui.event.FocusListener listener) {
        this.focusListeners.add(listener);
        FocusListener awtFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
                listener.focusGained(null);
            }

            @Override
            public void focusLost(FocusEvent event) {
                listener.focusLost(null);
            }
        };
        this.editor.addFocusListener(awtFocusListener);
    }

    public void removeFocusListener(oracle.bpm.ui.event.FocusListener listener) {
        this.focusListeners.add(listener);
    }

    public void updateCompilationStatus() {
    }

    public Action getActionByName(String name) {
        return null;
    }

    public void setAddToolBar(boolean addToolBar) {
    }

    public boolean isAddToolBar() {
        return false;
    }

    public void setCanBrowseDeclarations(boolean canBrowse) {
    }

    public void setCloseAction(BaseAction action) {
    }

    public void setCode(MethodTypeDescription code) {
    }

    public MethodTypeDescription getCode() {
        return null;
    }

    public void setCompilerDirectives(int directives) {
    }

    public void setExpression(boolean expression) {
    }

    public boolean isExpression() {
        return false;
    }

    public void setExpressionRequired(boolean required) {
    }

    public boolean isExpressionRequired() {
        return false;
    }

    public void setFixHandler(CodeFixHandler fixHandler) {
    }

    public List<LineBreakPoint> getLineBreakPoints() {
        return null;
    }

    public CodeDebugger.CILSource getSource() {
        return null;
    }

    public void setSupport(EditorSupport support) {
    }

    public EditorSupport getSupport() {
        return null;
    }

    public ToolBar getToolBar() {
        return null;
    }

    public void setUndoRedoListener(UndoRedoListener listener) {
    }

    public void setValidate(boolean validate) {
    }

    public boolean isValidate() {
        return false;
    }

    public void addBreakPointMark(BreakPoint breakPoint) {
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void addDependableAction(Action action) {
    }

    public void addEdit(UndoableEdit undoableEdit) {
    }

    public void addError(CilException exception) {
    }

    public void addKeyListener(KeyListener listener) {
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
    }

    public void addWarning(CilException warning) {
    }

    public void checkChangeLanguage() {
    }

    public void clearUndoEvents() {
    }

    public boolean containsDependableAction(Action action) {
        return false;
    }

    public void extractBreakPoints(List breakPointList) {
    }

    public void focusLost() {
    }

    public void goToStart() {
    }

    public void marksChanged() {
    }

    public void removeDependableAction(Action action) {
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
    }

    public void runActionByName(String name) {
    }

    public void selectLine(int line) {
    }

    public void setSelectionProvider(SelectionProvider selectionProvider) {
    }

    private EditorContext getContext() {
        if (this.context == null) {
            this.context = new EditorContext();
        }
        return this.context;
    }

    private void initListeners() {
        this.editor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent event) {
                FusionCodeEditor.this.fireFocusGained();
            }

            @Override
            public void focusLost(FocusEvent event) {
                FusionCodeEditor.this.fireFocusLost();
            }
        });
    }

    private void fireFocusLost() {
        for (oracle.bpm.ui.event.FocusListener listener : this.focusListeners) {
            listener.focusLost(null);
        }
    }

    private void fireFocusGained() {
        for (oracle.bpm.ui.event.FocusListener listener : this.focusListeners) {
            listener.focusGained(null);
        }
    }
}

