/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.actions;

import javax.swing.JOptionPane;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.fusion.studio.actions.StudioViewActions;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;

public final class StudioController
implements Controller {
    private static StudioController instance;
    private static final int START_ENGINE_ID;

    public static void createActions() {
        StudioViewActions.getInstance().createActions();
    }

    public boolean handleEvent(IdeAction action, Context context) {
        boolean result;
        if (action.getCommandId() == START_ENGINE_ID) {
            this.startEngine();
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public boolean update(IdeAction action, Context context) {
        action.setEnabled(true);
        return true;
    }

    private static synchronized StudioController getInstance() {
        if (instance == null) {
            instance = new StudioController();
        }
        return instance;
    }

    private void startEngine() {
        SelectionProvider selectionProvider = this.getWorkbench().getSelectionProvider();
        Selection selection = selectionProvider.getSelection();
        ProjectObject projectObject = (ProjectObject)selection.as(ProjectObject.class);
        Project project = null;
        if (projectObject != null) {
            project = projectObject.getProject();
        }
        JOptionPane.showMessageDialog(null, "Start Engine Action !!!!! " + (project != null ? project.getId() : "<NO PROJECT>"));
    }

    private StudioWorkbench getWorkbench() {
        return AbstractStudioWorkbench.getInstance();
    }

    static {
        START_ENGINE_ID = Ide.findOrCreateCmdID((String)"studio.start_engine");
    }
}

