/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.TranslationService;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.fusion.studio.FusionWorkbench;
import oracle.bpm.lang.Platform;
import oracle.bpm.ui.UiContainer;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.tip.tools.ide.common.ide.IDEProject;
import oracle.tip.tools.ide.common.ide.jdeveloper.JDevProject;
import oracle.tip.tools.ide.common.services.translation.DefaultKeyRepository;
import oracle.tip.tools.ide.common.services.translation.IKeyRepository;
import oracle.tip.tools.ide.common.services.translation.RepositoryManager;
import oracle.tip.tools.ide.common.services.translation.TranslationBrowser;
import oracle.tip.tools.ide.common.services.translation.TranslationContext;
import org.jetbrains.annotations.NotNull;

public class TranslationServiceImpl
implements TranslationService {
    private File propertiesFile;
    private RepositoryManager repositoryManager;
    private String resourceBundleName;
    private Properties resourceBundleProperties = new Properties();
    private TranslationContext translationContext;

    public boolean init(@NotNull UiContainer parent, @NotNull oracle.bpm.project.model.Project project, String resourceBundleName) {
        DefaultKeyRepository keyRepository;
        this.translationContext = new TranslationContext();
        File projectRootFolder = project.getLoader().getProjectFileSystem().getLocalFileSystem().getRootFolder();
        Project devProject = Platform.getAdapterService().adaptTo(project, Project.class);
        this.repositoryManager = new RepositoryManager((IDEProject)new JDevProject(devProject));
        URL resourceBundleLocationURL = URLFactory.newDirURL((File)projectRootFolder);
        if (resourceBundleName != null) {
            keyRepository = new DefaultKeyRepository(resourceBundleLocationURL, resourceBundleName);
            this.translationContext.setRepository((IKeyRepository)keyRepository);
            this.repositoryManager.setRepository((IKeyRepository)keyRepository);
        } else {
            keyRepository = new DefaultKeyRepository(resourceBundleLocationURL, null);
            this.translationContext.setRepository((IKeyRepository)keyRepository);
            this.repositoryManager.setRepository((IKeyRepository)keyRepository);
            TranslationContext context = new TranslationBrowser().browse((Component)parent.asSwing(), this.translationContext);
            if (keyRepository.getResourceBundleName() == null) {
                return false;
            }
            this.repositoryManager.save();
        }
        this.resourceBundleName = keyRepository.getResourceBundleName();
        this.propertiesFile = new File(projectRootFolder, this.resourceBundleName + ".properties");
        return true;
    }

    public String browseResourceBundle(@NotNull UiContainer parent, String currentKey) {
        TranslationContext context = new TranslationBrowser().browse((Component)parent.asSwing(), this.translationContext);
        this.repositoryManager.save();
        return context.getCurrentKey();
    }

    public String translate(String key) {
        return this.repositoryManager.getRepository().getTemplate(key);
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    private FusionProjectRepository getRepository() {
        return (FusionProjectRepository)((FusionWorkbench)AbstractStudioWorkbench.getInstance()).getRepository();
    }
}

