/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio;

import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.bpm.fusion.studio.StudioPreferences;
import oracle.bpm.log.Log;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class StudioPreferencesLoader
implements ContentHandler {
    private File file;
    private boolean importingWorkspaces;
    private StudioPreferences prefs;

    public StudioPreferencesLoader(File file, StudioPreferences prefs) {
        this.file = file;
        this.prefs = prefs;
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int end) throws SAXException {
    }

    public void load() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader parser = sp.getXMLReader();
            parser.setContentHandler(this);
            parser.parse(new InputSource(new FileInputStream(this.file)));
        }
        catch (Exception e) {
            Log.logWarning(e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String local, String name, Attributes amap) throws SAXException {
        if ("general".equals(name)) {
            this.manageGeneralInfo(amap);
            return;
        }
        if ("workspaces".equals(name)) {
            this.importingWorkspaces = true;
        }
        if (this.importingWorkspaces && "workspace".equals(name)) {
            this.manageWorkspace(amap);
        }
    }

    @Override
    public void endElement(String uri, String local, String name) throws SAXException {
        if (this.importingWorkspaces && "workspaces".equals(name)) {
            this.importingWorkspaces = false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private void manageWorkspace(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            if (!"url".equals(attname)) continue;
            this.prefs.getWorkspaces().add(value);
        }
    }

    private void manageGeneralInfo(Attributes amap) {
        for (int i = 0; i < amap.getLength(); ++i) {
            String attname = amap.getQName(i);
            String value = amap.getValue(i);
            this.manageGeneralAttribute(attname, value);
        }
    }

    private void manageGeneralAttribute(String attname, String value) {
        if (attname.equals("activeWorkspace")) {
            this.prefs.setActiveWorkspace(value);
        }
    }
}

