/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.fusion.studio.StudioPreferencesLoader;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import oracle.bpm.xml.XmlWriter;
import oracle.ide.Ide;

public class StudioPreferences {
    private String activeWorkspace;
    private ArrayList<String> workspacesUrl = new ArrayList();
    private static StudioPreferences studioPreferences;

    public static StudioPreferences getPreferences() {
        if (studioPreferences == null) {
            studioPreferences = new StudioPreferences();
            studioPreferences.load();
        }
        return studioPreferences;
    }

    public List<String> getWorkspaces() {
        return this.workspacesUrl;
    }

    public synchronized void load() {
        File f = this.getPreferencesFile();
        if (f.exists()) {
            new StudioPreferencesLoader(f, this).load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.getPreferencesFile());
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Literals.DEFAULT_ENCODING);
            this.writeXML(writer);
            writer.flush();
        }
        catch (IOException e) {
            Log.logWarning(e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ignore) {
                    Log.logWarning(ignore);
                }
            }
        }
    }

    public void writeXML(Writer writer) throws IOException {
        XmlWriter xmlWriter = new XmlWriter(writer, Literals.DEFAULT_ENCODING);
        xmlWriter.startDocument();
        xmlWriter.startElement("StudioPreferences");
        xmlWriter.startElement("general");
        xmlWriter.printAttribute("activeWorkspace", this.activeWorkspace);
        xmlWriter.endElement();
        xmlWriter.startElement("workspaces");
        for (String s : this.workspacesUrl) {
            xmlWriter.startElement("workspace");
            xmlWriter.printAttribute("url", s);
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    public void setActiveWorkspace(String url) {
        this.activeWorkspace = url;
    }

    private File getPreferencesFile() {
        return new File(Ide.getSystemDirectory(), "studio.preferences");
    }
}

