/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.adapter.AdapterService;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.BpaService;
import oracle.bpm.designer.CodeEditorService;
import oracle.bpm.designer.ExpressionBuilderService;
import oracle.bpm.designer.LifeCycleListener;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.TranslationService;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionField;
import oracle.bpm.designer.argumentmapping.transformation.DataTransformationsTableModel;
import oracle.bpm.designer.search.SearchQuery;
import oracle.bpm.designer.search.SearchService;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.execution.Interceptor;
import oracle.bpm.fusion.core.ProjectObjectNode;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.fusion.studio.FusionCommandInterceptor;
import oracle.bpm.fusion.studio.Product;
import oracle.bpm.fusion.studio.TranslationServiceImpl;
import oracle.bpm.fusion.studio.codeeditor.FusionCodeEditor;
import oracle.bpm.fusion.studio.expressionbuilder.SimpleExpressionBuilder;
import oracle.bpm.fusion.studio.expressionbuilder.XPathExpressionBuilder;
import oracle.bpm.fusion.ui.editor.FusionEditor;
import oracle.bpm.lang.Platform;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.DefaultSelectionProvider;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.tip.tools.ide.common.expressionbuilder.ExpressionBuilder;
import oracle.tip.tools.ide.common.utils.PreviewUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionWorkbench
extends AbstractStudioWorkbench {
    private SelectionProvider editorAreaSelectionProvider;
    private Map<LifeCycleListener, EditorListener> lifeCycleListeners = new HashMap<LifeCycleListener, EditorListener>();

    public FusionWorkbench() {
        this.editorAreaSelectionProvider = new DefaultSelectionProvider();
        this.initSelectionListeners();
        System.setProperty("bpm.preview.mode", String.valueOf(this.isInPreviewMode()));
    }

    public void activateEditor(StudioEditor studioEditor) {
        Editor editor = FusionWorkbench.getEditor(studioEditor);
        if (editor != null) {
            editor.activate();
        }
    }

    public void addLifeCycleListener(LifeCycleListener listener) {
        LifeCycleAdapter editorListener = new LifeCycleAdapter(listener);
        this.lifeCycleListeners.put(listener, editorListener);
        FusionWorkbench.getEditorManager().addEditorListener((EditorListener)editorListener);
    }

    public boolean closeAllEditors() {
        EditorManager editorManager = FusionWorkbench.getEditorManager();
        List list = editorManager.getAllEditors();
        editorManager.closeEditors(list);
        return false;
    }

    public void closeEditor(StudioEditor studioEditor) {
        Editor editor = FusionWorkbench.getEditor(studioEditor);
        if (editor != null) {
            FusionWorkbench.getEditorManager().closeEditors(Collections.singletonList(editor));
        }
    }

    public void closeEditorAfterDelete(StudioEditor studioEditor) {
        Editor editor = FusionWorkbench.getEditor(studioEditor);
        if (editor != null) {
            Node node = editor.getContext().getNode();
            node.markDirty(false);
            FusionWorkbench.getEditorManager().closeEditors(Collections.singletonList(editor));
        }
    }

    public StudioEditor createEditor(Class editorClass, Object input) {
        if (editorClass == null) {
            return null;
        }
        return this.instantiateEditor(editorClass, input, null);
    }

    @Nullable
    public StudioEditor getActiveEditor() {
        EditorManager editorManager = FusionWorkbench.getEditorManager();
        Editor editor = editorManager.getCurrentEditor();
        StudioEditor result = null;
        if (editor instanceof FusionEditor) {
            result = ((FusionEditor)editor).getStudioEditor();
        }
        return result;
    }

    public SelectionProvider getEditorAreaSelectionProvider() {
        return this.editorAreaSelectionProvider;
    }

    public SearchService getSearchService() {
        return new SearchService(){

            public void runQuery(SearchQuery query) {
            }
        };
    }

    @Nullable
    public TranslationService getTranslationService(UiContainer parent, Project project, String resourceBundleName) {
        TranslationServiceImpl translationService = new TranslationServiceImpl();
        boolean result = translationService.init(parent, project, resourceBundleName);
        return result ? translationService : null;
    }

    public ExpressionBuilderService getExpressionBuilderService() {
        return new ExpressionBuilderService(){

            public oracle.bpm.designer.ExpressionBuilder getExpressionBuilder(@NotNull ExpressionMode mode, @NotNull DataDeclarationContainer context, CatalogType resultType, Expression expression, @NotNull ExpressionField.ExpressionFieldMode fieldMode) {
                ExpressionBuilder expressionBuilder = null;
                if (mode.equals(ExpressionMode.XPATH)) {
                    expressionBuilder = XPathExpressionBuilder.create(context, expression);
                } else if (mode.equals(ExpressionMode.SIMPLE)) {
                    expressionBuilder = SimpleExpressionBuilder.create(context, resultType, expression, fieldMode);
                }
                return expressionBuilder;
            }
        };
    }

    @Nullable
    public StudioEditor getSelectedEditor() {
        return this.getActiveEditor();
    }

    public boolean isOpen(StudioEditor studioEditor) {
        Editor editor = FusionWorkbench.getEditor(studioEditor);
        return editor != null;
    }

    public void openEditor(StudioEditor studioEditor) {
        if (studioEditor != null) {
            Context otherContext = Context.newIdeContext();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(otherContext, FusionEditor.class);
            EditorManager editorManager = FusionWorkbench.getEditorManager();
            editorManager.openEditor(openEditorOptions);
        } else {
            System.out.println("FusionWorkbench.openEditor() StudioEditor is NULL");
        }
    }

    public StudioEditor openEditorForObject(Object object) {
        Node node;
        StudioEditor result;
        Object resource;
        Object part = null;
        if (object instanceof ProjectObject) {
            resource = ((ProjectObject)object).findResourceObject();
            if (object != resource) {
                part = object;
            }
        } else {
            resource = object;
        }
        if ((result = this.findEditorByObject(resource)) == null && (node = this.findNode(resource)) != null) {
            Context otherContext = Context.newIdeContext((Node)node);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(otherContext, FusionEditor.class);
            Editor jdevEditor = FusionWorkbench.getEditorManager().openEditor(openEditorOptions);
            if (jdevEditor instanceof FusionEditor) {
                FusionEditor editor = (FusionEditor)jdevEditor;
                result = editor.getStudioEditor();
            }
        }
        if (result != null) {
            this.activateEditor(result);
            if (part != null) {
                result.openPart(part);
            }
        }
        return result;
    }

    public void openEditor(StudioEditor studioEditor, StudioEditor parent, int offset) {
        this.openEditor(studioEditor);
    }

    public void refreshTitle(StudioEditor studioEditor) {
    }

    public void removeLifeCycleListener(LifeCycleListener listener) {
        EditorListener editorListener = this.lifeCycleListeners.get(listener);
        if (editorListener != null) {
            FusionWorkbench.getEditorManager().addEditorListener(editorListener);
            this.lifeCycleListeners.remove(listener);
        }
    }

    public void showView(String viewId) {
    }

    public boolean isBusinessAnalyst() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        return Product.isBPMStudio() || extensionRegistry.getRoleManager().getActiveRole().getId().equals("oracle.bpm.role");
    }

    public ProjectRepository createRepository() {
        return new FusionProjectRepository();
    }

    public Dialog getDataTransformationDialog(UiWindow ownerWindow, @NotNull DataTransformationsTableModel model, DataTransformation dataTransformation) {
        return null;
    }

    public BpaService getBpaService() {
        return null;
    }

    public void setFocusOnActiveEditor() {
    }

    public CodeEditorService getCodeEditorService() {
        return new CodeEditorService(){

            public CodeEditor getFusionCodeEditor(@NotNull DataDeclarationContainer context, CatalogType resultType) {
                return new FusionCodeEditor(context, resultType);
            }
        };
    }

    public Interceptor getCommandInterceptor() {
        return new FusionCommandInterceptor();
    }

    public boolean isInPreviewMode() {
        return PreviewUtil.isInPreviewMode();
    }

    public BaseAction createGotoCompositeAction() {
        return null;
    }

    protected List<StudioEditor> getAllEditors() {
        ArrayList<StudioEditor> studioEditors = new ArrayList<StudioEditor>();
        List editors = FusionWorkbench.getEditorManager().getAllEditors();
        for (Object element : editors) {
            StudioEditor studioEditor;
            Editor editor = (Editor)element;
            if (!(editor instanceof FusionEditor) || (studioEditor = ((FusionEditor)editor).getStudioEditor()) == null) continue;
            studioEditors.add(studioEditor);
        }
        return studioEditors;
    }

    private static EditorManager getEditorManager() {
        return EditorManager.getEditorManager();
    }

    @Nullable
    private static Editor getEditor(StudioEditor studioEditor) {
        EditorManager editorManager = FusionWorkbench.getEditorManager();
        List list = editorManager.getAllEditors();
        for (Object each : list) {
            Editor editor = (Editor)each;
            StudioEditor currentEditor = FusionWorkbench.getStudioEditor(editor);
            if (currentEditor == null || !studioEditor.equals(currentEditor)) continue;
            return editor;
        }
        return null;
    }

    @Nullable
    private static StudioEditor getStudioEditor(Editor editor) {
        StudioEditor result = null;
        if (editor instanceof FusionEditor) {
            FusionEditor fcpEditor = (FusionEditor)editor;
            result = fcpEditor.getStudioEditor();
        }
        return result;
    }

    private Node findNode(Object object) {
        AdapterService service = Platform.getAdapterService();
        Node node = service.adaptTo(object, Node.class);
        URL url = service.adaptTo(object, URL.class);
        if (node == null) {
            try {
                node = NodeFactory.findOrCreate((URL)url);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        if (node != null && node.getClass().getSimpleName().equals("WSDLArtifactNode")) {
            node = new ProjectObjectNode(url);
        }
        return node;
    }

    private void initSelectionListeners() {
        final EditorManager editorManager = FusionWorkbench.getEditorManager();
        editorManager.addEditorListener(new EditorListener(){

            public void editorActivated(Editor editor) {
                this.editorOpened(editor);
            }

            public void editorDeactivated(Editor editor) {
            }

            public void editorClosed(Editor editor) {
                Editor current = editorManager.getCurrentEditor();
                if (current == null) {
                    Selection selection = DefaultSelection.EMPTY;
                    FusionWorkbench.this.getEditorAreaSelectionProvider().setSelection(selection);
                }
            }

            public void editorOpened(Editor editor) {
                Selection selection = DefaultSelection.createSingle((Object)editor.getContext().getNode());
                FusionWorkbench.this.getEditorAreaSelectionProvider().setSelection(selection);
            }
        });
    }

    private final class LifeCycleAdapter
    implements EditorListener {
        private final LifeCycleListener listener;

        private LifeCycleAdapter(LifeCycleListener listener) {
            this.listener = listener;
        }

        public void editorOpened(Editor editor) {
            StudioEditor studioEditor = FusionWorkbench.getStudioEditor(editor);
            if (studioEditor != null) {
                this.listener.editorOpened(studioEditor);
            }
        }

        public void editorClosed(Editor editor) {
            StudioEditor studioEditor = FusionWorkbench.getStudioEditor(editor);
            if (studioEditor != null) {
                this.listener.editorClosed(studioEditor);
            }
        }

        public void editorActivated(Editor editor) {
        }

        public void editorDeactivated(Editor editor) {
        }
    }
}

