/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.presentationmodel;

import java.io.Serializable;
import oracle.bpm.data.html.BackgroundAttachment;
import oracle.bpm.data.html.BackgroundPositionX;
import oracle.bpm.data.html.BackgroundPositionY;
import oracle.bpm.data.html.BackgroundRepeat;
import oracle.bpm.xobject.presentationmodel.XFormImage;
import oracle.bpm.xobject.xml.XFormXMLObject;

public class XFormBackground
extends XFormXMLObject
implements Serializable {
    public XFormImage image = new XFormImage();
    public String imageattachment;
    public String imagelayout;
    public String imagexposition;
    public String imageyposition;
    static final long serialVersionUID = -336624062728831869L;
    static final long serialCheck = -8815576894394847902L;

    public XFormBackground() {
        this.setImageAttachment(BackgroundAttachment.DEFAULT);
        this.setImageLayout(BackgroundRepeat.DEFAULT);
        this.setImageXPosition(BackgroundPositionX.DEFAULT);
        this.setImageYPosition(BackgroundPositionY.DEFAULT);
    }

    public String getBackGroundPosition() {
        return this.imagexposition + " " + this.imageyposition;
    }

    public void setEncodedImage(String encodedImage) {
        if (this.image == null) {
            this.image = new XFormImage();
        }
        this.image.gifencoded = encodedImage;
    }

    public String getEncodedImage() {
        return this.image.gifencoded;
    }

    public void setImageAttachment(BackgroundAttachment attach) {
        if (attach == null) {
            attach = BackgroundAttachment.DEFAULT;
        }
        this.imageattachment = attach.toStringHtml();
    }

    public BackgroundAttachment getImageAttachment() {
        BackgroundAttachment attachment = BackgroundAttachment.valueOfHtml(this.imageattachment);
        return attachment == null ? BackgroundAttachment.DEFAULT : attachment;
    }

    public void setImageLayout(BackgroundRepeat layout) {
        if (layout == null) {
            layout = BackgroundRepeat.DEFAULT;
        }
        this.imagelayout = layout.toStringHtml();
    }

    public BackgroundRepeat getImageLayout() {
        BackgroundRepeat repeat = BackgroundRepeat.valueOfHtml(this.imagelayout);
        return repeat == null ? BackgroundRepeat.DEFAULT : repeat;
    }

    public void setImageXPosition(BackgroundPositionX pos) {
        if (pos == null) {
            pos = BackgroundPositionX.DEFAULT;
        }
        this.imagexposition = pos.toStringHtml();
    }

    public BackgroundPositionX getImageXPosition() {
        BackgroundPositionX xPosition = BackgroundPositionX.valueOfHtml(this.imagexposition);
        return xPosition == null ? BackgroundPositionX.DEFAULT : xPosition;
    }

    public void setImageYPosition(BackgroundPositionY pos) {
        if (pos == null) {
            pos = BackgroundPositionY.DEFAULT;
        }
        this.imageyposition = pos.toStringHtml();
    }

    public BackgroundPositionY getImageYPosition() {
        BackgroundPositionY yPosition = BackgroundPositionY.valueOfHtml(this.imageyposition);
        return yPosition == null ? BackgroundPositionY.DEFAULT : yPosition;
    }

    @Override
    public String getName() {
        return "background";
    }

    public String toString() {
        String tmp = "XFormBackground\n";
        return tmp;
    }
}

