/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xobject.presentationmodel;

import java.util.Arrays;
import oracle.bpm.data.html.OutputMaskType;
import oracle.bpm.ui.BorderStyle;
import oracle.bpm.xobject.presentationmodel.AlignmentProperties;
import oracle.bpm.xobject.presentationmodel.ColorProperties;

class PropertiesUtils {
    PropertiesUtils() {
    }

    static String getAlignment(String hAlignment) {
        if (!Arrays.asList(AlignmentProperties.POSSIBLE_HORIZONTAL_ALIGNMENT).contains(hAlignment)) {
            return "center";
        }
        return hAlignment;
    }

    static String getBgColor(String bgColor) {
        return PropertiesUtils.getColor(bgColor, ColorProperties.DEFAULT_BACKGROUND_COLOR);
    }

    static String getBgColor(String bgColor, String defaultColor) {
        return PropertiesUtils.getColor(bgColor, defaultColor);
    }

    static String getBorderColor(String borderColor) {
        return PropertiesUtils.getColor(borderColor, "#D0D2D4");
    }

    static String getBorderColor(String borderColor, String defaultColor) {
        return PropertiesUtils.getColor(borderColor, defaultColor);
    }

    static String getBorderStyle(BorderStyle borderStyle) {
        return borderStyle == null ? null : borderStyle.toString();
    }

    static int getBorderWidth(int borderWidth) {
        if (borderWidth < 0) {
            return 1;
        }
        return borderWidth;
    }

    static String getFgColor(String fgColor) {
        return PropertiesUtils.getColor(fgColor, ColorProperties.DEFAULT_FOREGROUND_COLOR);
    }

    static String getFgColor(String fgColor, String defaultColor) {
        return PropertiesUtils.getColor(fgColor, defaultColor);
    }

    static String getFontFace(String fontFace) {
        return fontFace;
    }

    static int getFontSize(int fontSize) {
        if (fontSize <= 0) {
            return 12;
        }
        return fontSize;
    }

    static String getFontType(String fontType) {
        return fontType;
    }

    static int getOutputMaskType(OutputMaskType outputMaskType) {
        return outputMaskType == null ? OutputMaskType.DEFAULT.getValue() : outputMaskType.getValue();
    }

    static String getVAlignment(String vAlignment) {
        if (!Arrays.asList(AlignmentProperties.POSSIBLE_VERTICAL_ALIGNMENT).contains(vAlignment)) {
            return "center";
        }
        return vAlignment;
    }

    static BorderStyle valueOfBorderStyle(String borderStyle) {
        if (borderStyle == null) {
            return null;
        }
        BorderStyle style = PropertiesUtils.getStyle(borderStyle);
        if (style == null) {
            style = PropertiesUtils.getStyle(borderStyle.toUpperCase());
        }
        return style == null ? BorderStyle.DEFAULT : style;
    }

    static OutputMaskType valueOutputMaskType(int outputMaskTypeValue) {
        if (outputMaskTypeValue < 0 && outputMaskTypeValue < OutputMaskType.values().length) {
            return OutputMaskType.DEFAULT;
        }
        OutputMaskType outputMaskType = OutputMaskType.values()[outputMaskTypeValue];
        return outputMaskType == null ? OutputMaskType.DEFAULT : outputMaskType;
    }

    private static BorderStyle getStyle(String borderStyle) {
        try {
            return BorderStyle.valueOf(borderStyle);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private static String getColor(String color, String defaultColor) {
        if (color == null || color.length() != 7 || !color.startsWith("#")) {
            return defaultColor;
        }
        return color;
    }
}

