/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xml;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public abstract class XMLParser {
    private int attrCount_d = 0;
    private int[] attrId_d;
    private String[] attrValue_d;
    private char[] buffer_d = new char[16382];
    private String cdata_d = null;
    private int charCount_d = 0;
    private int charSize_d = 8192;
    private char[] charBuff_d = new char[this.charSize_d];
    private int index_d = 16382;
    private Reader input_d = null;
    private int read_d = 0;
    private StringMap tokenMap_d;
    private int unread_d = -1;
    public static final int COMMENT = -268435456;
    private static final int BUFFER_SIZE = 16382;

    public XMLParser(int maxSize) {
        this.tokenMap_d = new StringMap(maxSize);
        this.attrId_d = new int[maxSize];
        this.attrValue_d = new String[maxSize];
        this.put("!--", -268435456);
    }

    public XMLParser(String[] keys, int[] values) {
        this(keys.length);
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys and values sizes do not match");
        }
        for (int i = 0; i < keys.length; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    protected abstract void endElement(int var1);

    protected abstract void processCDATA();

    protected abstract void startElement(int var1);

    protected final int getAttributeCount() {
        return this.attrCount_d;
    }

    protected final int getAttributeID(int index) {
        return this.attrId_d[index];
    }

    protected final String getAttributeValue(int index) {
        return this.attrValue_d[index];
    }

    protected final String getCDATA() {
        if (this.cdata_d == null) {
            this.cdata_d = new String(this.charBuff_d, 0, this.charCount_d);
        }
        return this.cdata_d;
    }

    protected void setInput(Reader r) {
        this.input_d = r;
        this.clearCDATA();
        this.index_d = 16382;
        this.read_d = 0;
        this.unread_d = -1;
    }

    protected void parse() throws IOException {
        int c = this.read();
        while (c != -1) {
            if (c == 60) {
                this.processCDATA();
                this.clearCDATA();
                this.parseTag();
            } else {
                this.append(c);
            }
            c = this.read();
        }
    }

    protected void put(String key, int id) {
        this.tokenMap_d.put(key, XMLParser.hash(key), id);
    }

    private static int hash(String s) {
        int h = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            int g = (h = (h << 3) + (h >>> 28) + (c >= 96 ? c - 40 : c)) & 0xF0000000;
            if (g == 0) continue;
            h = h ^ g >>> 24 ^ g;
        }
        return h & 0x3FFFFFFF;
    }

    private void append(int c) {
        try {
            this.charBuff_d[this.charCount_d] = (char)c;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            char[] nc = new char[this.charCount_d * 2];
            System.arraycopy(nc, 0, this.charBuff_d, 0, this.charBuff_d.length);
            this.charBuff_d = nc;
            this.charBuff_d[this.charCount_d] = (char)c;
        }
        ++this.charCount_d;
    }

    private void clearCDATA() {
        this.charCount_d = 0;
        this.cdata_d = null;
    }

    private void parseAttribute() throws IOException {
        String value = "";
        this.skipWhitespace(true);
        int id = this.parseID();
        this.skipWhitespace(true);
        int c = this.read();
        if (c == 61) {
            this.skipWhitespace(true);
            c = this.read();
            if (c == 34) {
                value = this.parseString();
            } else {
                this.unread(c);
                this.parseID();
                value = this.getCDATA();
            }
        } else {
            this.unread(c);
        }
        try {
            this.attrId_d[this.attrCount_d] = id;
            this.attrValue_d[this.attrCount_d] = value;
            ++this.attrCount_d;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            int nLen = this.attrId_d.length << 1;
            int[] nId = new int[nLen];
            String[] nVal = new String[nLen];
            System.arraycopy(this.attrId_d, 0, nId, 0, this.attrId_d.length);
            System.arraycopy(this.attrValue_d, 0, nVal, 0, this.attrValue_d.length);
            this.attrId_d = nId;
            this.attrValue_d = nVal;
            this.attrId_d[this.attrCount_d] = id;
            this.attrValue_d[this.attrCount_d] = value;
            ++this.attrCount_d;
        }
    }

    private int parseID() throws IOException {
        int c;
        int h = 0;
        this.clearCDATA();
        block3: while (true) {
            c = this.read();
            switch (c) {
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 61: 
                case 62: {
                    break block3;
                }
                default: {
                    h = (h << 3) + (h >>> 28) + (c >= 96 ? c - 40 : c);
                    int g = h & 0xF0000000;
                    if (g != 0) {
                        h = h ^ g >>> 24 ^ g;
                    }
                    this.append(c);
                    continue block3;
                }
            }
            break;
        }
        this.unread(c);
        String k = this.getCDATA();
        int id = this.tokenMap_d.get(k, h &= 0x3FFFFFFF);
        return id;
    }

    private String parseString() throws IOException {
        this.clearCDATA();
        block4: while (true) {
            int c = this.read();
            switch (c) {
                case -1: {
                    throw new EOFException("Parsing STRING");
                }
                case 34: {
                    break block4;
                }
                default: {
                    this.append(c);
                    continue block4;
                }
            }
            break;
        }
        return this.getCDATA();
    }

    private void parseTag() throws IOException {
        boolean isEnd = false;
        boolean closed = false;
        int c = this.read();
        if (c == 47) {
            isEnd = true;
        } else {
            this.unread(c);
        }
        int id = this.parseID();
        if (id == -268435456) {
            int hyph = 0;
            while (true) {
                c = this.read();
                if (hyph != 2 || c != 62) {
                    if (c == -1) {
                        throw new EOFException("Unterminated comment");
                    }
                    if (c == 45) {
                        ++hyph;
                        continue;
                    }
                    hyph = 0;
                    continue;
                }
                break;
            }
        } else {
            this.attrCount_d = 0;
            this.skipWhitespace(true);
            c = this.read();
            while (c != 62 && c != 47) {
                if (c == -1) {
                    throw new EOFException("Unterminated tag");
                }
                this.unread(c);
                this.parseAttribute();
                c = this.read();
            }
            if (c == 47) {
                closed = true;
                c = this.read();
            }
            if (c != 62) {
                throw new IOException("Malformed tag");
            }
            if (isEnd) {
                this.endElement(id);
            } else {
                this.startElement(id);
                if (closed) {
                    this.endElement(id);
                }
            }
        }
    }

    private int read() throws IOException {
        int next;
        if (this.unread_d != -1) {
            next = this.unread_d;
            this.unread_d = -1;
        } else {
            if (this.index_d == 16382) {
                this.index_d = 0;
                this.read_d = this.input_d.read(this.buffer_d, 0, 16382);
            }
            next = this.index_d >= this.read_d ? -1 : this.buffer_d[this.index_d++];
        }
        return next;
    }

    private void skipWhitespace(boolean fail) throws IOException {
        int c;
        do {
            c = this.read();
            if (!fail || c != -1) continue;
            throw new EOFException("Unexpected EOF");
        } while (c == 32 || c == 9 || c == 10 || c == 13);
        this.unread(c);
    }

    private void unread(int c) {
        this.unread_d = c;
    }

    private static class StringMap {
        private boolean[] collision_d;
        private int currentSize_d = 0;
        private int elementCount_d = 0;
        private int[] hashes_d;
        private String[] keys_d;
        private int size_d = 0;
        private int[] values_d;
        private static final int[] hashSizes_sd = new int[]{13, 23, 251, 509, 1021, 2039, 4093, 8191, 16381, 32749, 65521, 131071, 262139, 524287, 1048573, 0x1FFFF7, 0x3FFFFD, 0x7FFFF1, 0xFFFFFD};
        private static final double loadFactor_sd = 0.7;

        public StringMap(int maximumSize) {
            this.size_d = StringMap.findSize(maximumSize);
            this.currentSize_d = hashSizes_sd[this.size_d];
            this.keys_d = new String[this.currentSize_d];
            this.values_d = new int[this.currentSize_d];
            this.hashes_d = new int[this.currentSize_d];
            this.collision_d = new boolean[this.currentSize_d];
        }

        public final int get(int hash) {
            int index = hash % this.currentSize_d;
            if (this.keys_d[index] != null && !this.collision_d[index]) {
                return this.values_d[index];
            }
            return -1;
        }

        public final int get(String key, int hash) {
            int index = hash % this.currentSize_d;
            if (this.keys_d[index] != null && !this.collision_d[index] && this.keys_d[index].equals(key)) {
                return this.values_d[index];
            }
            while (this.keys_d[index] != null && this.hashes_d[index] != hash && !this.keys_d[index].equals(key)) {
                if (++index != this.currentSize_d) continue;
                index = 0;
            }
            if (this.keys_d[index] != null && this.keys_d[index].equals(key)) {
                return this.values_d[index];
            }
            return -1;
        }

        public final void put(String key, int hash, int value) {
            if ((double)this.elementCount_d > (double)this.currentSize_d * 0.7) {
                throw new UnsupportedOperationException("Size limit exceeded");
            }
            int index = hash % this.currentSize_d;
            boolean collision = false;
            while (this.keys_d[index] != null && this.hashes_d[index] != hash && !this.keys_d[index].equals(key)) {
                ++index;
                if (!collision) {
                    this.collision_d[index - 1] = true;
                    collision = true;
                }
                if (index != this.currentSize_d) continue;
                index = 0;
            }
            if (this.keys_d[index] == null) {
                ++this.elementCount_d;
            }
            this.collision_d[index] = collision;
            this.keys_d[index] = key;
            this.values_d[index] = value;
            this.hashes_d[index] = hash;
        }

        private static int findSize(int i) {
            for (int j = 0; j < hashSizes_sd.length; ++j) {
                if (i >= hashSizes_sd[j] || !((double)i / (double)hashSizes_sd[j] < 0.7)) continue;
                return j;
            }
            return -1;
        }
    }
}

