/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.mgmt;

import java.util.Collection;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.view.InstancesViewImpl;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.ViewType;

public class ViewCache {
    private SortedSet<String> customViewsIds = null;
    private SortedSet<String> defaultViewsIds = null;
    private HashSet<InstancesViewImpl> instancesView = null;
    private SortedStringMap<SortedSet<String>> viewIdsPerRole = null;
    private SortedStringMap<ViewImpl> views = SortedStringMap.createCaseInsensitive();
    private SortedStringMap<SortedStringMap<ViewImpl>> viewsPerParticipant = SortedStringMap.createCaseInsensitive();

    protected ViewCache() {
        this.viewIdsPerRole = SortedStringMap.createCaseInsensitive();
        this.defaultViewsIds = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.customViewsIds = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.instancesView = new HashSet();
    }

    public SortedStringMap<ViewImpl> getCustomViews() {
        SortedStringMap<ViewImpl> auxViews = SortedStringMap.createCaseInsensitive();
        for (String viewId : this.customViewsIds) {
            ViewImpl view = (ViewImpl)this.views.get(viewId);
            if (view == null) continue;
            auxViews.put(view.getId(), view);
        }
        return auxViews;
    }

    public void setCustomViewsIds(SortedSet<String> newCustomViewsIds) {
        this.customViewsIds = newCustomViewsIds;
    }

    public boolean isDefaultView(String viewId) {
        return this.defaultViewsIds.contains(viewId);
    }

    public SortedStringMap<ViewImpl> getDefaultViews() {
        SortedStringMap<ViewImpl> auxViews = SortedStringMap.createCaseInsensitive();
        for (String viewId : this.defaultViewsIds) {
            ViewImpl view = (ViewImpl)this.views.get(viewId);
            if (view == null) continue;
            auxViews.put(viewId, view);
        }
        return auxViews;
    }

    public SortedSet<String> getDefaultViewsIds() {
        return this.defaultViewsIds;
    }

    public Collection<InstancesViewImpl> getInstancesView() {
        return this.instancesView;
    }

    public SortedStringMap<ViewImpl> getParticipantViews(String participantId) {
        return (SortedStringMap)this.viewsPerParticipant.get(participantId);
    }

    public ViewImpl getView(String viewId) {
        return (ViewImpl)this.views.get(viewId);
    }

    public SortedSet<String> getViewIdsArrayForRole(String roleId) {
        TreeSet views = this.getViewIdsForRole(roleId);
        return views == null ? new TreeSet() : views;
    }

    public void setViewIdsPerRole(SortedStringMap<SortedSet<String>> newViewsPerRole) {
        this.viewIdsPerRole = newViewsPerRole;
    }

    public SortedStringMap<ViewImpl> getViews() {
        return this.views;
    }

    public synchronized void addView(ViewImpl view) {
        ViewImpl oldView = (ViewImpl)this.views.get(view.getId());
        if (oldView != null) {
            this.updateView(view);
        } else {
            String[] assignedRoles;
            if (view.isCustom()) {
                this.customViewsIds.add(view.getId());
            } else {
                this.defaultViewsIds.add(view.getId());
            }
            for (String assignedRole : assignedRoles = view.getAssignedRoles()) {
                this.putViewIdToRole(assignedRole, view.getId());
            }
            this.views.put(view.getId(), view);
        }
        this.addInstancesView(view);
    }

    public synchronized void clearParticipantViews(String participantId) {
        this.viewsPerParticipant.remove(participantId);
    }

    public void putView(String viewId, ViewImpl view) {
        this.addView(view);
    }

    public void putViewsPerParticipant(String participantId, SortedStringMap<ViewImpl> participantViews) {
        this.viewsPerParticipant.put(participantId, participantViews);
        for (ViewImpl view : participantViews.values()) {
            this.addInstancesView(view);
        }
    }

    public SortedStringMap releaseViewsForParticipant(String participantId) {
        SortedStringMap result = (SortedStringMap)this.viewsPerParticipant.remove(participantId);
        if (result != null) {
            this.removeInstancesView(result.values());
        }
        return result;
    }

    public void removeView(String viewId) {
        this.removeViewIdForRoles(viewId);
        this.removeViewIdFromCustomViewIds(viewId);
        this.removeViewIdFromDefaultViewIds(viewId);
        ViewImpl view = (ViewImpl)this.views.remove(viewId);
        if (view != null) {
            this.removeInstancesView(view);
        }
    }

    public void release() {
        this.customViewsIds.clear();
        this.defaultViewsIds.clear();
        this.instancesView.clear();
        this.viewIdsPerRole.clear();
        this.views.clear();
        this.viewsPerParticipant.clear();
    }

    public void updateView(ViewImpl view) {
        String[] roles;
        ViewImpl oldView = (ViewImpl)this.views.get(view.getId());
        if (oldView != null) {
            for (String role : roles = oldView.getAssignedRoles()) {
                this.removeViewIdForRole(role, view.getId());
            }
            if (oldView.isCustom() && !view.isCustom()) {
                this.customViewsIds.remove(view.getId());
            } else if (!oldView.isCustom() && view.isCustom()) {
                this.defaultViewsIds.remove(view.getId());
            }
            this.removeInstancesView(oldView);
        }
        if (view.isCustom()) {
            this.customViewsIds.add(view.getId());
        } else {
            this.defaultViewsIds.add(view.getId());
        }
        for (String role : roles = view.getAssignedRoles()) {
            this.putViewIdToRole(role, view.getId());
        }
        this.views.put(view.getId(), view);
        this.addInstancesView(view);
    }

    protected SortedStringMap getViewIdsPerRoles() {
        return this.viewIdsPerRole;
    }

    protected void setViews(SortedStringMap<ViewImpl> newViews) {
        this.customViewsIds.clear();
        this.defaultViewsIds.clear();
        this.instancesView.clear();
        this.viewIdsPerRole.clear();
        this.views.clear();
        Collection<ViewImpl> viewsImpl = newViews.values();
        this.setCustomViews(viewsImpl);
        this.setDefaultViews(viewsImpl);
        this.setViewsPerRole(viewsImpl);
        this.setInstancesView(viewsImpl);
        this.views = newViews;
    }

    private void setCustomViews(Collection<ViewImpl> views) {
        TreeSet<String> customViewsIds = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ViewImpl view : views) {
            if (!view.isCustom()) continue;
            customViewsIds.add(view.getId());
        }
        this.setCustomViewsIds(customViewsIds);
    }

    private void putViewIdToRole(String roleId, String viewId) {
        SortedSet<String> viewIdsPerRole = this.getViewIdsForRole(roleId);
        if (viewIdsPerRole == null) {
            viewIdsPerRole = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            viewIdsPerRole.add(viewId);
            this.putViewIdsToRole(roleId, viewIdsPerRole);
        } else {
            viewIdsPerRole.add(viewId);
        }
    }

    private void removeViewIdForRole(String roleId, String viewId) {
        SortedSet viewIdsForRole = (SortedSet)this.viewIdsPerRole.get(roleId);
        if (viewIdsForRole != null) {
            viewIdsForRole.remove(viewId);
        }
    }

    private void removeViewIdForRoles(String viewId) {
        String[] roles;
        for (String role : roles = this.viewIdsPerRole.keySet().toArray(new String[this.viewIdsPerRole.size()])) {
            this.removeViewIdForRole(role, viewId);
        }
    }

    private void removeViewIdFromCustomViewIds(String customViewId) {
        this.customViewsIds.remove(customViewId);
    }

    private void removeViewIdFromDefaultViewIds(String defaultViewId) {
        this.defaultViewsIds.remove(defaultViewId);
    }

    private void setDefaultViews(Collection<ViewImpl> views) {
        TreeSet<String> defaultViewsIds = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (ViewImpl view : views) {
            if (view.isCustom()) continue;
            defaultViewsIds.add(view.getId());
        }
        this.setDefaultViewsIds(defaultViewsIds);
    }

    private void setDefaultViewsIds(SortedSet<String> newDefaultViews) {
        this.defaultViewsIds = newDefaultViews;
    }

    private SortedSet<String> getViewIdsForRole(String roleId) {
        return (SortedSet)this.viewIdsPerRole.get(roleId);
    }

    private void setViewsPerRole(Collection<ViewImpl> views) {
        for (ViewImpl view : views) {
            for (String role : view.getAssignedRoles()) {
                this.putViewIdToRole(role, view.getId());
            }
        }
    }

    private void putViewIdsToRole(String roleId, SortedSet<String> viewIds) {
        this.viewIdsPerRole.put(roleId, viewIds);
    }

    private void setInstancesView(Collection<ViewImpl> views) {
        HashSet<InstancesViewImpl> _instancesView = new HashSet<InstancesViewImpl>();
        for (ViewImpl view : views) {
            if (view.getType() != ViewType.INSTANCES && view.getType() != ViewType.ACTIVITY_INSTANCES) continue;
            InstancesViewImpl iView = (InstancesViewImpl)view;
            _instancesView.add(iView);
        }
        this.instancesView = _instancesView;
    }

    private void addInstancesView(ViewImpl view) {
        if (view.getType() == ViewType.INSTANCES || view.getType() == ViewType.ACTIVITY_INSTANCES) {
            InstancesViewImpl iView = (InstancesViewImpl)view;
            HashSet<InstancesViewImpl> _instancesView = new HashSet<InstancesViewImpl>();
            _instancesView.addAll(this.instancesView);
            _instancesView.add(iView);
            this.instancesView = _instancesView;
        }
    }

    private void removeInstancesView(Collection<ViewImpl> views) {
        HashSet<InstancesViewImpl> _instancesView = new HashSet<InstancesViewImpl>();
        _instancesView.addAll(this.instancesView);
        for (ViewImpl view : views) {
            if (view.getType() != ViewType.INSTANCES && view.getType() != ViewType.ACTIVITY_INSTANCES) continue;
            InstancesViewImpl iView = (InstancesViewImpl)view;
            _instancesView.remove(iView);
        }
        this.instancesView = _instancesView;
    }

    private void removeInstancesView(ViewImpl view) {
        if (view.getType() == ViewType.INSTANCES || view.getType() == ViewType.ACTIVITY_INSTANCES) {
            InstancesViewImpl iView = (InstancesViewImpl)view;
            HashSet<InstancesViewImpl> _instancesView = new HashSet<InstancesViewImpl>();
            _instancesView.addAll(this.instancesView);
            _instancesView.remove(iView);
            this.instancesView = _instancesView;
        }
    }
}

