/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.mgmt;

import fuego.papi.OperationException;
import java.io.Writer;
import java.util.List;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.PresentationType;
import oracle.bpm.view.Variable;
import oracle.bpm.view.ViewType;
import oracle.bpm.view.io.PresentationLoader;
import oracle.bpm.view.mgmt.PresentationCache;
import oracle.bpm.view.mgmt.VariableManager;

public class PresentationManager {
    private final PresentationCache cache = new PresentationCache();
    private PresentationLoader presentationLoader;
    public static final String PRESENTATION_FDI_CATEGORY = "fuego-presentations";
    private static PresentationImpl defaultInstancesPresentation = null;
    private static PresentationImpl defaultApplicationsPresentation = null;
    private static PresentationImpl defaultAttachemetsPresentation = null;
    private static PresentationImpl defaultActivityPresentation = null;
    private static PresentationImpl defaultFolderPresentation = null;

    public PresentationManager(PresentationLoader presentationLoader) {
        this.presentationLoader = presentationLoader;
    }

    public static PresentationImpl getDefaultActivityPresentation() {
        if (defaultActivityPresentation == null) {
            List<Variable> defaultVariables = VariableManager.getDefaultInstanceVariables();
            PresentationImpl.Column[] defaultPresentationColumns = new PresentationImpl.Column[6];
            int index = 0;
            for (Variable defaultVariable : defaultVariables) {
                if (!defaultVariable.getId().equalsIgnoreCase("PREDEFINE_DESCRIPTION") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_PRIORITY") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_STATUS") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_RECEIVED TIME") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_DEADLINE") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_PARTICIPANT")) continue;
                defaultPresentationColumns[index] = new PresentationImpl.Column(defaultVariable);
                ++index;
            }
            defaultActivityPresentation = new PresentationImpl(PresentationType.INSTANCES, "default_activity", defaultPresentationColumns);
        }
        return defaultActivityPresentation.copy(defaultActivityPresentation.getId());
    }

    public static PresentationImpl getDefaultApplicationsPresentation() {
        if (defaultApplicationsPresentation == null) {
            List<Variable> defaultVariables = VariableManager.getDefaultApplicationVariables();
            PresentationImpl.Column[] defaultPresentationColumns = new PresentationImpl.Column[defaultVariables.size()];
            int size = defaultVariables.size();
            for (int i = 0; i < size; ++i) {
                defaultPresentationColumns[i] = new PresentationImpl.Column(defaultVariables.get(i));
            }
            defaultApplicationsPresentation = new PresentationImpl(PresentationType.APPLICATIONS, "default_applications", defaultPresentationColumns);
        }
        return defaultApplicationsPresentation.copy(defaultApplicationsPresentation.getId());
    }

    public static PresentationImpl getDefaultAttachmentsPresentation() {
        if (defaultAttachemetsPresentation == null) {
            List<Variable> defaultVariables = VariableManager.getDefaultAttachmentVariables();
            PresentationImpl.Column[] defaultPresentationColumns = new PresentationImpl.Column[defaultVariables.size()];
            int size = defaultVariables.size();
            for (int i = 0; i < size; ++i) {
                defaultPresentationColumns[i] = new PresentationImpl.Column(defaultVariables.get(i));
            }
            defaultAttachemetsPresentation = new PresentationImpl(PresentationType.ATTACHMENTS, "default_attachments", defaultPresentationColumns);
        }
        return defaultAttachemetsPresentation.copy(defaultAttachemetsPresentation.getId());
    }

    public static PresentationImpl getDefaultFolderPresentation() {
        if (defaultFolderPresentation == null) {
            defaultFolderPresentation = new PresentationImpl(PresentationType.FOLDER, "default_folder", new PresentationImpl.Column[0]);
        }
        return defaultFolderPresentation.copy(defaultFolderPresentation.getId());
    }

    public static PresentationImpl getDefaultInstancesPresentation() {
        if (defaultInstancesPresentation == null) {
            List<Variable> defaultVariables = VariableManager.getDefaultInstanceVariables();
            PresentationImpl.Column[] defaultPresentationColumns = new PresentationImpl.Column[8];
            int index = 0;
            for (Variable defaultVariable : defaultVariables) {
                if (!defaultVariable.getId().equalsIgnoreCase("PREDEFINE_HAS_ATTACHMENTS") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_DESCRIPTION") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_ACTIVITY") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_PRIORITY") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_STATUS") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_RECEIVED TIME") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_DEADLINE") && !defaultVariable.getId().equalsIgnoreCase("PREDEFINE_PARTICIPANT")) continue;
                defaultPresentationColumns[index] = new PresentationImpl.Column(defaultVariable);
                ++index;
            }
            defaultInstancesPresentation = new PresentationImpl(PresentationType.INSTANCES, "default_instances", defaultPresentationColumns);
        }
        return defaultInstancesPresentation.copy(defaultInstancesPresentation.getId());
    }

    public static PresentationImpl getDefaultPresentation(ViewType viewType) {
        if (viewType == ViewType.APPLICATIONS) {
            return PresentationManager.getDefaultApplicationsPresentation();
        }
        if (viewType == ViewType.ATTACHMENTS) {
            return PresentationManager.getDefaultAttachmentsPresentation();
        }
        if (viewType == ViewType.ACTIVITY_INSTANCES) {
            return PresentationManager.getDefaultActivityPresentation();
        }
        if (viewType == ViewType.FOLDER) {
            return PresentationManager.getDefaultFolderPresentation();
        }
        return PresentationManager.getDefaultInstancesPresentation();
    }

    public static PresentationImpl getDefaultPresentation(PresentationType presentationType) {
        if (presentationType == PresentationType.INSTANCES) {
            return PresentationManager.getDefaultInstancesPresentation();
        }
        if (presentationType == PresentationType.APPLICATIONS) {
            return PresentationManager.getDefaultApplicationsPresentation();
        }
        if (presentationType == PresentationType.ATTACHMENTS) {
            return PresentationManager.getDefaultAttachmentsPresentation();
        }
        return PresentationManager.getDefaultFolderPresentation();
    }

    public static PresentationImpl[] getDefaultPresentations() {
        PresentationImpl[] presentations = new PresentationImpl[]{PresentationManager.getDefaultInstancesPresentation(), PresentationManager.getDefaultActivityPresentation(), PresentationManager.getDefaultAttachmentsPresentation(), PresentationManager.getDefaultApplicationsPresentation(), PresentationManager.getDefaultFolderPresentation()};
        return presentations;
    }

    public SortedStringMap<PresentationImpl> getOrganizationPresentations() {
        return this.getOrganizationPresentations(this.presentationLoader);
    }

    public SortedStringMap<PresentationImpl> getOrganizationPresentations(PresentationLoader presentationLoader) {
        return this.getOrganizationPresentations(presentationLoader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedStringMap<PresentationImpl> getOrganizationPresentations(PresentationLoader presentationLoader, boolean reload) {
        SortedStringMap<PresentationImpl> presentations = this.cache.getOrganizational();
        if (presentations.size() == 0 || reload) {
            PresentationCache presentationCache = this.cache;
            synchronized (presentationCache) {
                PresentationImpl[] defaultPresentations;
                for (PresentationImpl defaultPresentation : defaultPresentations = PresentationManager.getDefaultPresentations()) {
                    presentations.put(defaultPresentation.getId(), defaultPresentation);
                    this.cache.put(defaultPresentation);
                }
                if (presentationLoader != null) {
                    presentations = presentationLoader.loadOrganizationPresentations();
                    for (PresentationImpl presentation : presentations.values()) {
                        this.cache.put(presentation);
                    }
                }
            }
        }
        return presentations;
    }

    public PresentationImpl getOrganizationPresentation(String presentationId) {
        return this.getOrganizationPresentation(presentationId, this.presentationLoader);
    }

    public PresentationImpl getOrganizationPresentation(String presentationId, PresentationLoader presentationLoader) {
        return (PresentationImpl)this.getOrganizationPresentations(presentationLoader).get(presentationId);
    }

    public SortedStringMap<PresentationImpl> getParticipantPresentations(String participantId) {
        return this.getParticipantPresentations(participantId, this.presentationLoader);
    }

    public boolean hasParticipantPresentations(String participantId) {
        return this.cache.getParticipant(participantId) != null;
    }

    public SortedStringMap<PresentationImpl> getParticipantPresentations(String participantId, PresentationLoader presentationLoader) {
        SortedStringMap<PresentationImpl> presentations = SortedStringMap.createCaseInsensitive();
        SortedStringMap<PresentationImpl> presentationsBuffer = this.getOrganizationPresentations(presentationLoader);
        for (PresentationImpl presentation : presentationsBuffer.values()) {
            presentations.put(presentation.getId(), presentation.copy(presentation.getId()));
        }
        presentationsBuffer = this.cache.getParticipant(participantId);
        if (presentationsBuffer == null && presentationLoader != null) {
            presentationsBuffer = presentationLoader.loadParticipantPresnetations(participantId);
            for (PresentationImpl presentation : presentationsBuffer.values()) {
                this.cache.put(presentation, participantId);
            }
        }
        if (presentationsBuffer != null) {
            for (PresentationImpl presentation : presentationsBuffer.values()) {
                presentations.put(presentation.getId(), presentation.copy(presentation.getId()));
            }
        }
        return presentations;
    }

    public PresentationImpl getParticipantPresentation(String participantId, String presentationId) {
        return (PresentationImpl)this.getParticipantPresentations(participantId).get(presentationId);
    }

    public PresentationImpl getParticipantPresentation(String participantId, String presentationId, PresentationLoader presentationLoader) {
        return (PresentationImpl)this.getParticipantPresentations(participantId, presentationLoader).get(presentationId);
    }

    public void put(PresentationImpl presentation) {
        this.cache.put(presentation);
    }

    public void put(PresentationImpl presentation, String participantId) {
        this.cache.put(presentation, participantId);
    }

    public void releaseCache() {
        this.cache.release();
    }

    public void releaseOrganizationalPresentations() {
        this.cache.releaseOrganizationalPresentations();
    }

    public void releaseParticipantPresentations(String participantId) {
        this.cache.releaseParticipantPresentations(participantId);
    }

    public void remove(String presentationId) {
        this.remove(presentationId, this.presentationLoader);
        this.cache.remove(presentationId);
    }

    public void remove(String presentationId, String participantId) {
        this.cache.remove(presentationId, participantId);
    }

    public void removeOrganizationalPresentation(String presentationId) throws OperationException {
        this.removeOrganizationalPresentation(presentationId, this.presentationLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOrganizationalPresentation(String presentationId, PresentationLoader presentationLoader) throws OperationException {
        if (presentationLoader != null) {
            presentationLoader.removeOrganizationPresentation(presentationId);
        }
        PresentationCache presentationCache = this.cache;
        synchronized (presentationCache) {
            this.cache.remove(presentationId);
        }
    }

    public void removeParticipantPresentation(String participantId, String presentationId) throws OperationException {
        this.removeParticipantPresentation(participantId, presentationId, this.presentationLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipantPresentation(String participantId, String presentationId, PresentationLoader presentationLoader) throws OperationException {
        if (presentationLoader != null) {
            presentationLoader.removeParticipantPresentation(participantId, presentationId);
        }
        PresentationCache presentationCache = this.cache;
        synchronized (presentationCache) {
            this.cache.remove(presentationId, participantId);
        }
    }

    public void storeOrganizationalPresentation(PresentationImpl presentation, Writer writer) throws OperationException {
        this.storeOrganizationalPresentation(presentation, this.presentationLoader, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeOrganizationalPresentation(PresentationImpl presentation, PresentationLoader presentationLoader, Writer writer) throws OperationException {
        PresentationCache presentationCache = this.cache;
        synchronized (presentationCache) {
            this.cache.put(presentation);
        }
        if (presentationLoader != null) {
            presentationLoader.storeOrganizationPresentation(presentation, writer);
        }
    }

    public void storeParticipantPresentation(String participant, PresentationImpl presentation) throws OperationException {
        this.storeParticipantPresentation(participant, presentation, this.presentationLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeParticipantPresentation(String participant, PresentationImpl presentation, PresentationLoader presentationLoader) throws OperationException {
        PresentationCache presentationCache = this.cache;
        synchronized (presentationCache) {
            this.cache.put(presentation, participant);
        }
        if (presentationLoader != null) {
            presentationLoader.storeParticipantPresentation(participant, presentation);
        }
    }

    public void release() {
        this.cache.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePresentation(PresentationImpl presentationImpl) {
        PresentationCache presentationCache = this.cache;
        synchronized (presentationCache) {
            this.cache.put(presentationImpl);
        }
    }

    private void remove(String presentationId, PresentationLoader presentationLoader2) {
        if (presentationLoader2 != null) {
            presentationLoader2.removeOrganizationPresentation(presentationId);
        }
        this.cache.remove(presentationId);
    }

    public static interface PresentationUpdateListener {
        public void refresh();
    }
}

