/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.mgmt;

import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.view.PresentationImpl;

public class PresentationCache {
    private SortedStringMap<PresentationImpl> organizationalPresentations = SortedStringMap.createCaseInsensitive();
    private SortedStringMap<SortedStringMap<PresentationImpl>> participantPresentations = SortedStringMap.createCaseInsensitive();

    public SortedStringMap<PresentationImpl> getOrganizational() {
        return this.organizationalPresentations;
    }

    public SortedStringMap<PresentationImpl> getParticipant(String participantId) {
        return (SortedStringMap)this.participantPresentations.get(participantId);
    }

    public SortedStringMap<SortedStringMap<PresentationImpl>> getParticipants() {
        return this.participantPresentations;
    }

    public PresentationImpl get(String presentationId) {
        return (PresentationImpl)this.organizationalPresentations.get(presentationId);
    }

    public PresentationImpl get(String presentationId, String participantId) {
        SortedStringMap participantPresentations = (SortedStringMap)this.participantPresentations.get(participantId);
        if (participantPresentations != null) {
            return (PresentationImpl)participantPresentations.get(presentationId);
        }
        return null;
    }

    public void put(PresentationImpl presentation) {
        this.organizationalPresentations.put(presentation.getId(), presentation);
    }

    public void put(PresentationImpl presentation, String participantId) {
        SortedStringMap<PresentationImpl> participantPresentations = (SortedStringMap<PresentationImpl>)this.participantPresentations.get(participantId);
        if (participantPresentations == null) {
            participantPresentations = SortedStringMap.createCaseInsensitive();
            this.participantPresentations.put(participantId, participantPresentations);
        }
        participantPresentations.put(presentation.getId(), presentation);
    }

    public void release() {
        this.organizationalPresentations = SortedStringMap.createCaseInsensitive();
        this.participantPresentations = SortedStringMap.createCaseInsensitive();
    }

    public void releaseOrganizationalPresentations() {
        this.organizationalPresentations = SortedStringMap.createCaseInsensitive();
    }

    public void releaseParticipantPresentations(String participantId) {
        this.participantPresentations.remove(participantId);
    }

    public PresentationImpl remove(String presentationId) {
        return (PresentationImpl)this.organizationalPresentations.remove(presentationId);
    }

    public PresentationImpl remove(String presentationId, String participantId) {
        SortedStringMap participantPresentations = (SortedStringMap)this.participantPresentations.get(participantId);
        if (participantPresentations != null) {
            return (PresentationImpl)participantPresentations.remove(presentationId);
        }
        return null;
    }
}

