/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.mgmt;

import fuego.directory.DirOrganizationalUnit;
import fuego.papi.msg.PapiMsg;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.view.ApplicationsViewImpl;
import oracle.bpm.view.AttachmentsViewImpl;
import oracle.bpm.view.BookmarkViewImpl;
import oracle.bpm.view.ConsultationsViewImpl;
import oracle.bpm.view.FilterImpl;
import oracle.bpm.view.FolderViewImpl;
import oracle.bpm.view.HistoryViewImpl;
import oracle.bpm.view.InstancesViewImpl;
import oracle.bpm.view.ParticipantScope;
import oracle.bpm.view.SearchScope;
import oracle.bpm.view.StatusScope;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.ViewsGenerationType;
import oracle.bpm.view.mgmt.ProcessManager;

public class DefaultViewGenerator {
    private ProcessManager processManager;

    public DefaultViewGenerator(ProcessManager processManager) {
        this.processManager = processManager;
    }

    public static SortedStringMap<ViewImpl> getDefaultViews(ProcessManager processManager, ViewsGenerationType viewType) {
        DefaultViewGenerator defaultViewGenerator = new DefaultViewGenerator(processManager);
        return defaultViewGenerator.getDefaultViews(viewType);
    }

    public static String getDefaultActivityViewId(String ou, String process, String activity) {
        return DefaultViewGenerator.generateViewId(process, ou) + "/" + activity;
    }

    public static String getDefaultProcessViewId(String ou, String process) {
        return DefaultViewGenerator.generateViewId(process, ou);
    }

    public static String generateViewId(String viewId, String ou) {
        String result = viewId;
        if (ou != null && !DirOrganizationalUnit.isRootId(ou)) {
            result = ou.replace('/', '_') + "_" + result;
        }
        return result;
    }

    public SortedStringMap<ViewImpl> getDefaultViews(ViewsGenerationType vgType) {
        String[] processes = this.processManager.getProcesses();
        SortedStringMap<ViewImpl> views = SortedStringMap.createCaseInsensitive();
        for (String process : processes) {
            if (this.processManager.isAutomaticProcess(process)) continue;
            if (this.processManager.getInteractiveRoles(process).length > 0) {
                this.addView(views, this.getDefaultInstancesViews(process, this.processManager.getRoles(), vgType));
                this.addView(views, this.getDefaultAttachmentsView(process));
                this.addView(views, this.getDefaultBookmarkView(process));
                this.addView(views, this.getDefaultConsultationView(process));
                this.addView(views, this.getDefaultHistoryViews(process));
            } else if (vgType != ViewsGenerationType.UNIFIED_INBOX) {
                this.addView(views, this.getDefaultInstancesViews(process, this.processManager.getRoles(), false));
            }
            if (this.processManager.getApplicationRoles(process).length <= 0) continue;
            this.addView(views, this.getDefaultApplicationsView(process, vgType));
        }
        return views;
    }

    public ApplicationsViewImpl getDefaultApplicationsView(String process, ViewsGenerationType vgTypes) {
        if (vgTypes == ViewsGenerationType.UNIFIED_INBOX) {
            return this.getDefaultGlobalApplicationsView(process);
        }
        return this.getDefaultProcessApplicationsView(process);
    }

    private String getActivityName(String activity) {
        int indexOf = activity.lastIndexOf("/");
        if (indexOf == -1) {
            return activity;
        }
        return activity.substring(indexOf + 1);
    }

    private AttachmentsViewImpl getDefaultAttachmentsView(String process) {
        AttachmentsViewImpl view = ViewImpl.createAttachmentsView("working_attachments");
        view.setReadOnly(true);
        view.setCustom(false);
        view.assignProcesses(new String[]{this.processManager.getConsolidatedId(process)});
        view.assignRoles(this.processManager.getInteractiveRoles(process));
        view.setLabels(LibMsg.ATTACHMENTS);
        return view;
    }

    private BookmarkViewImpl getDefaultBookmarkView(String process) {
        BookmarkViewImpl view = ViewImpl.createBookmarkView("bookmark_view");
        view.setReadOnly(true);
        view.setCustom(false);
        view.assignRoles(this.processManager.getInteractiveRoles(process));
        view.assignProcesses(new String[]{this.processManager.getConsolidatedId(process)});
        view.setLabels(LibMsg.BOOKMARK);
        return view;
    }

    private ConsultationsViewImpl getDefaultConsultationView(String process) {
        ConsultationsViewImpl view = ViewImpl.createConsultationsView("consultation_view");
        view.setReadOnly(true);
        view.setCustom(false);
        view.assignRoles(this.processManager.getInteractiveRoles(process));
        view.assignProcesses(new String[]{this.processManager.getConsolidatedId(process)});
        view.setLabels(LibMsg.CONSULTATIONS);
        return view;
    }

    private ApplicationsViewImpl getDefaultGlobalApplicationsView(String process) {
        ApplicationsViewImpl view = null;
        if (this.processManager.isActiveProcess(process)) {
            view = ViewImpl.createApplicationsView("applications");
            view.setReadOnly(true);
            view.setCustom(false);
            view.assignRoles(this.processManager.getApplicationRoles(process));
            view.assignProcess(this.processManager.getConsolidatedId(process));
            view.setLabels(LibMsg.APPLICATIONS);
        }
        return view;
    }

    private HistoryViewImpl getDefaultHistoryView(String process, String id, Msg key) {
        HistoryViewImpl view = ViewImpl.createHistoryView(id);
        view.setReadOnly(true);
        view.setCustom(false);
        view.assignRoles(this.processManager.getInteractiveRoles(process));
        view.assignProcesses(new String[]{this.processManager.getConsolidatedId(process)});
        view.setLabels(key);
        return view;
    }

    private Map<String, ViewImpl> getDefaultHistoryViews(String process) {
        TreeMap<String, ViewImpl> history = new TreeMap<String, ViewImpl>(String.CASE_INSENSITIVE_ORDER);
        String historyFolderId = "history_view";
        String todayHistoryId = "history_view/today";
        FolderViewImpl historyFolder = ViewImpl.createFolderView(historyFolderId);
        historyFolder.setLabels(LibMsg.HISTORY);
        historyFolder.setReadOnly(true);
        historyFolder.setCustom(false);
        historyFolder.assignRoles(this.processManager.getInteractiveRoles(process));
        historyFolder.assignProcesses(new String[]{this.processManager.getConsolidatedId(process)});
        history.put(historyFolderId, historyFolder);
        HistoryViewImpl todayView = this.getDefaultHistoryView(process, todayHistoryId, PapiMsg.TEMPLATE_HISTORY_VIEW);
        if (todayView != null) {
            history.put(todayHistoryId, todayView);
        }
        return history;
    }

    private InstancesViewImpl getDefaultInboxView(String process) {
        InstancesViewImpl view = ViewImpl.createInstancesView("unified_inbox");
        view.setReadOnly(true);
        view.setCustom(false);
        view.assignRoles(this.processManager.getInteractiveRoles(process));
        view.assignProcesses(new String[]{this.processManager.getConsolidatedId(process)});
        view.setLabels(LibMsg.INBOX);
        FilterImpl filter = new FilterImpl();
        filter.setSearchScope(new SearchScope(ParticipantScope.PARTICIPANT_ROLES, StatusScope.ONLY_INPROCESS));
        filter.setName(view.getId());
        view.setFilter(filter);
        return view;
    }

    private List<InstancesViewImpl> getDefaultInstancesViews(String process, String[] roles, ViewsGenerationType vgType) {
        List<InstancesViewImpl> result = new ArrayList<InstancesViewImpl>();
        if (vgType == ViewsGenerationType.UNIFIED_INBOX) {
            result.add(this.getDefaultInboxView(process));
        } else if (vgType == ViewsGenerationType.BY_PROCESS) {
            result = this.getDefaultInstancesViews(process, roles, false);
        } else if (vgType == ViewsGenerationType.BY_PROCESS_AND_ACTIVITY) {
            result = this.getDefaultInstancesViews(process, roles, true);
        }
        return result;
    }

    private List<InstancesViewImpl> getDefaultInstancesViews(String process, String[] roles, boolean generateActivitiesView) {
        String viewId = DefaultViewGenerator.generateViewId(this.processManager.getProcessName(process), this.processManager.getOrganizationUnit(process));
        ArrayList<InstancesViewImpl> views = new ArrayList<InstancesViewImpl>();
        InstancesViewImpl view = ViewImpl.createInstancesView(viewId);
        view.setReadOnly(true);
        view.setCustom(false);
        view.assignRoles(this.processManager.getInteractiveRoles(process));
        view.assignProcesses(new String[]{this.processManager.getConsolidatedId(process)});
        for (Map.Entry<Locale, String> entry : this.processManager.getLabels(process).entrySet()) {
            view.setLabel(entry.getValue(), entry.getKey());
        }
        FilterImpl filter = new FilterImpl();
        filter.setSearchScope(new SearchScope(ParticipantScope.PARTICIPANT_ROLES, StatusScope.ONLY_INPROCESS));
        filter.setName(view.getId());
        view.setFilter(filter);
        views.add(view);
        return views;
    }

    private ApplicationsViewImpl getDefaultProcessApplicationsView(String process) {
        ApplicationsViewImpl view = null;
        if (this.processManager.isActiveProcess(process)) {
            String viewId = DefaultViewGenerator.generateViewId(this.processManager.getProcessName(process), this.processManager.getOrganizationUnit(process)) + "/" + "applications";
            view = ViewImpl.createApplicationsView(viewId);
            view.setReadOnly(true);
            view.setCustom(false);
            view.assignRoles(this.processManager.getApplicationRoles(process));
            view.assignProcess(this.processManager.getConsolidatedId(process));
            view.setLabels(LibMsg.APPLICATIONS);
        }
        return view;
    }

    private void addView(Map<String, ViewImpl> cache, List<? extends ViewImpl> views) {
        if (views != null) {
            for (ViewImpl viewImpl : views) {
                this.addView(cache, viewImpl);
            }
        }
    }

    private void addView(Map<String, ViewImpl> cache, Map<String, ViewImpl> views) {
        if (views != null) {
            for (ViewImpl view : views.values()) {
                this.addView(cache, view);
            }
        }
    }

    private void addView(Map<String, ViewImpl> cache, ViewImpl view) {
        if (view != null) {
            ViewImpl cacheView = cache.get(view.getId());
            if (cacheView != null) {
                cacheView.assignProcesses(view.getAssignedProcesses());
                cacheView.assignRoles(view.getAssignedRoles());
            } else {
                cache.put(view.getId(), view);
            }
        }
    }
}

