/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.io;

import fuego.papi.OperationRuntimeException;
import fuego.papi.msg.PapiMsg;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.locale.LocaleSupport;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.Locales;
import oracle.bpm.view.ActivityViewImpl;
import oracle.bpm.view.Comparison;
import oracle.bpm.view.FilterAttributeImpl;
import oracle.bpm.view.FilterImpl;
import oracle.bpm.view.InstancesViewImpl;
import oracle.bpm.view.Ordering;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.ViewType;
import oracle.bpm.view.io.XMLElement;
import oracle.bpm.view.io.XMLView;
import oracle.bpm.xml.XmlWriter;

public class XMLViewImpl
implements XMLView {
    private View viewElement = null;
    public static final String VERSION = "1";
    public static final Double[] DOUBLES = new Double[0];
    public static final Long[] LONGS = new Long[0];
    public static final Time[] TIMES = new Time[0];
    private static final String betweenSeparator = "][";

    @Override
    public final ViewImpl getView() {
        if (this.viewElement != null) {
            ViewImpl view = this.viewElement.getView();
            if (view != null && !view.isCustom()) {
                Msg defaultLabelsMsg = null;
                if (view.getId().equals("unified_inbox")) {
                    defaultLabelsMsg = PapiMsg.INBOX;
                } else if (view.getId().equals("applications")) {
                    defaultLabelsMsg = PapiMsg.APPLICATIONS;
                } else if (view.getId().equals("working_attachments")) {
                    defaultLabelsMsg = PapiMsg.ATTACHMENTS;
                } else if (view.getId().equals("bookmark_view")) {
                    defaultLabelsMsg = PapiMsg.BOOKMARKS;
                } else if (view.getId().equals("consultation_view")) {
                    defaultLabelsMsg = PapiMsg.CONSULTATIONS;
                } else if (view.getId().equals("history_view")) {
                    defaultLabelsMsg = PapiMsg.HISTORY;
                }
                if (defaultLabelsMsg != null) {
                    String viewId = view.getId();
                    String viewDefaultLabel = viewId.substring(viewId.lastIndexOf("/") + 1);
                    for (LocaleSupport locale : Platform.getLocaleService().getSupportedLocales()) {
                        String label;
                        String currentLabel = view.getLabel(locale.asJavaLocale());
                        if (currentLabel != null && !currentLabel.equals(viewDefaultLabel) || (label = defaultLabelsMsg.getString(locale)) == null) continue;
                        view.setLabel(label, locale.asJavaLocale());
                    }
                }
            }
            return view;
        }
        return null;
    }

    @Override
    public final XMLElement make(ViewImpl view) {
        LocaleStringMap labelsMap;
        String[] roles;
        String[] processes;
        XMLElement rootElement = this.makeElement("view", null);
        rootElement.addAttribute("id", view.getId());
        rootElement.addAttribute("type", view.getType().name());
        rootElement.addAttribute("owner", view.getOwner());
        rootElement.addAttribute("version", VERSION);
        XMLElement element = this.makeElement("hidden", rootElement);
        element.setCharacters(Boolean.toString(view.isHidden()));
        element = this.makeElement("readonly", rootElement);
        element.setCharacters(Boolean.toString(view.isReadOnly()));
        element = this.makeElement("custom", rootElement);
        element.setCharacters(Boolean.toString(view.isCustom()));
        element = this.makeElement("presentation", rootElement);
        element.setCharacters(view.getPresentation());
        if (view instanceof ActivityViewImpl) {
            ActivityViewImpl activityView = (ActivityViewImpl)view;
            element = this.makeElement("activity", rootElement);
            element.addAttribute("type", Integer.toString(activityView.getActivityType()));
            element.setCharacters(activityView.getActivityName());
        }
        if ((processes = view.getAssignedProcesses()).length > 0) {
            XMLElement assignedProcessesElement = this.makeElement("assignedProcesses", rootElement);
            for (String process : processes) {
                element = this.makeElement("process", assignedProcessesElement);
                element.setCharacters(process);
            }
        }
        if ((roles = view.getAssignedRoles()).length > 0) {
            XMLElement assignedRolesElement = this.makeElement("assignedRoles", rootElement);
            for (String role : roles) {
                element = this.makeElement("role", assignedRolesElement);
                element.setCharacters(role);
            }
        }
        if (!(labelsMap = view.getLabels()).isEmpty()) {
            XMLElement labelsElement = this.makeElement("labels", rootElement);
            for (Map.Entry<Locale, String> entry : labelsMap.entrySet()) {
                element = this.makeElement("label", labelsElement);
                element.addAttribute("language", entry.getKey().toString());
                element.setCharacters(entry.getValue());
            }
        }
        if (view instanceof InstancesViewImpl) {
            InstancesViewImpl instancesView = (InstancesViewImpl)view;
            FilterImpl filter = instancesView.getFilter();
            this.makeFilterElement(filter, rootElement);
        }
        this.viewElement = (View)rootElement;
        this.viewElement.view = view;
        return rootElement;
    }

    @Override
    public final XMLElement makeElement(String name, XMLElement parent) {
        String parentId = "";
        if (parent != null) {
            parentId = parent.getId();
        }
        try {
            if (name.equals("view")) {
                this.viewElement = new View();
                return this.viewElement;
            }
            if (parent instanceof View) {
                if (name.equals("hidden")) {
                    return new Hidden((View)parent);
                }
                if (name.equals("readonly")) {
                    return new ReadOnly((View)parent);
                }
                if (name.equals("custom")) {
                    return new Custom((View)parent);
                }
                if (name.equals("presentation")) {
                    return new Presentation((View)parent);
                }
                if (name.equals("activity")) {
                    return new Activity((View)parent);
                }
                if (name.equals("assignedRoles")) {
                    return new AssignedRoles((View)parent);
                }
                if (name.equals("assignedProcesses")) {
                    return new AssignedProcesses((View)parent);
                }
                if (name.equals("labels")) {
                    return new Labels((View)parent);
                }
                if (name.equals("filter")) {
                    return new Filter((View)parent);
                }
            } else if (parent instanceof AssignedRoles) {
                if (name.equals("role")) {
                    return new AssignedRole((AssignedRoles)parent);
                }
            } else if (parent instanceof AssignedProcesses) {
                if (name.equals("process")) {
                    return new AssignedProcess((AssignedProcesses)parent);
                }
            } else if (parent instanceof Labels) {
                if (name.equals("label")) {
                    return new Label((Labels)parent);
                }
            } else if (parent instanceof Filter) {
                if (name.equals("name")) {
                    return new FilterName((Filter)parent);
                }
                if (name.equals("matchall")) {
                    return new MatchAll((Filter)parent);
                }
                if (name.equals("casesensitive")) {
                    return new CaseSensitive((Filter)parent);
                }
                if (name.equals("grab")) {
                    return new GrabActivity((Filter)parent);
                }
                if (name.equals("attributes")) {
                    return new Attributes((Filter)parent);
                }
                if (name.equals("scope")) {
                    return new SearchScope((Filter)parent);
                }
                if (name.equals("subfilters")) {
                    return new Subfilters((Filter)parent);
                }
                if (name.equals("ordering")) {
                    return new Ordering((Filter)parent);
                }
            } else if (parent instanceof Attributes) {
                if (name.equals("attribute")) {
                    return new Attribute((Attributes)parent);
                }
            } else if (parent instanceof Attribute) {
                if (name.equals("variable")) {
                    return new Variable((Attribute)parent);
                }
                if (name.equals("operator")) {
                    return new Operator((Attribute)parent);
                }
                if (name.equals("value")) {
                    return new Value((Attribute)parent);
                }
            } else if (parent instanceof SearchScope) {
                if (name.equals("participant")) {
                    return new ParticipantScope((SearchScope)parent);
                }
                if (name.equals("status")) {
                    return new StatusScope((SearchScope)parent);
                }
                if (name.equals("activity")) {
                    return new ActivityScope((SearchScope)parent);
                }
            } else if (parent instanceof Subfilters) {
                if (name.equals("filter")) {
                    return new Filter((Subfilters)parent);
                }
            } else if (parent instanceof Ordering && name.equals("entry")) {
                return new OrderingEntry((Ordering)parent);
            }
        }
        catch (Throwable exception) {
            OperationRuntimeException operationRuntimeException = new OperationRuntimeException(PapiMsg.PAPI_9900(name, parentId));
            operationRuntimeException.initCause(exception);
            throw operationRuntimeException;
        }
        throw new IllegalArgumentException("Invalid name '" + name + "' with parent '" + parentId + "'");
    }

    private void makeFilterElement(FilterImpl filter, XMLElement rootElement) {
        List<FilterImpl> subfilters;
        List<FilterAttributeImpl> attributes;
        XMLElement filterElement = this.makeElement("filter", rootElement);
        XMLElement element = this.makeElement("name", filterElement);
        element.setCharacters(filter.getName());
        element = this.makeElement("matchall", filterElement);
        element.setCharacters(Boolean.toString(filter.isMatchAll()));
        element = this.makeElement("casesensitive", filterElement);
        element.setCharacters(Boolean.toString(filter.isCaseSensitive()));
        XMLElement searchScopeElement = this.makeElement("scope", filterElement);
        element = this.makeElement("participant", searchScopeElement);
        element.setCharacters(filter.getSearchScope().getParticipantScope().name());
        element = this.makeElement("status", searchScopeElement);
        element.setCharacters(filter.getSearchScope().getStatusScope().name());
        if (filter.getSearchScope().getActivityScope() != null) {
            element = this.makeElement("activity", searchScopeElement);
            element.setCharacters(filter.getSearchScope().getActivityScope());
        }
        if (!(attributes = filter.getAttributes()).isEmpty()) {
            XMLElement attributesElement = this.makeElement("attributes", filterElement);
            for (FilterAttributeImpl attribute : attributes) {
                String className;
                if (attribute == null) continue;
                XMLElement attributeElement = this.makeElement("attribute", attributesElement);
                attributeElement.addAttribute("parametric", Boolean.toString(attribute.isParametric()));
                element = this.makeElement("variable", attributeElement);
                element.addAttribute("kind", Integer.toString(attribute.getKind()));
                element.setCharacters(attribute.getVariableId());
                element = this.makeElement("operator", attributeElement);
                element.setCharacters(attribute.getComparison().name());
                if (attribute.getValue() == null) continue;
                element = this.makeElement("value", attributeElement);
                int kind = attribute.getKind();
                switch (kind) {
                    case 1: {
                        className = Boolean.class.getName();
                        break;
                    }
                    case 2: {
                        if (attribute.getComparison() == Comparison.BETWEEN || attribute.getComparison() == Comparison.NOT_BETWEEN) {
                            className = LONGS.getClass().getName();
                            break;
                        }
                        className = Long.class.getName();
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (attribute.getComparison() == Comparison.BETWEEN || attribute.getComparison() == Comparison.NOT_BETWEEN) {
                            className = DOUBLES.getClass().getName();
                            break;
                        }
                        className = Double.class.getName();
                        break;
                    }
                    case 7: {
                        className = Interval.class.getName();
                        break;
                    }
                    case 6: {
                        if (attribute.getValue() instanceof Interval) {
                            className = Interval.class.getName();
                            break;
                        }
                        if (attribute.getComparison() == Comparison.BETWEEN || attribute.getComparison() == Comparison.NOT_BETWEEN) {
                            className = TIMES.getClass().getName();
                            break;
                        }
                        className = Time.class.getName();
                        break;
                    }
                    default: {
                        className = String.class.getName();
                    }
                }
                element.addAttribute("class", className);
                if (attribute.getComparison() == Comparison.BETWEEN || attribute.getComparison() == Comparison.NOT_BETWEEN) {
                    Object[] values = (Object[])attribute.getValue();
                    String characters = values[0].toString() + betweenSeparator + values[1].toString();
                    element.setCharacters(characters);
                    continue;
                }
                element.setCharacters(attribute.getValue().toString());
            }
        }
        if (!(subfilters = filter.getFilters()).isEmpty()) {
            XMLElement subfiltersElement = this.makeElement("subfilters", filterElement);
            for (FilterImpl subfilter : subfilters) {
                this.makeFilterElement(subfilter, subfiltersElement);
            }
        }
        if (filter.getOrdering().getEntryCount() > 0) {
            XMLElement orderingElement = this.makeElement("ordering", filterElement);
            int size = filter.getOrdering().getEntryCount();
            for (int i = 0; i < size; ++i) {
                Ordering.Entry entry = filter.getOrdering().getEntry(i);
                element = this.makeElement("entry", orderingElement);
                element.addAttribute("ascending", Boolean.toString(entry.isAscending()));
                element.setCharacters(entry.getVariableId());
            }
        }
    }

    private static class View
    extends XMLElement {
        private ViewImpl view;
        public static final String ID = "view";
        public static final String ATTR_ID = "id";
        public static final String ATTR_TYPE = "type";
        public static final String ATTR_OWNER = "owner";
        public static final String ATTR_VERSION = "version";

        public View() {
            super(ID, null);
        }

        public ViewImpl getView() {
            return this.view;
        }

        @Override
        public void startElement(String uri, String name, String qualifiedName, org.xml.sax.Attributes attributes) {
            ViewType viewType;
            super.startElement(uri, name, qualifiedName, attributes);
            String id = (String)this.attributes.get(ATTR_ID);
            String type = (String)this.attributes.get(ATTR_TYPE);
            String owner = (String)this.attributes.get(ATTR_OWNER);
            try {
                viewType = ViewType.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException exception) {
                throw ProgramException.wrap("Trying to create a view of the unknown type '" + type.toUpperCase() + "'", exception);
            }
            assert (viewType != null);
            this.view = ViewImpl.create(viewType, id, owner);
        }
    }

    private static class Variable
    extends XMLElement {
        public static final String ID = "variable";
        public static final String ATTR_KIND = "kind";

        public Variable(Attribute parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            int kind = 5;
            try {
                kind = Integer.parseInt((String)this.attributes.get(ATTR_KIND));
            }
            catch (NumberFormatException exception) {
                Log.logWarning(exception);
            }
            String variableId = this.characters;
            if ("PREDEFINE_INSTANCE_NUMBER".equals(variableId)) {
                variableId = "PREDEFINE_INSTANCE NUMBER";
            }
            Attribute attribute = (Attribute)this.parent;
            attribute.setVariable(variableId);
            attribute.setKind(kind);
        }
    }

    private static class Value
    extends XMLElement {
        public static final String ID = "value";
        public static final String ATTR_CLASS = "class";

        public Value(Attribute parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            String className = (String)this.attributes.get(ATTR_CLASS);
            String stringValue = this.characters;
            Attribute attribute = (Attribute)this.parent;
            if (stringValue != null && stringValue.length() > 0) {
                if (className.equalsIgnoreCase(Long.class.getName())) {
                    attribute.setValue(Long.valueOf(stringValue));
                } else if (className.equalsIgnoreCase(LONGS.getClass().getName())) {
                    int separator = stringValue.indexOf(XMLViewImpl.betweenSeparator);
                    if (separator > 0 && stringValue.length() > separator + 2) {
                        Long[] values = new Long[]{Long.valueOf(stringValue.substring(0, separator)), Long.valueOf(stringValue.substring(separator + 2))};
                        attribute.setValue(values);
                    } else {
                        attribute.setValue(null);
                    }
                } else if (className.equalsIgnoreCase(Double.class.getName())) {
                    attribute.setValue(Double.valueOf(stringValue));
                } else if (className.equalsIgnoreCase(DOUBLES.getClass().getName())) {
                    int separator = stringValue.indexOf(XMLViewImpl.betweenSeparator);
                    if (separator > 0 && stringValue.length() > separator + 2) {
                        Double[] values = new Double[]{Double.valueOf(stringValue.substring(0, separator)), Double.valueOf(stringValue.substring(separator + 2))};
                        attribute.setValue(values);
                    } else {
                        attribute.setValue(null);
                    }
                } else if (className.equalsIgnoreCase(Boolean.class.getName())) {
                    attribute.setValue(Boolean.valueOf(stringValue));
                } else if (className.equalsIgnoreCase(Time.class.getName())) {
                    attribute.setValue(Time.valueOf(stringValue).roundDownToSeconds());
                } else if (className.equalsIgnoreCase(TIMES.getClass().getName())) {
                    int separator = stringValue.indexOf(XMLViewImpl.betweenSeparator);
                    if (separator > 0 && stringValue.length() > separator + 2) {
                        Time[] values = new Time[]{Time.valueOf(stringValue.substring(0, separator)).roundDownToSeconds(), Time.valueOf(stringValue.substring(separator + 2)).roundDownToSeconds()};
                        attribute.setValue(values);
                    } else {
                        attribute.setValue(null);
                    }
                } else if (className.equalsIgnoreCase(Interval.class.getName())) {
                    attribute.setValue(Interval.valueOf(stringValue));
                } else {
                    attribute.setValue(stringValue);
                }
            } else {
                attribute.setValue(null);
            }
        }
    }

    private static class StatusScope
    extends XMLElement {
        public static final String ID = "status";

        public StatusScope(SearchScope parent) {
            super(ID, parent);
            this.parent = parent;
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            SearchScope searchScope = (SearchScope)this.parent;
            searchScope.setStatusScope(oracle.bpm.view.StatusScope.valueOf(this.characters));
        }

        @Override
        public void characters(char[] chars, int start, int length) {
            super.characters(chars, start, length);
        }
    }

    private static class SearchScope
    extends XMLElement {
        private oracle.bpm.view.SearchScope scope;
        public static final String ID = "scope";

        public SearchScope(Filter parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((Filter)this.parent).getFilter().setSearchScope(this.scope);
        }

        public void setActivityScope(String activity) {
            this.scope.setActivityScope(activity);
        }

        public void setParticipantScope(oracle.bpm.view.ParticipantScope participantScope) {
            this.scope.setParticipantScope(participantScope);
        }

        public void setStatusScope(oracle.bpm.view.StatusScope statusScope) {
            this.scope.setStatusScope(statusScope);
        }

        @Override
        public void startElement(String uri, String name, String qualifiedName, org.xml.sax.Attributes attributes) {
            super.startElement(uri, name, qualifiedName, attributes);
            this.scope = oracle.bpm.view.SearchScope.create();
        }
    }

    private static class ReadOnly
    extends XMLElement {
        public static final String ID = "readonly";

        public ReadOnly(View parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((View)this.parent).getView().setReadOnly(Boolean.parseBoolean(this.characters));
        }
    }

    private static class Presentation
    extends XMLElement {
        public static final String ID = "presentation";

        public Presentation(View parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((View)this.parent).getView().setPresentation(this.characters);
        }
    }

    private static class ParticipantScope
    extends XMLElement {
        public static final String ID = "participant";

        public ParticipantScope(SearchScope parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            SearchScope searchScope = (SearchScope)this.parent;
            searchScope.setParticipantScope(oracle.bpm.view.ParticipantScope.valueOf(this.characters));
        }
    }

    private static class OrderingEntry
    extends XMLElement {
        public static final String ID = "entry";
        public static final String ATTR_ASCENDING = "ascending";

        public OrderingEntry(Ordering parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((Ordering)this.parent).addEntry(this.characters, Boolean.valueOf((String)this.attributes.get(ATTR_ASCENDING)));
        }
    }

    private static class Ordering
    extends XMLElement {
        private oracle.bpm.view.Ordering ordering;
        public static final String ID = "ordering";

        public Ordering(Filter parent) {
            super(ID, parent);
        }

        public void addEntry(String variable, boolean ascending) {
            this.ordering.add(variable, ascending);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((Filter)this.parent).getFilter().setOrdering(this.ordering);
        }

        @Override
        public void startElement(String uri, String name, String qualifiedName, org.xml.sax.Attributes attributes) {
            super.startElement(uri, name, qualifiedName, attributes);
            this.ordering = new oracle.bpm.view.Ordering();
        }
    }

    private static class Operator
    extends XMLElement {
        public static final String ID = "operator";

        public Operator(Attribute parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            Comparison operator = Comparison.valueOf(this.characters.toUpperCase());
            ((Attribute)this.parent).setOperator(operator);
        }
    }

    private static class MatchAll
    extends XMLElement {
        public static final String ID = "matchall";

        public MatchAll(Filter parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((Filter)this.parent).getFilter().setMatchAll(Boolean.valueOf(this.characters));
        }
    }

    private static class Labels
    extends XMLElement {
        public static final String ID = "labels";

        public Labels(View parent) {
            super(ID, parent);
        }

        public void setLabel(String label, Locale locale) {
            ((View)this.parent).getView().setLabel(label, locale);
        }
    }

    private static class Label
    extends XMLElement {
        public static final String ID = "label";
        public static final String ATTR_LANGUAGE = "language";

        public Label(Labels parent) {
            super(ID, parent);
            this.parent = parent;
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            Labels labels = (Labels)this.parent;
            labels.setLabel(this.characters, Locales.valueOf((String)this.attributes.get(ATTR_LANGUAGE)));
        }

        @Override
        public void write(XmlWriter writer) throws IOException {
            writer.startElement(this.getId());
            if (this.attributes != null && !this.attributes.isEmpty()) {
                for (Map.Entry attribute : this.attributes.entrySet()) {
                    writer.printAttribute((String)attribute.getKey(), (String)attribute.getValue());
                }
            }
            if (this.childrens != null && !this.childrens.isEmpty()) {
                int size = this.childrens.size();
                for (int i = 0; i < size; ++i) {
                    XMLElement element = (XMLElement)this.childrens.get(i);
                    element.write(writer);
                }
            }
            if (this.characters != null) {
                writer.printChars(this.characters, false, true, false);
            }
            writer.endElement();
        }
    }

    private static class Hidden
    extends XMLElement {
        public static final String ID = "hidden";

        public Hidden(View parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((View)this.parent).getView().setHidden(Boolean.valueOf(this.characters));
        }
    }

    private static class GrabActivity
    extends XMLElement {
        public static final String ID = "grab";

        public GrabActivity(Filter parent) {
            super(ID, parent);
        }

        public void end() {
        }
    }

    private static class FilterName
    extends XMLElement {
        public static final String ID = "name";

        public FilterName(Filter parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((Filter)this.parent).getFilter().setName(this.characters);
        }
    }

    private static class Filter
    extends XMLElement {
        private FilterImpl filter;
        public static final String ID = "filter";

        public Filter(View parent) {
            super(ID, parent);
        }

        public Filter(Subfilters parent) {
            super(ID, parent);
        }

        public FilterImpl getFilter() {
            return this.filter;
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            if (this.parent instanceof View) {
                if (((View)this.parent).getView() instanceof InstancesViewImpl) {
                    InstancesViewImpl view = (InstancesViewImpl)((View)this.parent).getView();
                    view.setFilter(this.filter);
                }
            } else if (this.parent instanceof Filter) {
                ((Filter)this.parent).getFilter().addFilter(this.filter);
            }
        }

        @Override
        public void startElement(String uri, String name, String qualifiedName, org.xml.sax.Attributes attributes) {
            super.startElement(uri, name, qualifiedName, attributes);
            this.filter = new FilterImpl();
        }
    }

    private static class Custom
    extends XMLElement {
        public static final String ID = "custom";

        public Custom(View parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((View)this.parent).getView().setCustom(Boolean.valueOf(this.characters));
        }
    }

    private static class CaseSensitive
    extends XMLElement {
        public static final String ID = "casesensitive";

        public CaseSensitive(Filter parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((Filter)this.parent).getFilter().setCaseSensitive(Boolean.valueOf(this.characters));
        }
    }

    private static class Attributes
    extends XMLElement {
        public static final String ID = "attributes";

        public Attributes(Filter parent) {
            super(ID, parent);
        }

        public void addAttribute(FilterAttributeImpl attribute) {
            ((Filter)this.parent).getFilter().addAttribute(attribute);
        }
    }

    private static class Attribute
    extends XMLElement {
        private int kind;
        private Comparison operator;
        private Object value;
        private String variable;
        public static final String ID = "attribute";
        public static final String ATTR_PARAMETRIC = "parametric";

        public Attribute(Attributes parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            boolean parametric = Boolean.parseBoolean((String)this.attributes.get(ATTR_PARAMETRIC));
            FilterAttributeImpl attribute = new FilterAttributeImpl(this.variable, this.kind, this.operator, this.value);
            attribute.setParametric(parametric);
            ((Attributes)this.parent).addAttribute(attribute);
        }

        public void setKind(int kind) {
            this.kind = kind;
        }

        public void setOperator(Comparison operator) {
            this.operator = operator;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setVariable(String variable) {
            this.variable = variable;
        }
    }

    private static class AssignedRoles
    extends XMLElement {
        public static final String ID = "assignedRoles";

        public AssignedRoles(View parent) {
            super(ID, parent);
        }

        public void assignRole(String role) {
            ((View)this.parent).getView().assignRole(role);
        }
    }

    private static class AssignedRole
    extends XMLElement {
        public static final String ID = "role";

        public AssignedRole(AssignedRoles parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((AssignedRoles)this.parent).assignRole(this.characters);
        }
    }

    private static class AssignedProcesses
    extends XMLElement {
        public static final String ID = "assignedProcesses";

        public AssignedProcesses(View parent) {
            super(ID, parent);
        }

        public void assignProcess(String process) {
            ((View)this.parent).getView().assignProcess(process);
        }
    }

    private static class AssignedProcess
    extends XMLElement {
        public static final String ID = "process";

        public AssignedProcess(AssignedProcesses parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((AssignedProcesses)this.parent).assignProcess(this.characters);
        }
    }

    private static class ActivityScope
    extends XMLElement {
        public static final String ID = "activity";

        public ActivityScope(SearchScope parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((SearchScope)this.parent).setActivityScope(this.characters);
        }
    }

    private static class Activity
    extends XMLElement {
        public static final String ID = "activity";
        public static final String ATTR_TYPE = "type";

        public Activity(View parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            if (((View)this.parent).getView() instanceof ActivityViewImpl) {
                String activityName = this.characters;
                int activityType = 2;
                try {
                    activityType = Integer.parseInt((String)this.attributes.get(ATTR_TYPE));
                }
                catch (NumberFormatException exception) {
                    // empty catch block
                }
                ActivityViewImpl view = (ActivityViewImpl)((View)this.parent).getView();
                view.setActivityName(activityName);
                view.setActivityType(activityType);
            }
        }
    }

    public static class Subfilters
    extends XMLElement {
        public static final String ID = "subfilters";

        public Subfilters(Filter parent) {
            super(ID, parent);
        }

        public void addSubFilter(FilterImpl subfilter) {
            ((Filter)this.parent).getFilter().addFilter(subfilter);
        }
    }
}

