/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.io;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.view.ColumnFormat;
import oracle.bpm.view.ColumnFormatType;
import oracle.bpm.view.Ordering;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.PresentationType;
import oracle.bpm.view.io.XMLElement;
import oracle.bpm.view.io.XMLPresentation;
import org.xml.sax.Attributes;

public class XMLPresentationImpl
implements XMLPresentation {
    private Presentation presentationElement = null;
    public static final String VERSION = "1";

    @Override
    public PresentationImpl getPresentation() {
        if (this.presentationElement != null) {
            return this.presentationElement.getPresentation();
        }
        return null;
    }

    @Override
    public XMLElement make(PresentationImpl presentation) {
        PresentationImpl.Column[] columns;
        XMLElement rootElement = this.makeElement("presentation", null);
        rootElement.addAttribute("id", presentation.getId());
        rootElement.addAttribute("type", presentation.getType().name());
        rootElement.addAttribute("owner", presentation.getOwner());
        rootElement.addAttribute("version", VERSION);
        XMLElement element = this.makeElement("readonly", rootElement);
        element.setCharacters(Boolean.toString(presentation.isReadOnly()));
        XMLElement columnsElement = this.makeElement("columns", rootElement);
        for (PresentationImpl.Column column : columns = presentation.getColumns()) {
            element = this.makeElement("column", columnsElement);
            element.addAttribute("size", Integer.toString(column.getSize()));
            if (column.getColumnFormat() != null) {
                element.addAttribute("format_type", column.getColumnFormat().getType().name());
                if (column.getColumnFormat().getPattern() != null) {
                    element.addAttribute("format_pattern", column.getColumnFormat().getPattern());
                }
            }
            element.setCharacters(column.getId());
        }
        oracle.bpm.view.Ordering presentationOrdering = presentation.getOrdering();
        if (presentationOrdering != null && presentationOrdering.getEntryCount() > 0) {
            XMLElement orderingElement = this.makeElement("ordering", this.presentationElement);
            int size = presentationOrdering.getEntryCount();
            for (int i = 0; i < size; ++i) {
                Ordering.Entry entry = presentationOrdering.getEntry(i);
                element = this.makeElement("entry", orderingElement);
                element.addAttribute("ascending", Boolean.toString(entry.isAscending()));
                element.setCharacters(entry.getVariableId());
            }
        }
        this.presentationElement = (Presentation)rootElement;
        return rootElement;
    }

    @Override
    public XMLElement makeElement(String name, XMLElement parent) {
        if (name.equals("presentation")) {
            this.presentationElement = new Presentation();
            return this.presentationElement;
        }
        if (parent instanceof Presentation) {
            if (name.equals("readonly")) {
                return new ReadOnly((Presentation)parent);
            }
            if (name.equals("columns")) {
                return new Columns((Presentation)parent);
            }
            if (name.equals("ordering")) {
                return new Ordering((Presentation)parent);
            }
        } else if (parent instanceof Columns) {
            if (name.equals("column")) {
                return new Column((Columns)parent);
            }
        } else if (parent instanceof Ordering && name.equals("entry")) {
            return new OrderingEntry((Ordering)parent);
        }
        String parentId = parent != null ? parent.getId() : null;
        throw new IllegalArgumentException("Invalid name '" + name + "' with parent '" + parentId + "'");
    }

    private static class ReadOnly
    extends XMLElement {
        public static final String ID = "readonly";

        public ReadOnly(Presentation parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((Presentation)this.parent).getPresentation().setReadOnly(Boolean.valueOf(this.characters));
        }
    }

    private static class Presentation
    extends XMLElement {
        private PresentationImpl presentation;
        public static final String ID = "presentation";
        public static final String ATTR_ID = "id";
        public static final String ATTR_TYPE = "type";
        public static final String ATTR_OWNER = "owner";
        public static final String ATTR_VERSION = "version";

        public Presentation() {
            super(ID, null);
        }

        public PresentationImpl getPresentation() {
            return this.presentation;
        }

        @Override
        public void startElement(String uri, String name, String qualifiedName, Attributes attributes) {
            super.startElement(uri, name, qualifiedName, attributes);
            String id = (String)this.attributes.get(ATTR_ID);
            String type = (String)this.attributes.get(ATTR_TYPE);
            String owner = (String)this.attributes.get(ATTR_OWNER);
            this.presentation = new PresentationImpl(PresentationType.valueOf(type), id, new PresentationImpl.Column[0], owner);
        }
    }

    private static class OrderingEntry
    extends XMLElement {
        public static final String ID = "entry";
        public static final String ATTR_ASCENDING = "ascending";

        public OrderingEntry(Ordering parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((Ordering)this.parent).addEntry(this.characters, Boolean.valueOf((String)this.attributes.get(ATTR_ASCENDING)));
        }
    }

    private static class Ordering
    extends XMLElement {
        private oracle.bpm.view.Ordering ordering;
        public static final String ID = "ordering";

        public Ordering(Presentation parent) {
            super(ID, parent);
        }

        public void addEntry(String variable, boolean ascending) {
            this.ordering.add(variable, ascending);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            ((Presentation)this.parent).getPresentation().setOrdering(this.ordering);
        }

        @Override
        public void startElement(String uri, String name, String qualifiedName, Attributes attributes) {
            super.startElement(uri, name, qualifiedName, attributes);
            this.ordering = new oracle.bpm.view.Ordering();
        }
    }

    private static class Columns
    extends XMLElement {
        private List<PresentationImpl.Column> columns;
        public static final String ID = "columns";

        public Columns(Presentation parent) {
            super(ID, parent);
        }

        public void addColumn(PresentationImpl.Column column) {
            this.columns.add(column);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            super.endElement(uri, name, qName);
            PresentationImpl.Column[] columnsArray = this.columns.toArray(new PresentationImpl.Column[this.columns.size()]);
            ((Presentation)this.parent).getPresentation().setColumns(columnsArray);
        }

        @Override
        public void startElement(String uri, String name, String qualifiedName, Attributes attributes) {
            super.startElement(uri, name, qualifiedName, attributes);
            this.columns = new ArrayList<PresentationImpl.Column>();
        }
    }

    private static class Column
    extends XMLElement {
        public static final String ID = "column";
        public static final String ATTR_SIZE = "size";
        public static final String ATTR_FORMAT_KIND = "format_type";
        public static final String ATTR_FORMAT_PATTERN = "format_pattern";

        public Column(Columns parent) {
            super(ID, parent);
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            String variableId;
            super.endElement(uri, name, qName);
            int size = 20;
            String sizeStr = (String)this.attributes.get(ATTR_SIZE);
            if (sizeStr != null) {
                try {
                    size = Integer.parseInt(sizeStr);
                }
                catch (NumberFormatException exception) {
                    // empty catch block
                }
            }
            String type = (String)this.attributes.get(ATTR_FORMAT_KIND);
            String pattern = (String)this.attributes.get(ATTR_FORMAT_PATTERN);
            ColumnFormat columnFormat = null;
            if (type != null) {
                ColumnFormatType columnFormatType = ColumnFormatType.valueOf(type);
                columnFormat = ColumnFormat.getInstance(columnFormatType, pattern);
            }
            if ("PREDEFINE_INSTANCE_NUMBER".equals(variableId = this.characters)) {
                variableId = "PREDEFINE_INSTANCE NUMBER";
            }
            PresentationImpl.Column column = new PresentationImpl.Column(variableId, size, columnFormat);
            ((Columns)this.parent).addColumn(column);
        }
    }
}

