/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.bpm.xml.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLElement
extends DefaultHandler {
    protected Map<String, String> attributes;
    protected String characters;
    protected List<XMLElement> childrens;
    protected boolean isOpen = false;
    protected XMLElement parent;
    private String id = "";

    protected XMLElement(String id, XMLElement parent) {
        this.id = id;
        this.parent = parent;
        this.childrens = new ArrayList<XMLElement>();
        this.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (parent != null) {
            parent.childrens.add(this);
        }
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setCharacters(String characters) {
        this.characters = characters;
    }

    public String getCharacters() {
        return this.characters;
    }

    public String getId() {
        return this.id;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        if (this.isOpen && chars != null && start > -1 && length > 0) {
            String newChars = String.copyValueOf(chars, start, length).trim();
            this.characters = this.characters == null ? newChars : this.characters.concat(newChars);
        }
    }

    @Override
    public void endElement(String uri, String name, String qualifiedName) {
        if (name.equals(this.getId())) {
            this.isOpen = false;
        }
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void startElement(String uri, String name, String qualifiedName, Attributes attributes) {
        if (name.equalsIgnoreCase(this.getId())) {
            this.isOpen = true;
            if (attributes != null) {
                int size = attributes.getLength();
                for (int i = 0; i < size; ++i) {
                    String key = attributes.getQName(i);
                    String value = attributes.getValue(i);
                    this.attributes.put(key, value);
                }
            }
        }
    }

    public void write(XmlWriter writer) throws IOException {
        writer.startElement(this.getId());
        if (this.attributes != null && !this.attributes.isEmpty()) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                writer.printAttribute((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.childrens != null) {
            for (XMLElement xMLElement : this.childrens) {
                xMLElement.write(writer);
            }
        }
        if (this.characters != null) {
            writer.printChars(this.characters);
        }
        writer.endElement();
    }
}

