/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpm.collections.maps.SortedStringMap;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.io.PresentationReader;
import oracle.bpm.view.io.PresentationWriter;
import oracle.bpm.xml.DeserializationException;
import org.xml.sax.SAXException;

public abstract class PresentationLoader {
    private static final PresentationReader reader = new PresentationReader();

    public abstract SortedStringMap<PresentationImpl> loadOrganizationPresentations();

    public abstract void storeOrganizationPresentation(PresentationImpl var1, Writer var2);

    public abstract void removeOrganizationPresentation(String var1);

    public abstract SortedStringMap<PresentationImpl> loadParticipantPresnetations(String var1);

    public abstract void storeParticipantPresentation(String var1, PresentationImpl var2);

    public abstract void removeParticipantPresentation(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PresentationImpl buildPresentation(InputStream xmlPresentation) throws DeserializationException, IOException, SAXException, ParserConfigurationException {
        PresentationImpl presentation = null;
        PresentationReader presentationReader = reader;
        synchronized (presentationReader) {
            try {
                presentation = reader.parse(xmlPresentation);
            }
            finally {
                reader.clear();
            }
        }
        return presentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PresentationImpl buildPresentation(String xmlPresentation) throws DeserializationException, IOException, SAXException, ParserConfigurationException {
        PresentationImpl presentation = null;
        PresentationReader presentationReader = reader;
        synchronized (presentationReader) {
            try {
                presentation = reader.parse(xmlPresentation);
            }
            finally {
                reader.clear();
            }
        }
        return presentation;
    }

    public static String buildXML(PresentationImpl presentation) throws IOException {
        return PresentationWriter.getXMLPresentation(presentation);
    }
}

