/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.io;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.io.ViewLoader;
import oracle.bpm.view.io.ViewWriter;
import oracle.bpm.xml.XmlWriter;

public class DirViewWriter {
    public static final String ELEM_FDI_OBJECT = "FDIObject";
    public static final String ELEM_VIEW = "DirView";
    public static final String ELEM_ID = "id";
    public static final String ELEM_PROCESSES = "processes";
    public static final String ELEM_PROCESS = "process";
    public static final String ELEM_ROLES = "roles";
    public static final String ELEM_ROLE = "role";
    public static final String ELEM_PROPERTIES = "properties";
    public static final String ELEM_TYPE = "type";
    public static final String ELEM_PROPS = "viewProperties";
    public static final String ELEM_PROP = "viewProperty";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXMLView(ViewImpl view) throws IOException {
        StringWriter writer = null;
        String xml = null;
        try {
            writer = new StringWriter();
            DirViewWriter.writeXMLView(view, writer);
            xml = writer.toString();
        }
        catch (Throwable throwable) {
            StreamUtils.close(writer);
            throw throwable;
        }
        StreamUtils.close(writer);
        return xml;
    }

    public static void writeXMLView(ViewImpl view, Writer writer) throws IOException {
        XmlWriter xml = new XmlWriter(writer, "UTF-8");
        DirViewWriter.write(view, xml);
    }

    public static void write(ViewImpl view, XmlWriter xmlWriter) throws IOException {
        String[] roles;
        xmlWriter.startDocument();
        xmlWriter.startElement(ELEM_FDI_OBJECT);
        xmlWriter.startElement(ELEM_VIEW);
        xmlWriter.printValuedElement(ELEM_ID, view.getId());
        xmlWriter.printValuedElement(ELEM_TYPE, String.valueOf(ViewLoader.getStoreViewTypeIn(view.getType(), view.isCustom())));
        String[] processes = view.getAssignedProcesses();
        if (processes != null && processes.length > 0) {
            xmlWriter.startElement(ELEM_PROCESSES);
            for (String process : processes) {
                xmlWriter.printValuedElement(ELEM_PROCESS, process);
            }
            xmlWriter.endElement();
        }
        if ((roles = view.getAssignedRoles()) != null && roles.length > 0) {
            xmlWriter.startElement(ELEM_ROLES);
            for (String role : roles) {
                xmlWriter.printValuedElement(ELEM_ROLE, role);
            }
            xmlWriter.endElement();
        }
        xmlWriter.printCDATAElement(ELEM_PROPERTIES, ViewWriter.getXMLView(view));
        xmlWriter.endElement();
        xmlWriter.endElement();
        xmlWriter.close();
    }
}

