/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view.io;

import java.io.IOException;
import java.io.Writer;
import oracle.bpm.view.PresentationImpl;
import oracle.bpm.view.io.PresentationWriter;
import oracle.bpm.xml.XmlWriter;

public class DirPresentationWriter {
    public static final String ELEM_FDI_OBJECT = "FDIObject";
    public static final String ELEM_PRESENTATION = "DirPresentation";
    public static final String ELEM_ID = "id";
    public static final String ELEM_PROPERTIES = "properties";
    public static final String ELEM_TYPE = "type";

    public static void writeXMLPresentation(PresentationImpl presentation, Writer writer) throws IOException {
        DirPresentationWriter.write(presentation, new XmlWriter(writer, "UTF-8"));
    }

    public static void write(PresentationImpl presentation, XmlWriter xmlWriter) throws IOException {
        xmlWriter.startDocument();
        xmlWriter.startElement(ELEM_FDI_OBJECT);
        xmlWriter.startElement(ELEM_PRESENTATION);
        xmlWriter.printValuedElement(ELEM_ID, presentation.getId());
        xmlWriter.printValuedElement(ELEM_TYPE, String.valueOf(presentation.getType().getIn()));
        xmlWriter.printCDATAElement(ELEM_PROPERTIES, PresentationWriter.getXMLPresentation(presentation));
        xmlWriter.endElement();
        xmlWriter.endElement();
        xmlWriter.close();
    }
}

