/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NonNls;

public enum ViewType implements I18nProvider
{
    APPLICATIONS{

        @Override
        public int getIn() {
            return 0;
        }

        @Override
        public Msg getMsg() {
            return LibMsg.APPLICATIONS;
        }
    }
    ,
    ATTACHMENTS{

        @Override
        public int getIn() {
            return 1;
        }

        @Override
        public Msg getMsg() {
            return LibMsg.ATTACHMENTS;
        }
    }
    ,
    INSTANCES{

        @Override
        public int getIn() {
            return 2;
        }

        @Override
        public Msg getMsg() {
            return LibMsg.INSTANCES;
        }
    }
    ,
    ACTIVITY_INSTANCES{

        @Override
        public int getIn() {
            return 3;
        }

        @Override
        public Msg getMsg() {
            return LibMsg.ACTIVITY_INSTANCES;
        }

        @Override
        public boolean isType(ViewType viewType) {
            return viewType == this || 4.isSubtype(this, viewType);
        }
    }
    ,
    FOLDER{

        @Override
        public int getIn() {
            return 4;
        }

        @Override
        public Msg getMsg() {
            return LibMsg.FOLDER;
        }
    }
    ,
    HISTORY{

        @Override
        public int getIn() {
            return 5;
        }

        @Override
        public Msg getMsg() {
            return LibMsg.HISTORY;
        }

        @Override
        public boolean isType(ViewType viewType) {
            return viewType == this || 6.isSubtype(this, viewType);
        }
    }
    ,
    BOOKMARKS{

        @Override
        public int getIn() {
            return 6;
        }

        @Override
        public Msg getMsg() {
            return LibMsg.BOOKMARKS;
        }

        @Override
        public boolean isType(ViewType viewType) {
            return viewType == this || 7.isSubtype(this, viewType);
        }
    }
    ,
    CONSULTATIONS{

        @Override
        public int getIn() {
            return 7;
        }

        @Override
        public Msg getMsg() {
            return LibMsg.CONSULTATIONS;
        }

        @Override
        public boolean isType(ViewType viewType) {
            return viewType == this || 8.isSubtype(this, viewType);
        }
    };


    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public static boolean isSubtype(ViewType son, ViewType parent) {
        return parent == INSTANCES && (son == HISTORY || son == BOOKMARKS || son == CONSULTATIONS || son == ACTIVITY_INSTANCES);
    }

    public boolean isType(ViewType viewType) {
        return viewType == this;
    }

    public int getIn() {
        return -1;
    }

    public Msg getMsg() {
        return null;
    }

    public boolean isBookmark() {
        return this == BOOKMARKS;
    }

    public boolean isConsultation() {
        return this == CONSULTATIONS;
    }

    public boolean isHistory() {
        return this == HISTORY;
    }

    public static ViewType fixOldViewType(@NonNls String viewTypeStr) {
        if ("BOOKMARK".equals(viewTypeStr)) {
            return BOOKMARKS;
        }
        if ("ACTIVITY".equals(viewTypeStr)) {
            return ACTIVITY_INSTANCES;
        }
        throw new IllegalArgumentException("Invalid ViewType [" + viewTypeStr + "]");
    }
}

