/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import java.io.Serializable;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;

public class Variable
implements Serializable {
    private int fractionSize;
    private String id;
    private int kind;
    private LocaleStringMap labels;
    private String mask;
    private int size;
    private static final long serialVersionUID = 11070938044340277L;

    protected Variable() {
    }

    protected Variable(String id, int kind) {
        this.id = id;
        this.kind = kind;
        this.labels = LocaleStringMap.create();
    }

    public static Variable create(String variableId, int variableKind) {
        return new Variable(variableId, variableKind);
    }

    public String getId() {
        return this.id;
    }

    public int getKind() {
        return this.kind;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setFractionSize(int fractionSize) {
        this.fractionSize = fractionSize;
    }

    public int getFractionSize() {
        return this.fractionSize;
    }

    public boolean isDefault() {
        return false;
    }

    public void setSize(int size, int fractionSize) {
        this.size = size;
        this.fractionSize = fractionSize;
    }

    public void setLabel(String label, Locale locale) {
        this.labels.put(locale, label);
    }

    public void setLabels(LocaleStringMap labels) {
        this.labels.putAll(labels);
    }

    public void clearLables() {
        this.labels.clear();
    }

    public String getLabel(Locale locale) {
        String label = this.labels.getString(locale);
        if ("".equals(label)) {
            label = this.id;
        }
        return label;
    }

    public LocaleStringMap getLabels() {
        return this.labels;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getMask() {
        return this.mask;
    }
}

