/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import java.util.Locale;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum StatusScope implements I18nProvider
{
    ONLY_INPROCESS(LibMsg.ONLY_INPROCESS),
    ONLY_COMPLETED(LibMsg.ONLY_COMPLETED),
    ONLY_ABORTED(LibMsg.ONLY_ABORTED),
    INPROCESS_AND_COMPLETED(LibMsg.INPROCESS_AND_COMPLETED),
    INPROCESS_AND_ABORTED(LibMsg.INPROCESS_AND_ABORTED),
    ABORTED_AND_COMPLETED(LibMsg.ABORTED_AND_COMPLETED),
    ALL(LibMsg.ALL);

    private transient Msg msg;

    private StatusScope(Msg msg) {
        this.msg = msg;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public boolean isInProcess() {
        return this == ALL || this == INPROCESS_AND_COMPLETED || this == INPROCESS_AND_ABORTED || this == ONLY_INPROCESS;
    }

    public boolean isCompleted() {
        return this == ALL || this == INPROCESS_AND_COMPLETED || this == ABORTED_AND_COMPLETED || this == ONLY_COMPLETED;
    }

    public boolean isAborted() {
        return this == ALL || this == INPROCESS_AND_ABORTED || this == ABORTED_AND_COMPLETED || this == ONLY_ABORTED;
    }

    public static StatusScope valueOf(boolean inProcess, boolean completed, boolean aborted) {
        StatusScope result;
        if (inProcess) {
            result = completed ? (aborted ? ALL : INPROCESS_AND_COMPLETED) : (aborted ? INPROCESS_AND_ABORTED : ONLY_INPROCESS);
        } else if (completed) {
            result = aborted ? ABORTED_AND_COMPLETED : ONLY_COMPLETED;
        } else {
            if (!aborted) {
                throw new IllegalArgumentException("Illegal combination");
            }
            result = ONLY_ABORTED;
        }
        return result;
    }
}

