/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.view.Variable;
import oracle.bpm.view.mgmt.VariableManager;

public class Ordering
implements Serializable {
    private List<Entry> attributes = new ArrayList<Entry>();
    static final long serialVersionUID = -3750463778407654881L;
    static final long serialCheck = -2830250088324143342L;

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public Entry getEntry(int index) {
        return index >= this.attributes.size() ? null : this.attributes.get(index);
    }

    public int getEntryCount() {
        return this.attributes.size();
    }

    public int add(String variableId, boolean ascending) {
        return this.add(new Entry(variableId, ascending));
    }

    public int add(Entry entry) {
        this.checkVariable(entry.variableId);
        if (this.contains(entry.getVariableId())) {
            return this.update(entry.getVariableId(), entry.isAscending());
        }
        int index = this.attributes.size();
        this.attributes.add(entry);
        return index;
    }

    public int update(String variableId, boolean ascending) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Entry entry = this.attributes.get(i);
            if (!entry.getVariableId().equalsIgnoreCase(variableId)) continue;
            entry.ascending = ascending;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.attributes.clear();
    }

    public boolean contains(String variableId) {
        for (Entry entry : this.attributes) {
            if (!entry.getVariableId().equalsIgnoreCase(variableId)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Entry entry) {
        return this.attributes.contains(entry);
    }

    public Ordering copy() {
        Ordering copy = new Ordering();
        for (Entry entry : this.attributes) {
            if (entry.getVariableId() != null) {
                copy.add(entry.getVariableId(), entry.isAscending());
                continue;
            }
            copy.add(entry.getVariableId(), entry.isAscending());
        }
        return copy;
    }

    public Entry[] toArray() {
        if (this.isEmpty()) {
            return new Entry[0];
        }
        return this.attributes.toArray(new Entry[this.attributes.size()]);
    }

    public int indexOf(Entry entry) {
        return this.attributes.indexOf(entry);
    }

    public boolean removeEntry(Entry entry) {
        return this.attributes.remove(entry);
    }

    public Entry removeEntry(int index) {
        return this.attributes.remove(index);
    }

    public Entry getEntry(String variableId) {
        for (Entry attribute : this.attributes) {
            if (!attribute.getVariableId().equals(variableId)) continue;
            return attribute;
        }
        return null;
    }

    public boolean removeEntry(String variableId) {
        for (Entry attribute : this.attributes) {
            if (!attribute.getVariableId().equals(variableId)) continue;
            return this.removeEntry(attribute);
        }
        return false;
    }

    public void moveEntryDown(int row) {
        this.attributes.add(row + 1, this.attributes.remove(row));
    }

    public void moveEntryUp(int row) {
        this.attributes.add(row - 1, this.attributes.remove(row));
    }

    private void checkVariable(String variableId) {
        if (!VariableManager.isExternal(variableId)) {
            for (Variable var : VariableManager.getDefaultInstanceVariables()) {
                if (!variableId.equals(var.getId())) continue;
                return;
            }
            throw new IllegalArgumentException("Invalid VarDefinition");
        }
    }

    public class Entry
    implements Serializable {
        private boolean ascending;
        private String variableId;
        static final long serialCheck = 933240811981892747L;
        static final long serialVersionUID = 5893119683815970140L;
        static final long SerialVersionUID = 1L;

        public Entry(String variableId, boolean ascending) {
            this.variableId = variableId;
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public String getVariableId() {
            return this.variableId;
        }

        public boolean equals(Object that) {
            boolean result;
            boolean bl = result = this == that;
            if (!result) {
                boolean bl2 = result = that != null && that instanceof Entry;
                if (result) {
                    Entry e = (Entry)that;
                    result = this.ascending == e.isAscending() && this.variableId.equalsIgnoreCase(e.getVariableId());
                }
            }
            return result;
        }

        public int hashCode() {
            int hashCode = 23;
            hashCode = 17 * hashCode + this.variableId.hashCode();
            hashCode = 17 * hashCode + (this.ascending ? 1 : 0);
            return hashCode;
        }
    }
}

