/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import oracle.bpm.view.ActivityViewImpl;
import oracle.bpm.view.FilterImpl;
import oracle.bpm.view.ParticipantScope;
import oracle.bpm.view.PresentationType;
import oracle.bpm.view.SearchScope;
import oracle.bpm.view.StatusScope;
import oracle.bpm.view.ViewImpl;
import oracle.bpm.view.ViewType;

public class InstancesViewImpl
extends ViewImpl {
    protected FilterImpl filter;
    public static final String DEFAULT_PRESENTATION = "default_instances";
    static final long serialVersionUID = -8237506711786217777L;
    static final long serialCheck = -4054473974907115180L;

    public InstancesViewImpl(String id, String owner) {
        super(id, owner);
    }

    public void setFilter(FilterImpl filter) {
        this.filter = filter;
    }

    public FilterImpl getFilter() {
        if (this.filter == null) {
            this.filter = new FilterImpl();
            this.filter.setName(this.getId());
            this.filter.setSearchScope(new SearchScope(ParticipantScope.ALL, StatusScope.ONLY_INPROCESS, null));
        }
        return this.filter;
    }

    @Override
    public PresentationType getPresentationType() {
        return PresentationType.INSTANCES;
    }

    @Override
    public ViewType getType() {
        return ViewType.INSTANCES;
    }

    @Override
    public ViewImpl copy() {
        InstancesViewImpl copy = (InstancesViewImpl)super.copy();
        if (this.filter != null) {
            copy.filter = this.filter.copy();
        }
        return copy;
    }

    public ActivityViewImpl createActivityView(String activity) {
        ActivityViewImpl activityView = ViewImpl.createActivityView(this.id, null, this.ownerId);
        activityView.setActivityName(activity);
        activityView.setActivityType(2);
        activityView.setReadOnly(this.isReadOnly);
        activityView.setHidden(this.isHidden);
        activityView.setCustom(true);
        activityView.setTransient(true);
        activityView.setLabels(this.labels);
        activityView.setPresentation(this.presentationId);
        activityView.setFilter(this.filter);
        return activityView;
    }

    @Override
    public String toString() {
        StringBuffer description = new StringBuffer(super.toString());
        description.append("-- Filter -- \n");
        description.append(this.getFilter().getDescription());
        description.append("-- -- \n");
        return description.toString();
    }

    @Override
    protected String getDefaultPresentation() {
        return DEFAULT_PRESENTATION;
    }
}

