/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.bpm.view.Comparison;
import oracle.bpm.view.FilterAttributeImpl;
import oracle.bpm.view.Ordering;
import oracle.bpm.view.ParticipantScope;
import oracle.bpm.view.SearchScope;
import oracle.bpm.view.StatusScope;

public class FilterImpl
implements Serializable {
    private Set<FilterAttributeImpl> attributes;
    private transient Map<String, List<FilterAttributeImpl>> attributesByVariable;
    private boolean caseSensitive = false;
    private transient int hashCode = -1;
    private boolean matchAll = true;
    private String name;
    private Ordering ordering;
    private SearchScope searchScope;
    private Set<FilterImpl> subfilters = new HashSet<FilterImpl>();
    static final long serialVersionUID = -4483743745744243711L;
    static final long serialCheck = -7529273642519881312L;

    public FilterImpl() {
        this.name = "Filter-" + System.currentTimeMillis();
        this.attributes = new HashSet<FilterAttributeImpl>();
        this.searchScope = new SearchScope(ParticipantScope.ALL_IN_ROLE, StatusScope.ONLY_INPROCESS);
        this.ordering = new Ordering();
        this.subfilters = new HashSet<FilterImpl>();
    }

    public void addAttribute(FilterAttributeImpl attribute) {
        List<FilterAttributeImpl> attributeList = this.attributesByVariable().get(attribute.getVariableId());
        if (attributeList == null) {
            attributeList = new ArrayList<FilterAttributeImpl>();
            this.attributesByVariable().put(attribute.getVariableId(), attributeList);
        }
        attributeList.add(attribute);
        this.attributes.add(attribute);
    }

    public FilterAttributeImpl addAttribute(String variableId, int kind, Comparison comparator, Object value, boolean parametric) {
        FilterAttributeImpl FilterAttributeImpl2 = new FilterAttributeImpl(variableId, kind, comparator, value);
        FilterAttributeImpl2.setParametric(parametric);
        FilterAttributeImpl2.setKind(kind);
        this.addAttribute(FilterAttributeImpl2);
        return FilterAttributeImpl2;
    }

    public boolean areTheSameFilter(FilterImpl _filterImpl) {
        Iterator<Serializable> i$;
        String activityScope = this.getSearchScope().getActivityScope();
        String _activityScope = _filterImpl.getSearchScope().getActivityScope();
        List<FilterAttributeImpl> _attributes = _filterImpl.getAttributes();
        List<FilterImpl> _subFilters = _filterImpl.getFilters();
        if (_filterImpl.getSearchScope().getStatusScope() != this.getSearchScope().getStatusScope() || _filterImpl.getSearchScope().getParticipantScope() != this.getSearchScope().getParticipantScope()) {
            return false;
        }
        if (_activityScope == null && activityScope != null || _activityScope != null && activityScope == null || _activityScope != null && !activityScope.equalsIgnoreCase(_activityScope)) {
            return false;
        }
        if (_attributes == null && this.attributes != null || _attributes != null && this.attributes == null || _attributes != null && this.attributes.size() != _attributes.size()) {
            return false;
        }
        if (_subFilters.size() != this.subfilters.size()) {
            return false;
        }
        boolean areEquals = true;
        if (_attributes != null && areEquals) {
            boolean containsAttribute = true;
            Iterator<FilterAttributeImpl> iterator = _attributes.iterator();
            while (iterator.hasNext() && containsAttribute) {
                FilterAttributeImpl attribute;
                FilterAttributeImpl _attribute = iterator.next();
                containsAttribute = false;
                i$ = this.attributes.iterator();
                while (i$.hasNext() && !(containsAttribute = _attribute.equals(attribute = (FilterAttributeImpl)i$.next()))) {
                }
            }
            areEquals = containsAttribute;
        }
        if (areEquals) {
            for (FilterImpl subfilter : this.subfilters) {
                FilterImpl _subfilter;
                boolean exist = false;
                i$ = _subFilters.iterator();
                while (i$.hasNext() && !(exist = subfilter.equals(_subfilter = (FilterImpl)i$.next()))) {
                }
                if (exist) continue;
                return false;
            }
        }
        return areEquals;
    }

    public boolean canOptimize() {
        StatusScope statusScope = this.searchScope.getStatusScope();
        return statusScope.isInProcess() && !statusScope.isAborted() && !statusScope.isCompleted();
    }

    public FilterImpl copy() {
        FilterImpl copy = new FilterImpl();
        copy.setMatchAll(this.matchAll);
        copy.setCaseSensitive(this.caseSensitive);
        copy.setName(this.name);
        copy.setSearchScope(new SearchScope(this.searchScope.getParticipantScope(), this.searchScope.getStatusScope(), this.searchScope.getActivityScope()));
        copy.setOrdering(this.ordering.copy());
        for (FilterAttributeImpl attribute : this.attributes) {
            FilterAttributeImpl copyFilterAttributeImpl = new FilterAttributeImpl(attribute.getVariableId(), attribute.getKind(), attribute.getComparison(), attribute.getValue());
            copyFilterAttributeImpl.setParametric(attribute.isParametric());
            copy.addAttribute(copyFilterAttributeImpl);
        }
        copy.subfilters = new HashSet<FilterImpl>();
        for (FilterImpl subFilterImpl : this.subfilters) {
            copy.subfilters.add(subFilterImpl.copy());
        }
        return copy;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof FilterImpl) {
            FilterImpl _FilterImpl = (FilterImpl)object;
            boolean areEquals = this.areTheSameFilter(_FilterImpl);
            if (areEquals) {
                Ordering _ordering = _FilterImpl.getOrdering();
                if (_ordering == null && this.ordering != null || _ordering != null && this.ordering == null || _ordering != null && _ordering.getEntryCount() != this.ordering.getEntryCount()) {
                    return false;
                }
                if (_ordering != null) {
                    int size = this.ordering.getEntryCount();
                    for (int i = 0; i < size && areEquals; ++i) {
                        Ordering.Entry entry = this.ordering.getEntry(i);
                        areEquals = entry.equals(_ordering.getEntry(i));
                    }
                }
            }
            return areEquals;
        }
        return false;
    }

    public List<FilterAttributeImpl> getAttributes() {
        ArrayList<FilterAttributeImpl> _attributes = new ArrayList<FilterAttributeImpl>();
        if (this.attributes != null) {
            _attributes.addAll(this.attributes);
        }
        return _attributes;
    }

    public Map<String, List<FilterAttributeImpl>> getAttributesByVariable() {
        TreeMap<String, List<FilterAttributeImpl>> attributes = new TreeMap<String, List<FilterAttributeImpl>>();
        attributes.putAll(this.attributesByVariable());
        return attributes;
    }

    public List<FilterAttributeImpl> getAttributesByVariable(String variable) {
        ArrayList<FilterAttributeImpl> result = new ArrayList<FilterAttributeImpl>();
        List<FilterAttributeImpl> attributeList = this.attributesByVariable().get(variable);
        if (attributeList != null) {
            result.addAll(attributeList);
        }
        return result;
    }

    public String getDescription() {
        return this.getDescription("");
    }

    public String getName() {
        return this.name;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public List<FilterAttributeImpl> getParametricAttributes() {
        ArrayList<FilterAttributeImpl> parametricAttributes = new ArrayList<FilterAttributeImpl>();
        for (FilterAttributeImpl attribute : this.attributes) {
            if (!attribute.isParametric()) continue;
            parametricAttributes.add(attribute);
        }
        return parametricAttributes;
    }

    public SearchScope getSearchScope() {
        return this.searchScope;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int decimal;
            this.hashCode = decimal = this.searchScope.getStatusScope().hashCode() % 100;
            decimal = this.searchScope.getParticipantScope().hashCode() % 100;
            this.hashCode += decimal;
            decimal = this.searchScope.getActivityScope() != null ? this.searchScope.getActivityScope().hashCode() % 100 : 0;
            this.hashCode += decimal;
            decimal = 0;
            for (FilterAttributeImpl attribute : this.attributes) {
                decimal += attribute.hashCode() % 100000;
            }
            this.hashCode += decimal;
            decimal = 0;
            for (FilterImpl subfilter : this.subfilters) {
                decimal += subfilter.hashCode() % 100000;
            }
            this.hashCode += decimal;
        }
        return this.hashCode;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public boolean isParametric() {
        for (FilterAttributeImpl attribute : this.attributes) {
            if (!attribute.isParametric()) continue;
            return true;
        }
        return false;
    }

    public void clearAttributes() {
        this.attributes.clear();
        this.attributesByVariable.clear();
    }

    public void removeAttribute(FilterAttributeImpl attribute) {
        List<FilterAttributeImpl> attributeList = this.attributesByVariable().get(attribute.getVariableId());
        if (attributeList != null) {
            attributeList.remove(attribute);
            this.attributes.remove(attribute);
        }
    }

    public List<FilterAttributeImpl> removeAttributes(String variable) {
        List<FilterAttributeImpl> removedAttributes = this.attributesByVariable().remove(variable);
        if (removedAttributes != null) {
            for (FilterAttributeImpl attribute : removedAttributes) {
                this.attributes.remove(attribute);
            }
        }
        return removedAttributes;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setMatchAll(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrdering(Ordering ordering) {
        if (ordering == null) {
            ordering = new Ordering();
        }
        this.ordering = ordering;
    }

    public void setSearchScope(SearchScope searchScope) {
        if (searchScope == null) {
            searchScope = new SearchScope(ParticipantScope.ALL, StatusScope.ALL);
        }
        this.searchScope = searchScope;
    }

    public String toString() {
        return this.getDescription();
    }

    public void addFilter(FilterImpl subFilterImpl) {
        this.subfilters.add(subFilterImpl);
    }

    public boolean removeFilter(FilterImpl subFilterImpl) {
        return this.subfilters.remove(subFilterImpl);
    }

    public List<FilterImpl> getFilters() {
        ArrayList<FilterImpl> result = new ArrayList<FilterImpl>();
        result.addAll(this.subfilters);
        return result;
    }

    private String getDescription(String indent) {
        StringBuffer description = new StringBuffer();
        description.append(indent);
        description.append("FilterImpl\n");
        description.append(indent);
        description.append("\tName = '");
        description.append(this.getName());
        description.append("'\n");
        description.append(indent);
        description.append("\tMatchAll = '");
        description.append(this.matchAll);
        description.append("'\n");
        description.append(indent);
        description.append("\tCaseSensitive = '");
        description.append(this.caseSensitive);
        description.append("'\n");
        description.append(indent);
        description.append("\tSearchScope\n");
        description.append(indent);
        description.append("\t\tStatusScope = '");
        description.append(this.searchScope.getStatusScope().getString());
        description.append("'(");
        description.append(this.searchScope.getStatusScope().isInProcess());
        description.append(", ");
        description.append(this.searchScope.getStatusScope().isCompleted());
        description.append(", ");
        description.append(this.searchScope.getStatusScope().isAborted());
        description.append(")\n");
        description.append(indent);
        description.append("\t\tParticipantScope = '");
        description.append(this.searchScope.getParticipantScope().getString());
        description.append("'\n");
        description.append(indent);
        description.append("\t\tActivityScope = '");
        description.append(this.searchScope.getActivityScope());
        description.append("'\n");
        description.append(indent);
        description.append("\tAttributes\n");
        List<FilterAttributeImpl> attributeList = this.getAttributes();
        for (FilterAttributeImpl attribute : attributeList) {
            description.append(indent);
            description.append("\t\t");
            description.append(attribute.toString());
            description.append("\n");
        }
        description.append(indent);
        description.append("\tOrdering\n");
        for (int i = 0; i < this.ordering.getEntryCount(); ++i) {
            Ordering.Entry entry = this.ordering.getEntry(i);
            String order = entry.isAscending() ? "ASC" : "DESC";
            description.append(indent);
            description.append("\t\tEntry ");
            description.append(entry.getVariableId());
            description.append(" ");
            description.append(order);
            description.append("\n");
        }
        description.append(indent);
        description.append("\tsubfilters\n");
        for (FilterImpl subFilterImpl : this.subfilters) {
            description.append("Subfilter ");
            description.append(subFilterImpl.getDescription(indent + "\t"));
            description.append("\n");
        }
        return description.toString();
    }

    private Map<String, List<FilterAttributeImpl>> attributesByVariable() {
        if (this.attributesByVariable == null) {
            this.attributesByVariable = new TreeMap<String, List<FilterAttributeImpl>>(String.CASE_INSENSITIVE_ORDER);
            for (FilterAttributeImpl attribute : this.attributes) {
                List<FilterAttributeImpl> attributeList = this.attributesByVariable.get(attribute.getVariableId());
                if (attributeList == null) {
                    attributeList = new ArrayList<FilterAttributeImpl>();
                    this.attributesByVariable.put(attribute.getVariableId(), attributeList);
                }
                attributeList.add(attribute);
            }
        }
        return this.attributesByVariable;
    }
}

