/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.HashMap;

public final class StringMap {
    private int currentSize_d;
    private int elementCount_d = 0;
    private Entry[] entries_d;
    private int mask;
    private static final double loadFactor_sd = 0.7;

    public StringMap() {
        this(16);
    }

    public StringMap(int initialSize) {
        this.currentSize_d = StringMap.findSize(initialSize);
        this.mask = this.currentSize_d - 1;
        this.entries_d = new Entry[this.currentSize_d];
    }

    public StringMap(String[] keys, int[] values) {
        this(keys.length);
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Key length must match value length");
        }
        for (int i = 0; i < keys.length; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    public static void main(String[] args) throws Throwable {
        String[] testSet = new String[]{"arg", "argument", "array", "attributes", "boolean", "calculate", "className", "component", "defaultValue", "description", "dynamic", "enumeration", "exception", "flags", "group", "implementationName", "indexType", "inputArguments", "int", "isVisible", "item", "iterator", "javaType", "label", "length", "map", "maxOcur", "method", "methods", "modifiers", "name", "object", "objectProperty", "ordered", "outputArgument", "precision", "presentation", "primitive", "property", "readSignature", "remote", "required", "scale", "signature", "template", "type", "validValues", "validValuesMethodSignature", "validate", "value", "writeSignature"};
        int howMany = 100;
        int repeat = 100000;
        String[] args1 = new String[100];
        for (int j = 0; j < 100; ++j) {
            args1[j] = "" + j + "key";
        }
        System.err.println("******* WARM UP ********");
        System.err.println("##### Using random strings");
        long string = StringMap.useStringMap(args1, 100000);
        long hash = StringMap.useHashMap(args1, 100000);
        System.err.println("@@ StringMap gain: " + (hash - string) * 100L / hash + "%");
        System.err.println("##### Using typical set");
        string = StringMap.useStringMap(testSet, 100000);
        hash = StringMap.useHashMap(testSet, 100000);
        System.err.println("@@ StringMap gain: " + (hash - string) * 100L / hash + "%");
        System.err.println("******* FINAL ********");
        System.err.println("##### Using random strings");
        string = StringMap.useStringMap(args1, 100000);
        hash = StringMap.useHashMap(args1, 100000);
        System.err.println("@@ StringMap gain: " + (hash - string) * 100L / hash + "%");
        System.err.println("##### Using typical set");
        string = StringMap.useStringMap(testSet, 100000);
        hash = StringMap.useHashMap(testSet, 100000);
        System.err.println("@@ StringMap gain: " + (hash - string) * 100L / hash + "%");
    }

    public int get(String key) {
        int kh = key.hashCode();
        int hash = kh - (kh << 7);
        int index = hash & this.mask;
        Entry e = this.entries_d[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return -1;
    }

    public void put(String key, int value) {
        this.ensureCapacity();
        int kh = key.hashCode();
        int hash = kh - (kh << 7);
        int index = hash & this.mask;
        Entry e = this.entries_d[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.entries_d[index] = new Entry(this.entries_d[index], key, value, hash);
    }

    public void dump() {
        double total = 0.0;
        int empty = 0;
        for (int i = 0; i < this.currentSize_d; ++i) {
            System.out.print(i + ":");
            Entry e = this.entries_d[i];
            int bucketSize = 0;
            while (e != null) {
                System.out.print('*');
                e = e.next;
                ++bucketSize;
            }
            if (bucketSize == 0) {
                ++empty;
            }
            total += (double)bucketSize;
            System.out.println();
        }
        System.out.println("Avg Bucket Size: " + total / (double)this.currentSize_d);
        System.out.println("Avg Full Bucket Size: " + total / (double)(this.currentSize_d - empty));
    }

    private static int findSize(int i) {
        int candidate = 2;
        while (i >= candidate || !((double)i / (double)candidate < 0.7)) {
            candidate *= 2;
        }
        return candidate;
    }

    private static long useHashMap(String[] as, int repeat) {
        HashMap<String, Integer> hashmap = new HashMap<String, Integer>(as.length);
        System.err.println("# Using java.util.HashMap");
        System.err.print("\tputting " + as.length + "...");
        long l = System.currentTimeMillis();
        for (int i = 0; i < as.length; ++i) {
            hashmap.put(as[i], i);
        }
        System.err.println("took: " + (System.currentTimeMillis() - l) + "ms.");
        System.err.print("\tsearching " + as.length * repeat + "...");
        l = System.currentTimeMillis();
        int last = 0;
        while (--repeat > 0) {
            for (String a : as) {
                last = (Integer)hashmap.get(a);
            }
        }
        long searchTime = System.currentTimeMillis() - l;
        System.err.println("took: " + searchTime + "ms.");
        System.out.println("Last Index: " + last);
        return searchTime;
    }

    private static long useStringMap(String[] as, int repeat) {
        StringMap stringmap = new StringMap(as.length);
        System.err.println("# Using oracle.bpm.util.StringMap");
        System.err.print("\tputting " + as.length + "...");
        long l = System.currentTimeMillis();
        for (int i = 0; i < as.length; ++i) {
            stringmap.put(as[i], i);
        }
        long putTime = System.currentTimeMillis() - l;
        System.err.println("took: " + putTime + "ms.");
        System.err.print("\tsearching " + as.length * repeat + "...");
        l = System.currentTimeMillis();
        int last = 0;
        while (--repeat > 0) {
            for (String a : as) {
                last = stringmap.get(a);
            }
        }
        long searchTime = System.currentTimeMillis() - l;
        System.err.println("took: " + searchTime + "ms.");
        System.out.println("Last Index: " + last);
        return searchTime;
    }

    private void ensureCapacity() {
        if ((double)this.elementCount_d / (double)this.currentSize_d > 0.7) {
            Entry[] oldEntries = this.entries_d;
            this.entries_d = new Entry[this.currentSize_d * 2];
            for (Entry oldEntry : oldEntries) {
                if (oldEntry == null) continue;
                this.put(oldEntry.key, oldEntry.value);
            }
            this.currentSize_d *= 2;
            this.mask = this.currentSize_d - 1;
        }
    }

    private static class Entry {
        final int hash;
        final String key;
        Entry next;
        int value;

        Entry(Entry next, String key, int value, int hash) {
            this.next = next;
            this.key = key;
            this.value = value;
            this.hash = hash;
        }
    }
}

