/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import oracle.bpm.util.CharArrayMap;

public class StringCache {
    private char[] buffer = new char[256];
    private Entry chain;
    private Entry endChain;
    private Entry freeEntry;
    private CharArrayMap<Entry> map;
    private int maxSize;
    private int size;
    private static final int DEFAULT_MAX_SIZE = 300;
    private static final int DEFAULT_INITIAL_CAPACITY = 701;

    public StringCache() {
        this(300, 701);
    }

    public StringCache(int maxSize) {
        this(maxSize, 2 * maxSize);
    }

    public StringCache(int maxSize, int initialMapCapacity) {
        this.maxSize = maxSize;
        this.map = new CharArrayMap(initialMapCapacity);
    }

    public String getString(String text) {
        char[] result;
        int length = text.length();
        if (length <= this.buffer.length) {
            text.getChars(0, length, this.buffer, 0);
            result = this.buffer;
        } else {
            result = text.toCharArray();
        }
        return this.getString(result, 0, length);
    }

    public String getString(char[] chars, int offset, int len) {
        String ret = "";
        if (len != 0 && (ret = this.find(chars, offset, len)) == null) {
            ret = new String(chars, offset, len);
            this.storeString(ret);
        }
        return ret;
    }

    private String find(char[] chars, int offset, int len) {
        String ret = null;
        Entry e = this.map.get(chars, offset, len);
        if (e != null) {
            this.moveEntryToStart(e);
            ret = e.str;
        }
        return ret;
    }

    private void storeString(String s) {
        Entry e;
        if (this.size >= this.maxSize) {
            e = this.replaceLast(s);
        } else {
            e = this.createEntry(s);
            this.addEntryToChain(e);
        }
        this.map.put(s, e);
    }

    private void addEntryToChain(Entry e) {
        if (this.chain != null) {
            this.chain.prev = e;
        } else {
            this.endChain = e;
        }
        this.chain = e;
        ++this.size;
    }

    private Entry createEntry(String s) {
        Entry e;
        if (this.freeEntry != null) {
            e = this.freeEntry;
            this.freeEntry = null;
            e.str = s;
            e.next = this.chain;
        } else {
            e = new Entry(s, this.chain);
        }
        return e;
    }

    private Entry replaceLast(String s) {
        Entry e = this.endChain;
        this.moveEntryToStart(e);
        this.map.remove(e.str);
        e.str = s;
        return e;
    }

    private void moveEntryToStart(Entry e) {
        if (e != this.chain) {
            Entry ep = e.prev;
            Entry en = e.next;
            if (en != null) {
                en.prev = ep;
            } else {
                this.endChain = ep;
            }
            ep.next = en;
            if (this.chain != null) {
                e.next = this.chain;
                this.chain.prev = e;
            }
            this.chain = e;
        }
    }

    static class Entry {
        Entry next;
        Entry prev;
        String str;

        Entry(String str, Entry next) {
            this.str = str;
            this.next = next;
        }
    }
}

