/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.net.MalformedURLException;
import oracle.bpm.util.ProtocolMalformedURLException;

public class ParsedURL {
    private String file_d;
    private String host_d;
    private String passwd_d;
    private String port_d;
    private String protocol_d;
    private String subProtocol_d;
    private String user_d;

    private ParsedURL(String protocol, String subProtocol, String user, String passwd, String host, String port, String file) {
        this.protocol_d = protocol;
        this.subProtocol_d = subProtocol;
        this.user_d = user;
        this.passwd_d = passwd;
        this.host_d = host;
        this.port_d = port;
        this.file_d = file;
    }

    public static ParsedURL parse(String url) throws MalformedURLException {
        int colon;
        String host;
        String[] protocols = ParsedURL.parseProtocols(url);
        assert (protocols[0] != null);
        String protocol = protocols[0];
        String subProtocol = protocols[1];
        int hostStart = url.indexOf("//");
        if (hostStart == -1) {
            throw new MalformedURLException(url + ": No double slash");
        }
        int hostEnd = url.indexOf(47, hostStart += 2);
        String file = null;
        if (hostEnd != -1) {
            host = url.substring(hostStart, hostEnd);
            file = url.substring(hostEnd + 1);
        } else {
            host = url.substring(hostStart);
        }
        String user = null;
        String passwd = null;
        int atSign = host.indexOf(64);
        if (atSign != -1) {
            user = host.substring(0, atSign);
            host = host.substring(atSign + 1);
            colon = user.indexOf(58);
            if (colon != -1) {
                passwd = user.substring(colon + 1);
                user = user.substring(0, colon);
            }
        }
        colon = host.indexOf(58);
        String port = null;
        if (colon != -1) {
            port = host.substring(colon + 1);
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new MalformedURLException(url + " : '" + port + "' is not a valid port.");
            }
            host = host.substring(0, colon);
        }
        return new ParsedURL(protocol, subProtocol, user, passwd, host, port, file);
    }

    public static String[] parseProtocols(String url) throws ProtocolMalformedURLException {
        String[] parsed = new String[2];
        int firstColon = url.indexOf(58);
        if (firstColon == -1) {
            throw new ProtocolMalformedURLException(url + ": No colon protocol separator");
        }
        parsed[0] = url.substring(0, firstColon);
        int secondColon = url.indexOf(58, firstColon + 1);
        int subNameStart = url.indexOf("//");
        if (secondColon == -1 && (subNameStart == -1 || subNameStart != firstColon + 1)) {
            throw new ProtocolMalformedURLException(url + ": Nor subprotocol neither double slash or in bad position");
        }
        if (secondColon != -1 && (subNameStart == -1 || secondColon < subNameStart)) {
            parsed[1] = url.substring(firstColon + 1, secondColon);
        }
        return parsed;
    }

    public static ParsedURL valueOf(String protocol, String subProtocol, String user, String passwd, String host, String port, String file) {
        return new ParsedURL(protocol, subProtocol, user, passwd, host, port, file);
    }

    public static void main(String[] args) throws MalformedURLException {
        ParsedURL parsedURL = ParsedURL.parse(args[0]);
        System.out.println("protocol    = " + parsedURL.getProtocol());
        System.out.println("subprotocol = " + parsedURL.getSubProtocol());
        System.out.println("user        = " + parsedURL.getUser());
        System.out.println("password    = " + parsedURL.getPasswd());
        System.out.println("host        = " + parsedURL.getHost());
        System.out.println("port        = " + parsedURL.getPort());
        System.out.println("file        = " + parsedURL.getFile());
    }

    public final String getFile() {
        return this.file_d;
    }

    public final String getHost() {
        return this.host_d;
    }

    public final String getPasswd() {
        return this.passwd_d;
    }

    public final String getPort() {
        return this.port_d;
    }

    public final String getProtocol() {
        return this.protocol_d;
    }

    public final String getSubProtocol() {
        return this.subProtocol_d;
    }

    public final String getUser() {
        return this.user_d;
    }
}

