/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import oracle.bpm.http.AbstractHttpCommand;
import oracle.bpm.http.HttpCommandServer;
import oracle.bpm.http.HttpRequest;
import oracle.bpm.http.HttpResponse;
import oracle.bpm.lang.Cache;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.util.Identifier;
import oracle.bpm.util.NetURL;

public class ObjectWatch
extends AbstractHttpCommand {
    private Field field;
    private WeakReference root;
    private static RefCache references = null;
    private static ObjectWatch default_sd;
    private static final int MAX_LENGTH = 200;
    private static String[] passwordFields_sd;
    private static String[] validPasswordFields;

    public ObjectWatch(String name, String description, Object value) {
        super(name, description);
        if (value != null) {
            this.root = new WeakReference<Object>(value);
        }
    }

    public ObjectWatch(String name, String description, Object value, Field field) {
        this(name, description, value);
        this.field = field;
        if (this.field != null) {
            this.field.setAccessible(true);
        }
    }

    public static ObjectWatch getDefault() {
        if (default_sd == null) {
            default_sd = new ObjectWatch("defaultwatch", "default watch", (Object)null);
            HttpCommandServer.getDefault().register(default_sd);
        }
        return default_sd;
    }

    public static ObjectWatch register(String group, String name, String descr, Object value) {
        ObjectWatch watch = new ObjectWatch(Identifier.validLowerCase(name), descr, value);
        watch.setGroup(group);
        return ObjectWatch.register(watch);
    }

    public static ObjectWatch register(String group, String name, String descr, Object value, Field field) {
        ObjectWatch watch = new ObjectWatch(name, descr, value, field);
        watch.setGroup(group);
        return ObjectWatch.register(watch);
    }

    public static ObjectWatch register(ObjectWatch watch) {
        HttpCommandServer server = HttpCommandServer.getDefault();
        server.register(watch);
        return watch;
    }

    public String getId(Object value) {
        return this.getId(value, "");
    }

    public String getId(Object value, String context) {
        return this.getId(value, context, null, null);
    }

    public String getId(Object value, String context, String label) {
        return this.getId(value, context, label, null);
    }

    public String getId(Object value, String context, String label, String container) {
        if (value instanceof Reference) {
            Reference ref = (Reference)value;
            String refclass = value.getClass().getName();
            int index = refclass.lastIndexOf(46);
            if (index != -1) {
                refclass = refclass.substring(index + 1);
            }
            return this.getId(ref.get(), context, label, refclass);
        }
        if (this.isPredefined(value) && label == null) {
            String result = this.valueOf(value);
            if (container != null) {
                result = container + "(" + result + ")";
            }
            return result;
        }
        Long id = ObjectWatch.getReferences().getId(value);
        if (label == null) {
            label = value instanceof Class ? this.valueOf(value) : this.classname(value.getClass());
        }
        String result = "<a href='/" + this.getName() + "?objectId=" + id + "&context=" + context + "'>" + label + "</a>";
        if (container != null) {
            result = container + "(" + result + ")";
        }
        return result;
    }

    public Object getObjectFromPlainId(Long id) {
        WeakReference ref = (WeakReference)ObjectWatch.getReferences().get(id);
        return ref != null ? ref.get() : null;
    }

    public Long getPlainId(Object value) {
        return ObjectWatch.getReferences().getId(value);
    }

    @Override
    public void process(HttpRequest request, HttpResponse response) throws IOException {
        String dumped;
        Object value;
        WeakReference ref;
        Map<String, String> args = request.getArguments();
        PrintStream out = response.getPrintStream();
        StringBuffer result = new StringBuffer(512);
        Long id = null;
        String objectId = args.get("objectId");
        String context = args.get("context");
        if (objectId != null) {
            id = Long.valueOf(objectId);
        }
        if (context == null) {
            context = this.getName();
        }
        if (id != null) {
            ref = (WeakReference)ObjectWatch.getReferences().get(id);
            if (ref == null) {
                out.println("This object has expired, try to find it again.");
                return;
            }
            value = ref.get();
        } else {
            ref = this.root;
            Object object = value = ref != null ? (Object)ref.get() : null;
            if (this.field != null && (Modifier.isStatic(this.field.getModifiers()) || value != null)) {
                try {
                    value = this.field.get(value);
                }
                catch (IllegalAccessException ignore) {
                    ignore.printStackTrace();
                }
                if (value == null) {
                    out.println("this object is null");
                    return;
                }
            }
        }
        if (value == null) {
            out.println("this object was collected");
            return;
        }
        String contextHeader = this.header("[context]", Str.replace(context, "/", " > "));
        context = this.getLastContextElements(context, 3);
        if (this.isPredefined(value)) {
            dumped = "<pre>" + this.valueOf(value) + "</pre>";
        } else {
            result.append(contextHeader);
            dumped = this.dump(value, context);
        }
        result.append(dumped);
        out.println(this.wrap(result.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RefCache getReferences() {
        if (references != null) return references;
        Class<ObjectWatch> clazz = ObjectWatch.class;
        synchronized (ObjectWatch.class) {
            if (references != null) return references;
            references = new RefCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return references;
        }
    }

    private static boolean canShowField(String field) {
        for (String validPasswordField : validPasswordFields) {
            if (field.indexOf(validPasswordField.toLowerCase()) == -1) continue;
            return true;
        }
        return false;
    }

    private String getLastContextElements(String context, int count) {
        while (Str.count(context, '/') >= count) {
            int index = context.indexOf(47);
            context = context.substring(index + 1);
        }
        return context;
    }

    private boolean isPasswordField(String field) {
        String lowerCaseField = field.toLowerCase();
        for (String aPasswordFields_sd : passwordFields_sd) {
            if (lowerCaseField.indexOf(aPasswordFields_sd.toLowerCase()) == -1 || ObjectWatch.canShowField(lowerCaseField)) continue;
            return true;
        }
        return false;
    }

    private boolean isPredefined(Object value) {
        return value == null || value instanceof String || value instanceof Character || value instanceof Number || value instanceof Boolean || value instanceof Time || value instanceof Date || value instanceof Interval || value instanceof NetURL;
    }

    private int appendEntry(Object element, String context, int i, StringBuffer result, int count) {
        Map.Entry entry = (Map.Entry)element;
        Object key = entry.getKey();
        Object val = entry.getValue();
        if (key != null || val != null) {
            String keytext = this.getId(key, context + "/key-" + i);
            String valtext = this.getId(val, context + "/value-" + i);
            result.append(this.map(keytext, valtext));
            ++count;
        }
        return count;
    }

    private String classname(Class cl) {
        String clname = "";
        while (cl != null) {
            clname = cl.getComponentType() == null ? cl.getName() + clname : clname + "[]";
            cl = cl.getComponentType();
        }
        return clname;
    }

    private String dump(Object value, String context) {
        StringBuffer result = new StringBuffer(512);
        Class<?> cl = value.getClass();
        if (value instanceof Map) {
            int i;
            Object[] table = null;
            if (value instanceof HashMap || value instanceof Hashtable) {
                try {
                    Class<?> current = cl;
                    String fieldName = "table";
                    if (value instanceof Cache) {
                        fieldName = "elements_d";
                    }
                    while (current != null) {
                        try {
                            Field field = current.getDeclaredField(fieldName);
                            field.setAccessible(true);
                            table = (Object[])field.get(value);
                        }
                        catch (NoSuchFieldException e) {
                            current = current.getSuperclass();
                        }
                    }
                }
                catch (IllegalAccessException e) {}
            } else {
                try {
                    Map map = (Map)value;
                    table = map.entrySet().toArray();
                }
                catch (ConcurrentModificationException e) {
                    result.append("There was a temporary problem reading a map, try again!");
                }
            }
            this.objectinfo(result, value);
            int length = table != null ? table.length : 0;
            result.append(this.header("[size]", String.valueOf(((Map)value).size())));
            int count = 0;
            for (i = 0; i < length && count < 200; ++i) {
                Object element = table[i];
                if (!(element instanceof Map.Entry)) continue;
                count = this.appendEntry(element, context, i, result, count);
                Map.Entry nextEntry = (Map.Entry)element;
                while ((nextEntry = this.nextEntry(nextEntry)) != null) {
                    count = this.appendEntry(nextEntry, context, i, result, count);
                }
            }
            if (i < length) {
                result.append(this.title("(only 200 elements were shown)"));
            }
            return result.toString();
        }
        if (value instanceof ArrayList) {
            ArrayList array = (ArrayList)value;
            value = array.toArray();
        } else if (value instanceof Collection) {
            try {
                Collection col = (Collection)value;
                value = col.toArray();
            }
            catch (ConcurrentModificationException e) {
                result.append("There was a temporary problem reading a collection, try again!");
            }
        }
        if (value.getClass().isArray()) {
            int length = ArrayUtils.length((Object)value);
            this.objectinfo(result, value);
            if (length > 200) {
                length = 200;
                result.append(this.title("(only 200 elements will be shown)"));
            }
            for (int i = 0; i < length; ++i) {
                String position = "#" + i;
                if (position.length() < 3) {
                    // empty if block
                }
                result.append(this.map(position, this.getId(Array.get(value, i), context + "/element-" + i)));
            }
        } else {
            if (value instanceof Throwable) {
                Throwable throwable = (Throwable)value;
                StringWriter stackTrace = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stackTrace));
                return "<pre>" + stackTrace.getBuffer().toString() + "</pre>";
            }
            if (value instanceof Class) {
                Class clazz = (Class)value;
                ClassLoader loader = clazz.getClassLoader();
                result.append(this.header("class", clazz.getName()));
                String id = this.getId(loader, context + "/" + "classloader");
                result.append(this.map("classloader", id));
            } else {
                this.objectinfo(result, value);
                while (cl != null && cl != Object.class) {
                    AccessibleObject[] fields = cl.getDeclaredFields();
                    AccessibleObject.setAccessible(fields, true);
                    try {
                        result.append(this.fieldsSep(this.classname(cl)));
                        for (AccessibleObject field1 : fields) {
                            String name = this.fieldname((Field)field1);
                            boolean staticf = Modifier.isStatic(((Field)field1).getModifiers());
                            if (staticf || name.indexOf("$") != -1) continue;
                            String id = this.getId(((Field)field1).get(value), context + "/" + name);
                            result.append(this.map(name, id));
                        }
                        boolean printStatic = true;
                        for (AccessibleObject field2 : fields) {
                            String name = this.fieldname((Field)field2);
                            boolean staticf = Modifier.isStatic(((Field)field2).getModifiers());
                            boolean finalf = Modifier.isFinal(((Field)field2).getModifiers());
                            if (!staticf || finalf || name.indexOf("$") != -1) continue;
                            if (printStatic) {
                                result.append(this.fieldsSep(this.classname(cl), true));
                                printStatic = false;
                            }
                            String id = this.getId(((Field)field2).get(value), context + "/" + name);
                            result.append(this.map(name, id));
                        }
                    }
                    catch (IllegalAccessException e) {
                        result.append(e.toString());
                    }
                    cl = cl.getSuperclass();
                }
            }
        }
        return result.toString();
    }

    private String fieldname(Field field) {
        String name = field.getName();
        if (name.endsWith("_d")) {
            name = name.substring(0, name.length() - 2);
        } else if (name.endsWith("_sd")) {
            name = name.substring(0, name.length() - 3);
        }
        if (name.length() < 25) {
            // empty if block
        }
        return name;
    }

    private String fieldsSep(String classname) {
        return this.fieldsSep(classname, false);
    }

    private String fieldsSep(String classname, boolean stfield) {
        return "<tr>" + this.td("<b>" + (stfield ? "Static " : "") + "Fields from " + classname) + "</b></tr>\n";
    }

    private String header(String key, String value) {
        return "<tr bgcolor=#cccccc>" + this.td(key) + this.td(value) + "</tr>\n";
    }

    private String map(String key, String value) {
        if (!this.isPasswordField(key)) {
            return "<tr>" + this.td(key) + this.td(value) + "</tr>\n";
        }
        return "<tr>" + this.td(key) + this.td("N/A") + "</tr>\n";
    }

    private Map.Entry nextEntry(Map.Entry entry) {
        Map.Entry nextEntry = null;
        try {
            String fieldName = "next";
            for (Class<?> current = entry.getClass(); current != null; current = current.getSuperclass()) {
                try {
                    Field field = current.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    nextEntry = (Map.Entry)field.get(entry);
                    break;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return nextEntry;
    }

    private void objectinfo(StringBuffer buffer, Object object) {
        if (object != null) {
            Class<?> cl = object.getClass();
            buffer.append(this.header("[class]", this.classname(cl)));
            buffer.append(this.header("[classLoader]", String.valueOf(cl.getClassLoader())));
        }
    }

    private String td(String text) {
        return "<td>" + text + "</td>";
    }

    private String title(String message) {
        return "<tr bgcolor=#999999>" + this.td(message) + "</tr>\n";
    }

    private String valueOf(Object value) {
        String text;
        if (value instanceof Class) {
            Class cl = (Class)value;
            text = cl.isInterface() ? "interface " : "class ";
            text = text + this.classname(cl);
        } else {
            text = String.valueOf(value);
        }
        return text;
    }

    private String wrap(String text) {
        StringBuffer buffer = new StringBuffer(128);
        String title = null;
        if (this != ObjectWatch.getDefault()) {
            title = this.getDescription();
        }
        buffer.append("<html>\n<head>\n");
        if (title != null) {
            buffer.append("<title>").append(title).append("</title>");
        }
        buffer.append("</head>\n");
        buffer.append("<body bgcolor=white>\n");
        buffer.append("<table width=100%><tr>");
        buffer.append("<td><b><big>").append(title).append("</big></b></td>");
        buffer.append("<td align=right><a href='/'>Home</a></td>");
        buffer.append("</tr></table>");
        buffer.append("<table width=100%>\n");
        buffer.append(text);
        buffer.append("</table></body>\n</html>\n");
        return buffer.toString();
    }

    static {
        passwordFields_sd = new String[]{"credential", "password"};
        validPasswordFields = new String[]{"fuego_password"};
    }

    static class RefCache
    extends Cache<Long, ObjectReference> {
        private Map<ObjectReference, Long> ids = Collections.synchronizedMap(new HashMap());
        private long nextId;
        static final long serialVersionUID = 7680764117821401025L;
        static final long serialCheck = -8681729387987139728L;

        RefCache() {
            super(5000);
        }

        @Override
        public ObjectReference put(Long key, ObjectReference value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            ObjectReference old = super.put(key, value);
            this.ids.put(value, key);
            return old;
        }

        @Override
        protected void dispose(ObjectReference o) {
            this.ids.remove(o);
        }

        Long getId(Object value) {
            ObjectReference ref = new ObjectReference(value);
            Long id = this.ids.get(ref);
            if (id == null) {
                id = ++this.nextId;
                this.put(id, ref);
            }
            return id;
        }
    }

    static class ObjectReference
    extends WeakReference<Object> {
        private int hashCode;

        ObjectReference(Object value) {
            super(value);
            this.hashCode = System.identityHashCode(value);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ObjectReference)) {
                return false;
            }
            ObjectReference ref = (ObjectReference)object;
            Object value1 = this.get();
            Object value2 = ref.get();
            if (value1 != null && value2 != null) {
                return value1 == value2;
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

