/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

public abstract class NameParser {
    protected R[][] rules_d = null;

    protected NameParser(R[][] rules) {
        this.rules_d = rules;
    }

    protected final void parse(String name, int ruleSet) throws ParseException {
        String next;
        if (name == null || ruleSet < 0) {
            return;
        }
        R[] set = this.rules_d[ruleSet];
        int maxRule = -1;
        int max = -1;
        for (int i = 0; i < set.length; ++i) {
            int v = set[i].matchLevel(name);
            if (v <= max) continue;
            maxRule = i;
            max = v;
        }
        if (maxRule == -1) {
            this.doError(name, ruleSet);
        }
        int from = set[maxRule].from != null ? set[maxRule].from.length() : 0;
        int to = set[maxRule].to != null ? name.indexOf(set[maxRule].to, from) : name.length();
        String current = name.substring(from, to);
        String string = next = name.length() == to ? null : name.substring(to);
        if (set[maxRule].action != -1) {
            this.doAction(set[maxRule].action, current);
        }
        this.parse(current, set[maxRule].subRule);
        if (set[maxRule].nextSet != -1) {
            this.parse(next, set[maxRule].nextSet);
        } else {
            this.parse(next, ruleSet);
        }
    }

    protected void doError(String name, int ruleSet) throws ParseException {
        throw new ParseException(name, ruleSet);
    }

    abstract void doAction(int var1, String var2);

    protected static class R {
        public int action;
        public String from;
        public int nextSet;
        public int subRule;
        public String to;

        R(String from, String to, int subRule) {
            this(from, to, subRule, -1);
        }

        R(String from, String to, int subRule, int action) {
            this(from, to, subRule, action, -1);
        }

        R(String from, String to, int subRule, int action, int nextSet) {
            this.from = from;
            this.to = to;
            this.subRule = subRule;
            this.action = action;
            this.nextSet = nextSet;
        }

        int matchLevel(String name) {
            if (this.from == null && this.to == null) {
                return 0;
            }
            if (this.from == null && name.indexOf(this.to) != -1) {
                return 0;
            }
            if (this.from != null && name.startsWith(this.from) && (this.to == null || name.indexOf(this.to, this.from.length()) != -1)) {
                return this.from.length();
            }
            return -1;
        }
    }

    protected static class ParseException
    extends Exception {
        public String name;
        public int ruleSet;
        static final long serialVersionUID = 703001007306190382L;
        static final long serialCheck = 8193593505307046571L;

        ParseException(String name, int ruleSet) {
            super("No viable alternative for: '" + name + "' - RuleSet [" + ruleSet + "]");
            this.ruleSet = ruleSet;
            this.name = name;
        }
    }
}

