/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import fuego.directory.DirCatalogJar;
import fuego.directory.DirProjectRevision;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.Int;
import oracle.bpm.lang.Time;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.log.Log;
import oracle.bpm.util.CatalogFileInfo;
import oracle.bpm.util.CatalogLoaderMgr;
import oracle.bpm.util.CatalogMgr;
import oracle.bpm.util.ExceptionFormatter;
import oracle.bpm.util.FileUtils;
import oracle.bpm.util.JarWrapper;

public class LocalCatalogManager
implements CatalogMgr {
    private Map<String, Integer> jarsByJarIn;
    private List<Integer> loadedProjects;
    private String schemaId;
    private DirectorySession session;
    private String webApplicationFolder;
    private String webRootFolder;
    private Map<Integer, String> webRootFolderByIn;
    private String workingFolder;
    private static final String JAR_EXTENSION = ".jar";
    private static final long MAX_USAGE_INTERVAL = 432000000L;
    private static final String PROJECT_SYSTEM_DIR = "system";
    private static final String CATALOGS_FOLDER_NAME = "catalogs";
    private static final String WEBROOT_DIRECTORY = "webRoot";
    private static final String WEB_RESOURCES_DIRECTORY = "webResources";
    private static final String CUSTOM_JSP_DIRECTORY = "customJSP";

    protected LocalCatalogManager() {
    }

    protected LocalCatalogManager(String schemaId) {
        this.schemaId = schemaId;
    }

    private LocalCatalogManager(DirectorySession session, String catalogsBaseFolder, String webApplicationFolder) {
        this.session = session;
        this.schemaId = this.session.getSchemaId();
        String version = Id.getApplicationId();
        String folderName = "Schema" + version.hashCode() + String.valueOf(this.schemaId.hashCode());
        String _catalogsBaseFolder = catalogsBaseFolder;
        if (!catalogsBaseFolder.endsWith(File.separator)) {
            _catalogsBaseFolder = catalogsBaseFolder + File.separator;
        }
        this.workingFolder = _catalogsBaseFolder + PROJECT_SYSTEM_DIR + File.separator + folderName;
        if (webApplicationFolder != null) {
            this.webApplicationFolder = webApplicationFolder.endsWith(File.separator) ? webApplicationFolder.substring(0, webApplicationFolder.length() - 1) : webApplicationFolder;
            this.webRootFolder = this.webApplicationFolder + File.separator + WEBROOT_DIRECTORY + File.separator + folderName;
        }
        this.jarsByJarIn = new HashMap<String, Integer>();
        this.webRootFolderByIn = new HashMap<Integer, String>();
        this.loadedProjects = new ArrayList<Integer>();
        this.createLocalFolder();
        this.loadLocalCatalogs();
        this.register();
    }

    public static LocalCatalogManager create(DirectorySession session, String catalogsBaseFolder) {
        return new LocalCatalogManager(session, catalogsBaseFolder, null);
    }

    public static LocalCatalogManager create(DirectorySession session, String catalogsBaseFolder, String webApplicationFolder) {
        return new LocalCatalogManager(session, catalogsBaseFolder, webApplicationFolder);
    }

    public static boolean isCatalogJarFile(String filePath) {
        int catalogIndex;
        int systemIndex = filePath.indexOf(PROJECT_SYSTEM_DIR);
        return systemIndex > -1 && (catalogIndex = filePath.indexOf(CATALOGS_FOLDER_NAME)) > -1 && catalogIndex > systemIndex && filePath.endsWith(JAR_EXTENSION);
    }

    @Override
    public boolean supportsClassLoader() {
        return false;
    }

    @Override
    public ClassLoader getCatalogClassLoader(String schemaId, int catalogIN) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public CatalogFileInfo getCatalogURL(int catalogIn) throws IOException, DirectoryException {
        DirCatalogJar[] jars;
        int[] jarsIn;
        ArrayList<File> aditionalURLS = new ArrayList<File>();
        DirProjectRevision catalog = DirProjectRevision.fetch(this.session, catalogIn);
        if (catalog != null && (jarsIn = catalog.fetchJars()) != null && (jars = DirCatalogJar.fetchAllByIns(this.session, jarsIn)) != null) {
            for (DirCatalogJar jar : jars) {
                String fileName = jar.getFileName();
                if (!fileName.equals("catalog") && !fileName.startsWith("fuegojcl-")) continue;
                File catalogRequested = new File(this.buildFileName(String.valueOf(jar.getIn())));
                if (!catalogRequested.exists()) {
                    Log.logWarning(LibMsg.CATALOG_NOT_EXIST(catalogRequested.getAbsolutePath()));
                    this.storeCatalogJarLocally(catalogRequested.getAbsolutePath(), jar);
                }
                catalogRequested.setLastModified(Time.now().getMilliSeconds());
                aditionalURLS.add(catalogRequested);
            }
        }
        return new CatalogFileInfo(aditionalURLS.toArray(new File[aditionalURLS.size()]));
    }

    @Override
    public String getWebRootURL(int catalogIn) throws DirectoryException, IOException {
        if (this.webApplicationFolder != null) {
            if (!this.webRootFolderByIn.containsKey(catalogIn)) {
                this.addLocalCatalog(this.session, catalogIn);
            }
            return this.webRootFolderByIn.get(catalogIn);
        }
        throw new UnsupportedOperationException("You must set the Web Application Folder to use this feature.");
    }

    public String getWebResourcesURL(int catalogIn) throws DirectoryException, IOException {
        String result = null;
        String webRootCatalog = this.getWebRootURL(catalogIn);
        if (webRootCatalog != null) {
            result = webRootCatalog.concat("/").concat(WEB_RESOURCES_DIRECTORY);
        }
        return result;
    }

    public String getCustomJspURL(int catalogIn) throws DirectoryException, IOException {
        String result = null;
        String webRootCatalog = this.getWebRootURL(catalogIn);
        if (webRootCatalog != null) {
            result = webRootCatalog.concat("/").concat(CUSTOM_JSP_DIRECTORY);
        }
        return result;
    }

    public String getCatalogsFolder() {
        return this.getWorkingFolder().concat(File.separator).concat(CATALOGS_FOLDER_NAME);
    }

    public boolean isProjectLoaded(int projectRevisionIn) {
        return this.loadedProjects.contains(projectRevisionIn);
    }

    public String getWorkingFolder() {
        return this.workingFolder;
    }

    public String getWebRootFolder() {
        return this.webRootFolder;
    }

    public boolean accept(File folder, String name) {
        return name.indexOf(JAR_EXTENSION) != -1;
    }

    public DirCatalogJar[] addLocalCatalog(DirectorySession session, int projectRevisionIn) throws DirectoryException, IOException {
        if (projectRevisionIn == -1) {
            return new DirCatalogJar[0];
        }
        if (Log.isDebugging()) {
            Log.logDebug("Adding local catalog for project: " + projectRevisionIn);
        }
        DirProjectRevision publishedCatalog = DirProjectRevision.fetch(session, projectRevisionIn);
        int[] catalogAndProceduresIns = publishedCatalog.fetchJars();
        DirCatalogJar[] catalogAndProcedures = DirCatalogJar.fetchAllByIns(session, catalogAndProceduresIns);
        DirCatalogJar[] dirCatalogJars = this.storeJars(projectRevisionIn, catalogAndProcedures, false);
        this.loadedProjects.add(projectRevisionIn);
        return dirCatalogJars;
    }

    public boolean hasAssociatedProcesses(int catalogIn) {
        Integer ap = this.jarsByJarIn.get(String.valueOf(catalogIn));
        return ap != null && ap > 0;
    }

    public void register() {
        CatalogLoaderMgr.registerCatalogMgr(this.schemaId, this);
    }

    public DirCatalogJar[] storeJars(DirCatalogJar[] catalogAndProcedures, boolean updateCatalog) throws DirectoryException, IOException {
        return this.storeJars(-1, catalogAndProcedures, updateCatalog);
    }

    public void unregister() {
        CatalogLoaderMgr.unregisterCatalogMgr(this.schemaId);
    }

    public String getCatalogWebResourcesFolder(int catalogIn) throws DirectoryException, IOException {
        String result = this.webRootFolderByIn.get(catalogIn);
        if (result == null) {
            this.addLocalCatalog(this.session, catalogIn);
            result = this.webRootFolderByIn.get(catalogIn);
        }
        return result;
    }

    private DirCatalogJar[] storeJars(int projectRevisionIn, DirCatalogJar[] catalogAndProcedures, boolean updateCatalog) throws DirectoryException, IOException {
        boolean catalogNotNull;
        DirCatalogJar catalog = null;
        ArrayList<DirCatalogJar> procedures = new ArrayList<DirCatalogJar>();
        for (DirCatalogJar catalogOrProcedure : catalogAndProcedures) {
            String key = String.valueOf(catalogOrProcedure.getIn());
            if (catalogOrProcedure.getFileName().equals("catalog")) {
                catalog = catalogOrProcedure;
                continue;
            }
            if (catalogOrProcedure.getFileName().startsWith("fuegojcl-")) {
                if (!updateCatalog && this.jarsByJarIn.containsKey(key) || catalogOrProcedure.fetchJar() == null) continue;
                this.storeCatalogJarLocally(this.buildFileName(String.valueOf(catalogOrProcedure.getIn())), catalogOrProcedure);
                if (!Log.isDebugging()) continue;
                Log.logDebug("Jar '" + catalogOrProcedure.getFileName() + "' stored succesfully.");
                continue;
            }
            if (catalogOrProcedure.getFileName().equals("JSP.jar") || catalogOrProcedure.getFileName().equals("WEB_RESOURCES.jar")) {
                if (projectRevisionIn <= -1 || this.getWebRootFolder() == null || this.webRootFolderByIn.containsKey(catalogOrProcedure.getIn())) continue;
                this.storeCatalogWebResoureLocally(projectRevisionIn, catalogOrProcedure);
                continue;
            }
            procedures.add(catalogOrProcedure);
        }
        boolean bl = catalogNotNull = catalog != null && catalog.fetchJar() != null;
        if (catalogNotNull) {
            String key = String.valueOf(catalog.getIn());
            if (updateCatalog || !this.jarsByJarIn.containsKey(key)) {
                this.storeCatalogJarLocally(this.buildFileName(String.valueOf(catalog.getIn())), catalog);
                this.jarsByJarIn.put(key, 1);
            } else {
                this.jarsByJarIn.put(key, Int.inc(this.jarsByJarIn.get(key)));
            }
        }
        return procedures.toArray(new DirCatalogJar[procedures.size()]);
    }

    private String getCatalogIn(String jarFileName) {
        int index = jarFileName.indexOf(JAR_EXTENSION);
        if (index != -1) {
            return jarFileName.substring(0, index);
        }
        return jarFileName;
    }

    private String buildFileName(String jarIn) {
        String fileName = !jarIn.endsWith(JAR_EXTENSION) ? String.valueOf(jarIn).concat(JAR_EXTENSION) : jarIn;
        return this.getCatalogsFolder().concat(File.separator).concat(fileName);
    }

    private void createLocalFolder() {
        File dir = new File(this.getCatalogsFolder());
        if (!dir.exists()) {
            if (Log.isDebugging()) {
                Log.logDebug("Creating local folder: " + this.getCatalogsFolder());
            }
            dir.mkdirs();
        } else if (Log.isDebugging()) {
            Log.logDebug("Local folder " + this.getCatalogsFolder() + " found.");
        }
        if (this.webApplicationFolder != null) {
            File webResourcesFolder = new File(this.getWebRootFolder());
            if (!webResourcesFolder.exists()) {
                if (Log.isDebugging()) {
                    Log.logDebug("Creating local folder: " + this.getWebRootFolder());
                }
                webResourcesFolder.mkdirs();
            } else if (Log.isDebugging()) {
                Log.logDebug("Local folder " + this.getWebRootFolder() + " found.");
            }
        }
    }

    private void loadLocalCatalogs() {
        File[] catalogs;
        File catalogsFolder;
        if (Log.isDebugging()) {
            Log.logDebug("Loading catalogs from local folder: " + this.getCatalogsFolder());
        }
        if (!(catalogsFolder = new File(this.getCatalogsFolder())).exists()) {
            if (Log.isDebugging()) {
                Log.logDebug("No catalog's folder found locally. Creating it...");
            }
            catalogsFolder.mkdirs();
        }
        if ((catalogs = catalogsFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.endsWith(LocalCatalogManager.JAR_EXTENSION)) {
                    try {
                        Integer.parseInt(name.substring(0, name.lastIndexOf(LocalCatalogManager.JAR_EXTENSION)));
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                return false;
            }
        })) != null) {
            if (Log.isDebugging()) {
                Log.logDebug(catalogs.length + " jars found locally.");
            }
            for (File catalog : catalogs) {
                if (Time.now().getMilliSeconds() - catalog.lastModified() > 432000000L) {
                    this.removeCatalogJar(catalog.getPath());
                    continue;
                }
                catalog.setLastModified(System.currentTimeMillis());
                String jarIn = this.getCatalogIn(catalog.getName());
                if (Log.isDebugging()) {
                    Log.logDebug("Local jar '" + jarIn + "' succesfully loaded.");
                }
                this.jarsByJarIn.put(jarIn, 0);
            }
        }
    }

    private void removeCatalogJar(String fullFileName) {
        File catalogJar = new File(fullFileName);
        catalogJar.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeCatalogJarLocally(String fullFileName, DirCatalogJar catalogJar) throws DirectoryException, IOException {
        block12: {
            try {
                FileOutputStream output = new FileOutputStream(new File(fullFileName));
                if (output == null) break block12;
                try {
                    byte[] jarData = catalogJar.fetchJar();
                    if (jarData != null) {
                        output.write(jarData);
                        output.flush();
                    } else {
                        Log.logSevere(LibMsg.COULD_NOT_STORE_CATALOG(catalogJar.getFileName(), fullFileName));
                    }
                }
                finally {
                    try {
                        output.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            catch (DirectoryException e) {
                Log.logSevere(LibMsg.COULD_NOT_STORE_CATALOG_REASON(catalogJar.getFileName(), fullFileName, ExceptionFormatter.fullTechLevel(e)));
                throw e;
            }
            catch (IOException e) {
                Log.logSevere(LibMsg.COULD_NOT_STORE_CATALOG_REASON(catalogJar.getFileName(), fullFileName, ExceptionFormatter.fullTechLevel(e)));
                throw e;
            }
        }
    }

    private String getRelativeWebFolder(String folder) {
        int size = this.webApplicationFolder.length();
        return folder.substring(size).replace(File.separatorChar, '/');
    }

    private void storeCatalogWebResoureLocally(int projectRevisionIn, DirCatalogJar catalogJar) throws DirectoryException, IOException {
        String tmpJarFileName;
        File tmpJarFile;
        String catalogFolderName = this.getWebRootFolder().concat(File.separator).concat(String.valueOf(projectRevisionIn));
        File catalogFolder = new File(catalogFolderName);
        if (!catalogFolder.exists()) {
            catalogFolder.mkdirs();
        }
        if (!(tmpJarFile = new File(catalogFolder, tmpJarFileName = catalogJar.getFileName().concat(String.valueOf(catalogJar.getIn())))).exists()) {
            tmpJarFile.createNewFile();
        }
        FileUtils.writeBytes(tmpJarFile, catalogJar.fetchJar());
        JarWrapper jr = JarWrapper.openJar(tmpJarFile.getCanonicalPath(), 1);
        jr.openJarInDirectory(catalogFolder);
        this.webRootFolderByIn.put(projectRevisionIn, this.getRelativeWebFolder(catalogFolderName));
    }
}

