/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import oracle.bpm.log.Log;

public class LifecycleLock {
    private boolean running = false;
    private volatile boolean shutdownInProgress = false;
    private int working = 0;

    public boolean isShuttingDown() {
        return this.shutdownInProgress;
    }

    public synchronized void beginShutdown() {
        if (!this.running) {
            throw new IllegalStateException("Not running");
        }
        if (this.shutdownInProgress) {
            throw new IllegalStateException("A shutdown sequence is in progress");
        }
        this.shutdownInProgress = true;
        while (this.working != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                if (!Log.isDebugging()) continue;
                Log.logDebug(ex);
            }
        }
    }

    public synchronized void beginStartup() {
        if (this.shutdownInProgress) {
            throw new IllegalStateException("A shutdown sequence is in progress");
        }
        if (this.running) {
            throw new IllegalStateException("Already running");
        }
        this.running = true;
        this.beginWork();
    }

    public synchronized void beginWork() throws IllegalStateException {
        if (!this.running) {
            throw new IllegalStateException("Not running");
        }
        if (this.shutdownInProgress) {
            throw new IllegalStateException("A shutdown sequence is in progress");
        }
        ++this.working;
    }

    public synchronized void endShutdown() {
        this.running = false;
        this.shutdownInProgress = false;
    }

    public synchronized void endStartup() {
        this.endWork();
    }

    public synchronized void endWork() {
        --this.working;
        this.notify();
    }
}

