/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.util.List;
import oracle.bpm.util.LegacyGroupArray;
import oracle.bpm.util.MemberArray;

public class LegacyMemberArray
extends MemberArray {
    private LegacyGroupArray legacyArray;

    public LegacyMemberArray(List target, String getter, String setter, Class javaMemberType) {
        super(target, getter, setter, javaMemberType);
        this.legacyArray = (LegacyGroupArray)target;
    }

    @Override
    public boolean add(Object value) {
        return this.legacyArray.add(this.getter, this.setter, value);
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException("LegacyMemberArray.add(int, Object) not implemented");
    }

    @Override
    public Object get(int index) {
        return this.legacyArray.get(index, this.getter, this.setter);
    }

    @Override
    public Object remove(int index) {
        Object old = this.get(index);
        int length = this.size();
        for (int i = index; i < length - 1; ++i) {
            this.set(i, this.get(i + 1));
        }
        this.legacyArray.removeLastElement(this.setter);
        return old;
    }

    @Override
    public boolean remove(Object element) {
        int index = this.indexOf(element);
        if (index != -1) {
            this.remove(index);
        }
        return index != -1;
    }

    @Override
    public int size() {
        return this.legacyArray.getLengthForAttribute(this.setter);
    }
}

