/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.component.Replaceable;
import oracle.bpm.lang.Invocator;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.xobject.GroupArray;

public class LegacyGroupArray
extends GroupArray
implements Replaceable {
    private long __replacementId;
    private int addedToAllAttributes = 0;
    private Map<String, IntHolder> attribute2Length = new HashMap<String, IntHolder>();
    static final long serialVersionUID = -7359847927241202422L;
    static final long serialCheck = -1911362594063519036L;

    public LegacyGroupArray(Invocator groupInvocator, String constructorSignature, Object[] args) {
        super(groupInvocator, constructorSignature, args);
    }

    public int getLengthForAttribute(String setter) {
        IntHolder holder = this.attribute2Length.get(setter);
        return (holder == null ? 0 : holder.value) + this.addedToAllAttributes;
    }

    public int getMaxLength() {
        int maxLength = 0;
        for (IntHolder holder : this.attribute2Length.values()) {
            maxLength = maxLength > holder.value ? maxLength : holder.value;
        }
        return maxLength + this.addedToAllAttributes;
    }

    @Override
    public boolean add(Object element) {
        ++this.addedToAllAttributes;
        return super.add(element);
    }

    public boolean add(String getter, String setter, Object element) {
        Object xo;
        int lengthForAttribute;
        IntHolder holder = this.attribute2Length.get(setter);
        if (holder == null) {
            holder = new IntHolder();
            this.attribute2Length.put(setter, holder);
        }
        if ((lengthForAttribute = holder.value + this.addedToAllAttributes) < this.size()) {
            xo = this.get(holder.value);
        } else {
            try {
                xo = this.createNewElement();
                super.add(xo);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.setValue(xo, setter, element);
        ++holder.value;
        return true;
    }

    @Override
    public void clear() {
        super.clear();
        this.attribute2Length.clear();
        this.addedToAllAttributes = 0;
    }

    public Object get(int index, String getter, String setter) {
        int length = this.getLengthForAttribute(setter);
        this.checkIndex(index, length);
        Object xo = this.get(index);
        try {
            if (xo instanceof Invokeable) {
                return ((Invokeable)xo).invoke(getter, new Object[0]);
            }
            return this.groupInvocator.invoke(xo, getter, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean remove(Object element) {
        boolean removed = super.remove(element);
        if (removed) {
            --this.addedToAllAttributes;
        }
        return removed;
    }

    @Override
    public Object remove(int index) {
        Object old = super.remove(index);
        --this.addedToAllAttributes;
        return old;
    }

    public void removeLastElement(String setter) {
        IntHolder holder = this.attribute2Length.get(setter);
        --holder.value;
        int maxLength = this.getMaxLength();
        if (maxLength < this.size()) {
            super.remove(this.size() - 1);
        }
    }

    private void setValue(Object xo, String setter, Object element) {
        Object[] args = new Object[]{element};
        try {
            if (xo instanceof Invokeable) {
                ((Invokeable)xo).invoke(setter, args);
            } else {
                this.groupInvocator.invoke(xo, setter, args);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkIndex(int index, int length) {
        if (index >= length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
    }

    private static class IntHolder
    implements Serializable {
        public int value;
        static final long serialCheck = 3620194129005642104L;
        static final long serialVersionUID = 3513699554877909521L;

        private IntHolder() {
        }
    }
}

