/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.Serializable;
import oracle.bpm.lang.Holder;
import oracle.bpm.lang.TimeoutException;
import oracle.bpm.util.LatchIsFullException;

public final class Latch
implements Holder,
Serializable {
    private boolean allowReuse_d;
    private volatile Object object_d;
    private long timeout_d;
    static final long serialVersionUID = -1522970980641800494L;
    static final long serialCheck = 2283232254187560381L;

    public Latch() {
        this.allowReuse_d = false;
        this.timeout_d = 0L;
    }

    public Latch(boolean allowReuse) {
        this.allowReuse_d = allowReuse;
        this.timeout_d = 0L;
    }

    public Latch(long timeout, boolean allowReuse) {
        this.allowReuse_d = allowReuse;
        this.timeout_d = timeout;
    }

    public static void main(String[] args) {
        Latch l = new Latch(5000L, true);
        System.out.println("Waiting with timeout");
        l.get();
        System.out.println("After timeout");
    }

    public boolean isEmpty() {
        return this.object_d == null;
    }

    public synchronized Object get() {
        if (this.object_d == null) {
            while (this.object_d == null) {
                try {
                    this.wait(this.timeout_d);
                    if (this.object_d != null) continue;
                    throw new TimeoutException();
                }
                catch (InterruptedException e) {
                    throw new TimeoutException();
                }
            }
        }
        Object result = this.object_d;
        if (this.allowReuse_d) {
            this.object_d = null;
        }
        return result;
    }

    public Object peek() {
        return this.object_d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null is not allowed to latch");
        }
        Latch latch = this;
        synchronized (latch) {
            if (this.object_d != null) {
                throw new LatchIsFullException();
            }
            this.object_d = object;
            this.notifyAll();
        }
    }
}

