/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import oracle.bpm.lang.Str;
import oracle.bpm.log.Log;
import oracle.bpm.util.ComputeHashException;
import oracle.bpm.util.FileUtils;

public class JarWrapper {
    private List<String> addExt_d = null;
    private boolean computeHash_d = false;
    private String fileName_d = null;
    private Map<String, FileDefinition> files_d = null;
    private boolean flushed = false;
    private List<String> incExt_d = null;
    private long jarHashValue_d = -1L;
    private JarOutputStream jos_d = null;
    private MessageDigest md_d = null;
    private DataOutputStream mdData_d = null;
    private int mode_d = 0;
    public static final int CREATE = 0;
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    public static final char separatorChar = '/';
    public static final String separator = "/";

    private JarWrapper(String fileName, int mode) {
        this.mode_d = mode;
        this.fileName_d = fileName;
        this.files_d = new HashMap<String, FileDefinition>();
    }

    public static JarWrapper createJar(String fileName) {
        return new JarWrapper(fileName, 2);
    }

    public static JarWrapper openJar(String fileName, int mode) throws IOException {
        JarWrapper result;
        switch (mode) {
            case 1: 
            case 2: {
                result = new JarWrapper(fileName, mode);
                break;
            }
            case 3: {
                result = new JarWrapper(fileName, 3);
                break;
            }
            default: {
                result = null;
                assert (false);
                break;
            }
        }
        result.load();
        return result;
    }

    public byte[] getFile(String completeName) {
        return this.files_d.get(completeName).getFileData();
    }

    public String[] getFileNames() {
        return this.files_d.keySet().toArray(new String[this.files_d.keySet().size()]);
    }

    public FileDefinition getFileNames(String completeName) {
        return this.files_d.get(completeName);
    }

    public FileDefinition[] getFiles() {
        return this.files_d.values().toArray(new FileDefinition[this.files_d.values().size()]);
    }

    public long getJarHashValue() {
        if (!this.computeHash_d) {
            throw new IllegalStateException("This wasn't set to compute hash value");
        }
        if (!this.flushed) {
            throw new IllegalStateException("You have to flush the jar first.");
        }
        return this.jarHashValue_d;
    }

    public boolean addDirectoryTree(File rootDir, FilenameFilter filter, boolean addRoot) throws IOException {
        return this.addDirectoryTree(rootDir, filter, addRoot ? rootDir.getName().concat(separator) : "");
    }

    public boolean addFile(String completeName, byte[] data) {
        if (this.mode_d == 1) {
            return false;
        }
        if (this.files_d.containsKey(completeName)) {
            return this.replaceFile(completeName, data);
        }
        this.files_d.put(completeName, new FileDefinition(completeName, data));
        return true;
    }

    public boolean addFile(FileDefinition deff) {
        return this.addFile(deff.getDirectoryPath() + deff.getFileName(), deff.getFileData());
    }

    public boolean addFile(File file) throws IOException {
        return this.addFile(new FileDefinition("", file));
    }

    public void close() throws IOException {
        if (!this.flushed) {
            this.flush();
        }
        this.clean();
    }

    public void computeHash(List<String> addFileWithExt, List<String> incHashWithExt) throws ComputeHashException {
        try {
            this.computeHash_d = true;
            this.addExt_d = addFileWithExt;
            this.incExt_d = incHashWithExt;
            this.md_d = MessageDigest.getInstance("SHA");
            ByteArrayOutputStream os = new ByteArrayOutputStream(512);
            DigestOutputStream dos = new DigestOutputStream(os, this.md_d);
            this.mdData_d = new DataOutputStream(dos);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new ComputeHashException("SHA", nsae);
        }
    }

    public void flush() throws IOException {
        this.flush(new FileOutputStream(this.fileName_d));
    }

    public void flush(OutputStream os) throws IOException {
        if (this.mode_d == 1 || this.flushed) {
            this.flushed = true;
            return;
        }
        this.jos_d = new JarOutputStream(os);
        HashSet<String> names = new HashSet<String>();
        FileDefinition[] files = this.getFiles();
        if (files != null) {
            for (FileDefinition file : files) {
                String[] directories = file.getDirectories();
                String name = file.getFileName();
                byte[] data = file.getFileData();
                String dirPath = "";
                if (directories != null) {
                    for (String directory : directories) {
                        if (names.contains(dirPath = dirPath + directory + separator)) continue;
                        this.jos_d.putNextEntry(new JarEntry(dirPath));
                        this.jos_d.closeEntry();
                        names.add(dirPath);
                    }
                }
                if (names.contains(dirPath + name)) continue;
                JarEntry fileEntry = new JarEntry(dirPath + name);
                fileEntry.setSize(data.length);
                this.jos_d.putNextEntry(fileEntry);
                this.jos_d.write(data, 0, data.length);
                this.jos_d.closeEntry();
                names.add(dirPath + name);
                if (!this.computeHash_d) continue;
                this.calculateHash(name, data);
            }
        }
        this.flushed = true;
    }

    public void openJarInDirectory(File resourceFolder) throws IOException {
        FileDefinition[] files = this.getFiles();
        if (files != null) {
            for (FileDefinition file : files) {
                String[] dirs = file.getDirectories();
                String path = "";
                File fullPathDir = new File(resourceFolder.getCanonicalPath());
                for (String dir : dirs) {
                    Log.logTrace("Directory: " + dir);
                    path = path.concat(File.separator).concat(dir);
                }
                Log.logTrace("path: " + path);
                if (!path.equals("")) {
                    fullPathDir = new File(resourceFolder.getCanonicalPath() + path);
                    Log.logTrace("Creating Full Path: " + fullPathDir);
                    fullPathDir.mkdirs();
                }
                Log.logTrace("fullPathDir: " + fullPathDir);
                File resource = new File(fullPathDir, file.getFileName());
                FileUtils.writeBytes(resource, file.getFileData());
            }
        }
    }

    public boolean replaceFile(String completeName, byte[] data) {
        if (this.mode_d != 1 && this.files_d.containsKey(completeName)) {
            this.files_d.remove(completeName);
            this.addFile(completeName, data);
            return true;
        }
        return false;
    }

    private boolean addDirectoryTree(File rootDir, FilenameFilter filter, String path) throws IOException {
        if (this.mode_d == 1) {
            return false;
        }
        boolean result = true;
        File[] listFiles = rootDir.listFiles();
        if (listFiles != null) {
            for (File listFile : listFiles) {
                if (listFile.isDirectory()) {
                    result = result && this.addDirectoryTree(listFile, filter, path.concat(listFile.getName().concat(separator)));
                    continue;
                }
                if (filter != null && !filter.accept(rootDir, listFile.getName())) continue;
                result = result && this.addFile(new FileDefinition(path, listFile));
            }
        }
        return result;
    }

    private void calculateHash(String name, byte[] data) throws IOException {
        String ext;
        int indexOfdot = name.lastIndexOf(46);
        String string = ext = indexOfdot == -1 ? null : name.substring(indexOfdot, name.length());
        if (this.addExt_d.contains(ext)) {
            this.mdData_d.write(data);
        } else if (this.incExt_d.contains(ext)) {
            this.mdData_d.write(1);
        }
        byte[] hasharray = this.md_d.digest();
        if (hasharray != null) {
            for (int i = 0; i < Math.min(8, hasharray.length); ++i) {
                this.jarHashValue_d += (long)(hasharray[i] & 0xFF) << i * 8;
            }
        }
    }

    private void clean() throws IOException {
        if (this.jos_d != null) {
            this.jos_d.flush();
            this.jos_d.close();
            this.jos_d = null;
        }
    }

    private void load() throws IOException {
        JarFile file = new JarFile(new File(this.fileName_d));
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            JarEntry currentEntry = entries.nextElement();
            if (currentEntry.isDirectory()) continue;
            String completeName = currentEntry.getName();
            int size = (int)currentEntry.getSize();
            byte[] classData = new byte[size];
            int read = new BufferedInputStream(file.getInputStream(currentEntry)).read(classData, 0, size);
            assert (size == read);
            this.files_d.put(completeName, new FileDefinition(completeName, classData));
        }
        file.close();
    }

    public static class FileDefinition {
        private String[] directories_d;
        private byte[] fileData_d;
        private String fileName_d;

        public FileDefinition(String completeFileName, byte[] fileData) {
            int p0 = completeFileName.lastIndexOf(JarWrapper.separator);
            int p1 = completeFileName.length();
            String path = "";
            if (p0 > 0) {
                path = completeFileName.substring(0, p0);
            }
            this.directories_d = Str.split(path, '/', false);
            this.fileName_d = completeFileName.substring(p0 + 1, p1);
            this.fileData_d = fileData;
        }

        public FileDefinition(String targetPath, File file) throws IOException {
            this.directories_d = null;
            this.fileName_d = null;
            this.fileData_d = null;
            FileInputStream fis = null;
            try {
                this.fileName_d = file.getName();
                fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis);
                byte[] ba = new byte[(int)file.length()];
                int r = bis.read(ba);
                assert (file.length() == (long)r);
                this.fileData_d = ba;
                this.directories_d = Str.split(targetPath, '/', false);
            }
            catch (IOException ioe) {
                Log.logWarning(ioe);
                throw ioe;
            }
            finally {
                block12: {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException ioe) {
                        if (!Log.isDebugging()) break block12;
                        Log.logDebug(ioe);
                    }
                }
            }
        }

        public FileDefinition(String[] directories, String fileName, byte[] fileData) {
            this.directories_d = directories;
            this.fileName_d = fileName;
            this.fileData_d = fileData;
        }

        public String[] getDirectories() {
            return this.directories_d;
        }

        public String getDirectoryPath() {
            if (this.directories_d == null || this.directories_d.length == 0) {
                return "";
            }
            return Str.join(this.directories_d, '/');
        }

        public byte[] getFileData() {
            return this.fileData_d;
        }

        public String getFileName() {
            return this.fileName_d;
        }

        public String toString() {
            return this.getDirectoryPath() + "." + this.getFileName() + "(" + Arrays.toString(this.getFileData()) + ")";
        }
    }
}

