/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    public static String generateMd5(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(source.getBytes());
            return HashUtils.getString(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String generateSha(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] bytes = md.digest(source.getBytes());
            return HashUtils.getString(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashBuilder buildMd5Builder() {
        try {
            return new HashBuilder("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static HashBuilder buildShaBuilder() {
        try {
            return new HashBuilder("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte aByte : bytes) {
            sb.append(Integer.toHexString(0xFF & aByte));
        }
        return sb.toString();
    }

    public static class HashBuilder {
        MessageDigest digest;

        public HashBuilder(String algorithm) throws NoSuchAlgorithmException {
            this.digest = MessageDigest.getInstance(algorithm);
        }

        public void update(String source) {
            this.digest.update(source.getBytes());
        }

        public void reset() {
            this.digest.reset();
        }

        public String digest() {
            byte[] bytes = this.digest.digest();
            return HashUtils.getString(bytes);
        }
    }
}

