/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import oracle.bpm.lang.Literals;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.util.ArrayToStringException;
import oracle.bpm.util.ByteArray;
import oracle.bpm.util.StringTokenizer;

public abstract class HTMLFormFilter {
    private String action_d;
    private String actionId_d;
    private URLConnection connection_d;
    private List<String> cookies_d;
    private Map<String, String> hiddenVars_d;
    private String homeAction_d;
    private InputStream in_d;
    private ArrayList<String> interceptedVars_d;
    private String links_d;
    private Locale locale_d;
    private String method_d;
    private int nextStrPos_d;
    private String originalAction_d;
    private String originalMethod_d;
    private OutputStream out_d;
    private ArrayList<String> readOnlyVars_d;
    private ArrayList<String> requiredVars_d;
    private String stopAction_d;
    private boolean strFound_d;
    private String strToFind_d;
    private String target_d;
    private String title_d;
    private int unread_d = -2;
    private boolean userControl_d;
    private Map vars_d;
    private static final int EOF = -1;
    private static final int EMPTY = -2;
    private static final String TRUE_STRING = Boolean.TRUE.toString();
    private static final String READONLY_STRING = "readonly";
    private static String FORMNAME_STRING = "InterceptedForm";

    public HTMLFormFilter(String url) throws IOException {
        this(new URL(url).openConnection());
    }

    public HTMLFormFilter(URLConnection connection) throws IOException {
        String str;
        this.connection_d = connection;
        String encoding = connection.getContentEncoding();
        this.in_d = this.connection_d.getInputStream();
        if (encoding != null && "gzip".equals(encoding)) {
            this.in_d = new GZIPInputStream(this.in_d);
        }
        this.cookies_d = new ArrayList<String>();
        this.interceptedVars_d = new ArrayList();
        this.strFound_d = false;
        int i = 0;
        while ((str = this.connection_d.getHeaderField(i)) != null) {
            if (this.connection_d.getHeaderFieldKey(i) != null && "Set-Cookie".equals(this.connection_d.getHeaderFieldKey(i))) {
                this.cookies_d.add(str);
            }
            ++i;
        }
    }

    public void setAction(String action) {
        this.action_d = action;
    }

    public void setActionId(String actionId) {
        this.actionId_d = actionId;
    }

    public String getActionId() {
        return this.actionId_d != null ? this.actionId_d : "";
    }

    public void setClearLinks(boolean flag) {
    }

    public List<String> getCookies() {
        return this.cookies_d;
    }

    public void setFormName(String name) {
        FORMNAME_STRING = name;
    }

    public String getFormName() {
        return FORMNAME_STRING;
    }

    public final void setHomeAction(String home) {
        this.homeAction_d = home;
    }

    public final String getHomeAction() {
        return this.homeAction_d;
    }

    public ArrayList<String> getInterceptedVariables() {
        return this.interceptedVars_d;
    }

    public void setLinks(String values) {
        this.links_d = values;
    }

    public void setLocale(Locale localeInSession) {
        this.locale_d = localeInSession;
    }

    public Locale getLocale() {
        return this.locale_d;
    }

    public void setMethod(String method) {
        this.method_d = method;
    }

    public String getOriginalAction() {
        return this.originalAction_d;
    }

    public String getOriginalMethod() {
        return this.originalMethod_d;
    }

    public void setOutputStream(OutputStream out) {
        this.out_d = out;
    }

    public void setReadOnlyVariables(ArrayList<String> vars) {
        this.readOnlyVars_d = vars;
    }

    public void setRequiredVars(ArrayList<String> vars) {
        this.requiredVars_d = vars;
    }

    public ArrayList<String> getRequiredVars() {
        return this.requiredVars_d;
    }

    public final void setStopAction(String stop) {
        this.stopAction_d = stop;
    }

    public final String getStopAction() {
        return this.stopAction_d;
    }

    public void setStringToFind(String str) {
        this.strToFind_d = str;
    }

    public void setTarget(String tgt) {
        this.target_d = tgt;
    }

    public String getTarget() {
        return this.target_d;
    }

    public void setTitle(String title) {
        this.title_d = title;
    }

    public String getTitle() {
        return this.title_d != null ? this.title_d : "";
    }

    public void setUserControl(boolean flag) {
        this.userControl_d = flag;
    }

    public void setVariables(Map vars) {
        this.vars_d = vars;
    }

    public void addHiddenVariable(String name, String value) {
        if (this.hiddenVars_d == null) {
            this.hiddenVars_d = new HashMap<String, String>();
        }
        this.hiddenVars_d.put(name, value);
    }

    public void doFilter() throws IOException {
        ByteArray word;
        String string = this.links_d = this.links_d != null ? this.links_d : "";
        while ((word = this.getTag()) != null) {
            this.write(word);
            if (word.equalsString("html") && (this.userControl_d || "intercept".equals(this.links_d))) {
                this.doControlTable();
                continue;
            }
            if (word.equalsString("form")) {
                this.doForm();
                if (this.getRequiredVars() != null) {
                    this.writeJavaScriptCode(this.getFormName());
                }
                if (this.hiddenVars_d == null) continue;
                this.writeHiddenVariables();
                continue;
            }
            if (word.equalsString("input")) {
                this.doInput();
                continue;
            }
            if (word.equalsString("select")) {
                this.doSelect();
                continue;
            }
            if (word.equalsString("textarea")) {
                this.doTextArea();
                continue;
            }
            if (word.equalsString("a")) {
                this.doAnchor();
                continue;
            }
            if (word.equalsString("link")) {
                this.doLink();
                continue;
            }
            if (word.equalsString("img")) {
                this.doImages();
                continue;
            }
            if (!word.equalsString("body")) continue;
            this.doBody();
        }
        if (this.out_d != null) {
            this.out_d.close();
        }
    }

    public boolean stringFound() {
        return this.strFound_d;
    }

    protected abstract String getImageUrl(String var1);

    private Map<String, String> getAttributes() throws IOException {
        ByteArray name;
        HashMap<String, String> attrs = new HashMap<String, String>();
        while ((name = this.getWord()) != null) {
            ByteArray value = null;
            int c = this.skipWhitespace();
            if (c != 61) {
                this.unread(c);
            } else {
                c = this.skipWhitespace();
                if (c == 34 || c == 39) {
                    int qc = this.read();
                    while (qc != -1 && qc != c) {
                        value = ByteArray.append(value, (byte)qc);
                        qc = this.read();
                    }
                } else {
                    while (c != -1 && (Character.isJavaIdentifierPart((char)c) || c == 46 || c == 47 || c == 58)) {
                        value = ByteArray.append(value, (byte)c);
                        c = this.read();
                    }
                    this.unread(c);
                }
            }
            attrs.put(name.getString(), value == null ? null : value.getString());
        }
        return attrs;
    }

    private ByteArray getTag() throws IOException {
        int c;
        while ((c = this.read()) != -1) {
            this.write(c);
            if (c != 60) continue;
            ByteArray result = null;
            c = this.read();
            if (c != 47) {
                this.unread(c);
            } else {
                result = ByteArray.append(result, (byte)c);
            }
            if ((result = this.getWord(result)) == null) continue;
            return result;
        }
        return null;
    }

    private ByteArray getWord() throws IOException {
        return this.getWord(null);
    }

    private ByteArray getWord(ByteArray result) throws IOException {
        int c = this.skipWhitespace();
        while (c != -1 && !Character.isSpaceChar((char)c) && c != 61 && c != 60 && c != 62 && c != 47) {
            result = ByteArray.append(result, (byte)Character.toLowerCase((char)c));
            c = this.read();
        }
        this.unread(c);
        return result;
    }

    private void doAnchor() throws IOException {
        Map<String, String> attributes = this.getAttributes();
        String href = attributes.get("href");
        if (href != null && !href.startsWith("#")) {
            if ("clear".equals(this.links_d)) {
                attributes.remove("href");
            } else {
                try {
                    href = new URL(this.connection_d.getURL(), href).toExternalForm();
                    if ("intercept".equals(this.links_d)) {
                        href = this.interceptURL(href);
                        attributes.put("href", href);
                        attributes.put("target", "_self");
                    } else {
                        attributes.put("href", href);
                        attributes.put("target", "invalid");
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        this.writeAttributes(attributes);
    }

    private void doBody() throws IOException {
        Map<String, String> attributes = this.getAttributes();
        StringBuilder onLoad = new StringBuilder();
        if (this.getTarget() != null) {
            onLoad.append("location.href='#").append(this.getTarget()).append("';");
            if (attributes.get("onload") != null) {
                onLoad.append(attributes.get("onload"));
            }
            attributes.put("onLoad", onLoad.toString());
        }
        this.writeAttributes(attributes);
    }

    private void doControlTable() throws IOException {
        this.write(">\n");
        this.write(" <link rel=\"stylesheet\" type=\"text/css\" href=\"../css/etweb.css\">");
        this.write("<script language='javascript'>\n");
        this.write("function previousPage(){\n");
        this.write("history.go(-1);\n");
        this.write("}\n");
        this.write("function stopPage(){\n");
        this.write("location.href = '" + this.getStopAction() + "';\n");
        this.write("}\n");
        this.write("function homePage(){\n");
        this.write("location.href = '" + this.getHomeAction() + "';\n");
        this.write("}\n");
        this.write("</script>\n");
        this.write("<table border=0 width=\"100%\" height=\"30\" cellspacing=0>\n");
        this.write("<tr class=\"header\">\n");
        this.write("<td class=\"header\" width=\"5%\" align=\"center\">\n");
        this.write("<a href=\"javascript:previousPage()\"><img border=0 src=\"" + this.getImageUrl("INTERCEPTOR_TOOLBAR_BACK") + "\" alt=\"" + CoreMsg.PREVIOUS_INTERCEPTOR.getString(this.getLocale()) + "\"></a>\n");
        this.write("</td>\n");
        this.write("<td class=\"header\" width=\"5%\" align=\"center\">\n");
        this.write("<a href=\"javascript:stopPage()\"><img border=0 src=\"" + this.getImageUrl("INTERCEPTOR_TOOLBAR_STOP") + "\" alt=\"" + CoreMsg.STOP_INTERCEPTOR.getString(this.getLocale()) + "\"></a>\n");
        this.write("</td>\n");
        this.write("<td class=\"header\" width=\"5%\" align=\"center\">\n");
        this.write("<a href=\"javascript:homePage()\"><img border=0 src=\"" + this.getImageUrl("INTERCEPTOR_TOOLBAR_HOME") + "\" alt=\"" + CoreMsg.HOME_INTERCEPTOR.getString(this.getLocale()) + "\"></a>\n");
        this.write("</td>\n");
        this.write("<td class=\"header\" width=\"*\" align=\"right\">\n");
        this.write("<span class=\"apptitle\">" + this.getTitle() + "&nbsp;&nbsp;</span>\n");
        this.write("</td>\n");
        this.write("</tr>\n");
        this.write("</table");
    }

    private void doForm() throws IOException {
        Map<String, String> attributes = this.getAttributes();
        StringBuilder onSubmit = new StringBuilder("return checkRequiredFields();");
        this.originalAction_d = "";
        if (attributes.get("action") != null) {
            try {
                this.originalAction_d = new URL(this.connection_d.getURL(), attributes.get("action")).toExternalForm();
            }
            catch (MalformedURLException e) {
                this.originalAction_d = attributes.get("action");
            }
        }
        this.addHiddenVariable("originalAction", this.originalAction_d);
        attributes.put("action", this.action_d);
        this.originalMethod_d = attributes.get("method");
        this.addHiddenVariable("method", this.originalMethod_d);
        if (this.method_d != null) {
            attributes.put("method", this.method_d);
        }
        if (attributes.get("name") != null) {
            this.setFormName(attributes.get("name"));
        } else {
            attributes.put("name", this.getFormName());
        }
        if (this.getRequiredVars() != null) {
            if (attributes.get("onsubmit") != null) {
                onSubmit.append(attributes.get("onsubmit"));
            }
            attributes.put("onSubmit", onSubmit.toString());
        }
        this.writeAttributes(attributes);
    }

    private void doImages() throws IOException {
        Map<String, String> attributes = this.getAttributes();
        String src = attributes.get("src");
        if (src != null) {
            attributes.put("src", new URL(this.connection_d.getURL(), src).toExternalForm());
        }
        this.writeAttributes(attributes);
    }

    private void doInput() throws IOException, ArrayToStringException {
        String value;
        Map<String, String> attributes = this.getAttributes();
        String name = attributes.get("name");
        try {
            value = name == null ? null : (String)this.vars_d.get(name);
        }
        catch (ClassCastException e) {
            throw new ArrayToStringException(CoreMsg.ARRAY_TO_STRING_EXCEPTION_MSG.getString(Locale.ENGLISH));
        }
        if (value != null) {
            this.variableIntercepted(name);
            String type = attributes.get("type");
            if ("checkbox".equals(type) || "radio".equals(type)) {
                if (value.equals(attributes.get("value"))) {
                    attributes.put("checked", TRUE_STRING);
                } else {
                    attributes.remove("checked");
                }
            } else {
                attributes.put("value", value);
            }
        }
        if (this.readOnlyVars_d != null && this.readOnlyVars_d.contains(name)) {
            attributes.put(READONLY_STRING, READONLY_STRING);
        }
        this.writeAttributes(attributes);
    }

    private void doLink() throws IOException {
        String href;
        Map<String, String> attributes = this.getAttributes();
        String rel = attributes.get("rel");
        if (rel != null && "stylesheet".equalsIgnoreCase(rel) && (href = attributes.get("href")) != null && !href.startsWith("#")) {
            try {
                attributes.put("href", new URL(this.connection_d.getURL(), href).toExternalForm());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        this.writeAttributes(attributes);
    }

    private void doSelect() throws IOException {
        ByteArray word;
        Map<String, String> attributes = this.getAttributes();
        this.writeAttributes(attributes);
        String name = attributes.get("name");
        Object[] val = null;
        if (this.vars_d.get(name) instanceof Object[]) {
            val = name == null ? null : (Object[])this.vars_d.get(name);
        } else if (this.vars_d.get(name) != null) {
            String[] def = new String[]{this.vars_d.get(name).toString()};
            val = new Object[]{def, null};
        }
        if (val == null) {
            return;
        }
        this.variableIntercepted(name);
        String[] defValues = (String[])val[0];
        if (defValues == null) {
            defValues = new String[]{};
        }
        String[] optValues = (String[])val[1];
        while ((word = this.getTag()) != null && !word.equalsString("/select")) {
            this.write(word);
            if (!word.equalsString("option")) continue;
            attributes = this.getAttributes();
            String attrValue = attributes.get("value");
            if (attrValue != null) {
                int i;
                if (optValues != null && optValues.length > 0) {
                    for (i = 0; i < optValues.length && !optValues[i].equals(attrValue); ++i) {
                    }
                    if (i != optValues.length) {
                        optValues[i] = "@@@@@";
                    }
                }
                for (i = 0; i < defValues.length && !defValues[i].equals(attrValue); ++i) {
                }
                if (i != defValues.length) {
                    attributes.put("selected", TRUE_STRING);
                } else {
                    attributes.remove("selected");
                }
            }
            this.writeAttributes(attributes);
        }
        if (optValues != null && optValues.length > 0) {
            this.writeSelectOptions(optValues, defValues);
        }
        this.write(word);
    }

    private void doTextArea() throws IOException {
        String[] stringArray;
        Object val;
        Map<String, String> attributes = this.getAttributes();
        this.writeAttributes(attributes);
        String name = attributes.get("name");
        Object v0 = val = name == null ? null : this.vars_d.get(name);
        if (val == null) {
            return;
        }
        this.variableIntercepted(name);
        boolean closed = false;
        int c = this.read();
        while (c != -1 && c != 62) {
            if (c == 92) {
                closed = true;
            }
            c = this.read();
        }
        this.write(62);
        if (!closed) {
            ByteArray word;
            OutputStream save = this.out_d;
            this.out_d = null;
            while ((word = this.getTag()) != null) {
                if (!word.equalsString("/textarea")) continue;
                this.read();
                break;
            }
            this.out_d = save;
        }
        if (val instanceof String[]) {
            stringArray = val;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = val;
        }
        String[] values = stringArray;
        for (int i = 0; i < values.length; ++i) {
            this.write(values[i]);
            if (i + 1 >= values.length) continue;
            this.write(10);
        }
        this.write("</textarea>");
    }

    private String interceptURL(String originalAction) {
        StringBuilder action = new StringBuilder(this.action_d);
        StringTokenizer str = new StringTokenizer(originalAction, "#");
        String target = null;
        if (str.hasMoreTokens()) {
            originalAction = str.nextToken();
            if (str.hasMoreTokens()) {
                target = str.nextToken();
            }
        }
        action.append("&originalAction=").append(originalAction);
        if (this.hiddenVars_d != null) {
            for (Map.Entry<String, String> attr : this.hiddenVars_d.entrySet()) {
                if ("originalAction".equalsIgnoreCase(attr.getKey())) continue;
                action.append("&").append(attr.getKey()).append("=");
                if (attr.getValue() == null) continue;
                try {
                    action.append(URLEncoder.encode(attr.getValue(), Literals.DEFAULT_ENCODING));
                }
                catch (UnsupportedEncodingException e) {}
            }
        }
        if (target != null) {
            action.append("#").append(target);
        }
        return action.toString();
    }

    private int read() throws IOException {
        int ret = this.unread_d != -2 ? this.unread_d : this.in_d.read();
        this.unread_d = -2;
        if (this.strToFind_d != null && !this.stringFound()) {
            this.compares(ret);
        }
        return ret;
    }

    private int skipWhitespace() throws IOException {
        int c = this.read();
        while (c != -1 && Character.isWhitespace((char)c)) {
            c = this.read();
        }
        return c;
    }

    private void unread(int i) {
        this.unread_d = i;
    }

    private void variableIntercepted(String name) {
        if (!this.interceptedVars_d.contains(name)) {
            this.interceptedVars_d.add(name);
        }
    }

    private void write(int c) throws IOException {
        if (this.out_d != null) {
            this.out_d.write(c);
        }
    }

    private void write(ByteArray ba) throws IOException {
        if (this.out_d != null && ba != null) {
            for (int i = 0; i < ba.length(); ++i) {
                this.out_d.write(ba.getByte(i) & 0xFF);
            }
        }
    }

    private void write(String str) throws IOException {
        if (this.out_d != null && str != null) {
            this.out_d.write(str.getBytes());
        }
    }

    private String checkRequiredJSCode(String formName) {
        ArrayList<String> requiredList = this.getRequiredVars();
        StringBuilder strBuff = new StringBuilder();
        for (String s : requiredList) {
            String field = "document." + formName + "." + s;
            strBuff.append("if(").append(field).append("){\n");
            strBuff.append("if(").append(field).append(".value == ''){\n");
            strBuff.append("alert('").append(CoreMsg.REQ_FIELD_MESSAGE.getString(this.getLocale())).append("');\n");
            strBuff.append(field).append(".value = '").append(CoreMsg.REQUIRED.getString(this.getLocale())).append("';\n");
            strBuff.append(field).append(".select();\n");
            strBuff.append(field).append(".focus();\n");
            strBuff.append("return false;\n");
            strBuff.append("}\n");
            strBuff.append("}");
        }
        return strBuff.toString();
    }

    private void compares(int character) {
        if (character != this.strToFind_d.charAt(this.nextStrPos_d++)) {
            this.nextStrPos_d = 0;
            return;
        }
        if (this.nextStrPos_d == this.strToFind_d.length()) {
            this.strFound_d = true;
        }
    }

    private void writeAttributes(Map<String, String> attributes) throws IOException {
        for (Map.Entry<String, String> attr : attributes.entrySet()) {
            this.write(32);
            this.write(attr.getKey());
            if (attr.getValue() == null) continue;
            this.write(61);
            this.write(34);
            this.write(attr.getValue());
            this.write(34);
        }
    }

    private void writeHiddenVariables() throws IOException {
        if (this.hiddenVars_d == null) {
            return;
        }
        for (Map.Entry<String, String> attr : this.hiddenVars_d.entrySet()) {
            this.write(">\n");
            this.write("<input type=hidden name=");
            this.write(34);
            this.write(attr.getKey());
            this.write(34);
            this.write(32);
            if (attr.getValue() == null) continue;
            this.write("value");
            this.write(61);
            this.write(34);
            this.write(attr.getValue());
            this.write(34);
        }
    }

    private void writeJavaScriptCode(String formName) throws IOException {
        this.write(">\n");
        this.write("<script language='javascript'>\n");
        this.write("function checkRequiredFields(){\n");
        this.write(this.checkRequiredJSCode(formName) + "\n");
        this.write("}\n");
        this.write("</script");
    }

    private void writeSelectOptions(String[] optValues, String[] defValues) throws IOException {
        for (String optValue : optValues) {
            int j;
            if ("@@@@@".equals(optValue)) continue;
            this.write("option value=");
            this.write(34);
            this.write(optValue);
            this.write(34);
            for (j = 0; j < defValues.length && !defValues[j].equals(optValue); ++j) {
            }
            if (j != defValues.length) {
                this.write(" selected");
            }
            this.write(62);
            this.write(optValue);
            this.write("</option>\n<");
        }
    }
}

