/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.UnsupportedEncodingException;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Hidden;
import oracle.bpm.component.metadata.Method;
import oracle.bpm.lang.Str;
import oracle.bpm.util.Conversion;
import oracle.bpm.util.ResourceUtils;

@Component(module="Fuego.Util")
@Hidden
public class Functions {
    private Functions() {
    }

    @Method(name="Binary")
    public static byte[] Binary(String text, String encoding) throws UnsupportedEncodingException {
        if ("serial".equals(encoding) || "serialization".equals(encoding)) {
            return Conversion.toBinary(text);
        }
        return text.getBytes(encoding);
    }

    @Method(name="String")
    public static String String(String text, int length) {
        return text != null ? Str.toString(text, length) : null;
    }

    @Method(name="String")
    public static String String(byte[] binary, String encoding) throws UnsupportedEncodingException {
        if ("serial".equals(encoding) || "serialization".equals(encoding)) {
            return Conversion.tojava_lang_String(binary);
        }
        return new String(binary, encoding);
    }

    public static String classDirectory(String classname) throws ClassNotFoundException {
        Class<?> cl = Class.forName(classname);
        return ResourceUtils.getDirFromClass(cl).getAbsolutePath();
    }

    public static double random() {
        return Math.random();
    }
}

