/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Stack;

public class ExternalStack {
    private RandomAccessFile file_d;
    private File fileName_d;
    private Stack<Entry> stackIndex_d = new Stack();

    public ExternalStack() throws IOException {
        this.fileName_d = File.createTempFile("undo", ".buffer");
        this.fileName_d.deleteOnExit();
        this.init();
    }

    public static void main(String[] args) throws Throwable {
        ExternalStack undo = new ExternalStack();
        for (int i = 0; i < 10000; ++i) {
            undo.push("uno");
        }
        undo.clear();
        System.err.println("isEmpty? " + undo.isEmpty());
        undo.push("uno");
        undo.push("dos");
        undo.push("tres");
        undo.push("cuatro");
        System.err.println("isEmpty? " + undo.isEmpty());
        System.err.println("names[0]" + undo.getLastNames(2)[0]);
        System.err.println(undo.pop());
        System.err.println(undo.pop());
        System.err.println(undo.pop());
        System.err.println(undo.pop());
        System.err.println("isEmpty? " + undo.isEmpty());
        undo.dispose();
    }

    public boolean isEmpty() {
        return this.stackIndex_d.isEmpty();
    }

    public String[] getLastNames(int n) {
        int size = this.stackIndex_d.size();
        int index = size > n ? size - n : 0;
        String[] names = new String[size > n ? n : size];
        while (index < size) {
            names[size - index - 1] = ((Entry)this.stackIndex_d.get((int)index++)).name_d;
        }
        return names;
    }

    public void clear() throws IOException {
        this.stackIndex_d.clear();
        this.file_d.seek(0L);
    }

    public void dispose() throws IOException {
        this.file_d.close();
        this.file_d = null;
        this.fileName_d.delete();
        this.fileName_d = null;
    }

    public Object pop() throws IOException {
        Entry e = this.stackIndex_d.pop();
        this.file_d.seek(e.addr_d);
        byte[] buffer = new byte[e.length_d];
        this.file_d.readFully(buffer);
        this.file_d.seek(e.addr_d);
        return ExternalStack.bytesToObject(buffer);
    }

    public void push(Object data) throws IOException {
        this.push(String.valueOf(data), data);
    }

    public void push(String name, Object data) throws IOException {
        Entry e = new Entry();
        byte[] buffer = ExternalStack.objectToBytes(data);
        e.addr_d = this.file_d.getFilePointer();
        e.name_d = name;
        e.length_d = buffer.length;
        this.file_d.write(buffer);
        this.stackIndex_d.push(e);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.dispose();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Object bytesToObject(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object obj = ois.readObject();
            ois.close();
            bais.close();
            return obj;
        }
        catch (Exception ex) {
            throw new RuntimeException("Abnormal");
        }
    }

    private static byte[] objectToBytes(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException("Abnormal");
        }
    }

    private void init() throws IOException {
        this.file_d = new RandomAccessFile(this.fileName_d, "rw");
        this.file_d.seek(0L);
    }

    private static class Entry {
        long addr_d;
        int length_d;
        String name_d;

        private Entry() {
        }
    }
}

