/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpm.log.Log;
import oracle.bpm.util.FileUtils;

public class DocumentationUtilities {
    public static final String COMPONENT_EXTENSION = ".xcdl";
    public static final String MODULE_EXTENSION = ".xcdl";
    public static final String XDOC_EXTENSION = ".xdoc";
    public static final String XDOC_SKEL_EXTENSION = ".xdoc.skell";
    public static final String HTML_EXTENSION = ".html";
    public static final String TEMPORAL_EXTENSION = ".tmp";
    public static final String PROCESS_EXTENSION = ".xpdl";
    public static final String BPMN_PROCESS_EXTENSION = ".bpmn";
    public static final String OLD_PROJECT_EXTENSION = ".fpr";
    public static final String PROJECT_MODEL_FILE_NAME = ".project.xpdl";
    public static final String BPMN_PROJECT_MODEL_FILE_NAME = "default.bpmn";

    public static File getDocumentationFileFor(File file) {
        if (file.getName().endsWith(".xcdl")) {
            return FileUtils.changeExtension(file, XDOC_EXTENSION);
        }
        return null;
    }

    public static String getModuleNameFromDir(File modulePath, File catalogPath) {
        String moduleWithSlash = DocumentationUtilities.removeCommonPath(modulePath, catalogPath);
        return moduleWithSlash.replace(File.separatorChar, '.');
    }

    public static boolean deleteDocumentationFor(File file) {
        File documentation = DocumentationUtilities.getDocumentationFileFor(file);
        boolean result = false;
        if (documentation != null) {
            result = documentation.delete();
        }
        return result;
    }

    public static DocumentBuilder newDocumentBuilder() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exception) {
            Log.logSevere(exception);
        }
        return documentBuilder;
    }

    public static String removeCommonPath(File path, File pathToBeRemoved) {
        String pathStr = "";
        String pathToBeRemovedStr = "";
        try {
            pathStr = path.getCanonicalPath();
            pathToBeRemovedStr = pathToBeRemoved.getCanonicalPath();
        }
        catch (IOException exception) {
            Log.logSevere(exception);
        }
        assert (pathStr.indexOf(pathToBeRemovedStr) == 0) : "Cannot find the path to be removed in the specified path.";
        return pathStr.substring(pathToBeRemovedStr.length() + 1, pathStr.length());
    }

    public static boolean isFuego60Project(File projectDir) {
        File fuegoProjectFile;
        return projectDir.isDirectory() && (fuegoProjectFile = new File(projectDir, PROJECT_MODEL_FILE_NAME)).exists();
    }

    public static boolean isBPMNProject(File projectDir) {
        File fuegoProjectFile;
        return projectDir.isDirectory() && (fuegoProjectFile = new File(projectDir, BPMN_PROJECT_MODEL_FILE_NAME)).exists();
    }

    public static boolean isFuegoProjectByExtension(File projectFile) {
        return projectFile.getName().endsWith(OLD_PROJECT_EXTENSION);
    }
}

