/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.util;

import oracle.bpm.lang.Any;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.RegExp;
import oracle.bpm.lang.RuntimeCILExecutionException;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Uncaughtable;

public final class CILUtils {
    public static boolean between(Comparable value, Comparable from, Comparable to) {
        if (from != null && (value == null || value.compareTo(from) < 0)) {
            return false;
        }
        if (to == null) {
            return value == null;
        }
        return value == null || value.compareTo(to) <= 0;
    }

    public static int compare(Comparable obj1, Comparable obj2) {
        return Any.compare(obj1, obj2);
    }

    public static Object exception(Object throwableObject, Class type) {
        if (throwableObject instanceof RuntimeCILExecutionException) {
            return CILUtils.exception(((RuntimeCILExecutionException)throwableObject).getObject(), type);
        }
        if (throwableObject instanceof ComponentExecutionException && ((ComponentExecutionException)throwableObject).getCause() != null) {
            throwableObject = ((ComponentExecutionException)throwableObject).getCause();
            return CILUtils.exception(throwableObject, type);
        }
        if (type.isInstance(throwableObject)) {
            return throwableObject;
        }
        if (throwableObject instanceof Throwable) {
            Throwable throwable = (Throwable)throwableObject;
            if ((throwable = throwable.getCause()) != null) {
                return CILUtils.exception(throwable, type);
            }
        }
        return null;
    }

    public static boolean faked() {
        RuntimeCILExecutionException throwable = new RuntimeCILExecutionException(new Object());
        return CILUtils.isInstanceOf((Object)throwable, Object.class) || CILUtils.isInstanceOf((Object)throwable, "");
    }

    public static Enum increment(Enum e, int n) {
        int ordinal = e.ordinal() + n;
        Enum[] values = (Enum[])e.getClass().getEnumConstants();
        return ordinal >= 0 && ordinal < values.length ? values[ordinal] : null;
    }

    public static boolean instanceOf(Object exception, String componentType, String signature) {
        return CILUtils.isInstanceOf(exception, componentType, signature);
    }

    public static boolean isInstanceOf(Object throwable, String userException) {
        if (throwable instanceof RuntimeCILExecutionException) {
            RuntimeCILExecutionException runtimeException = (RuntimeCILExecutionException)throwable;
            String name = runtimeException.getExceptionName();
            return userException.equals(name);
        }
        return false;
    }

    public static boolean isInstanceOf(Object throwable, Class excType) {
        if (CILUtils.isUncaughtableException(throwable)) {
            return false;
        }
        if (throwable instanceof RuntimeCILExecutionException) {
            return excType.isInstance(throwable);
        }
        if (throwable instanceof ComponentExecutionException && ((ComponentExecutionException)throwable).getCause() != null) {
            throwable = ((ComponentExecutionException)throwable).getCause();
            return CILUtils.isInstanceOf(throwable, excType);
        }
        boolean isInstanceOf = excType.isInstance(throwable);
        if (!isInstanceOf && throwable instanceof Throwable && (throwable = ((Throwable)throwable).getCause()) != null) {
            isInstanceOf = CILUtils.isInstanceOf(throwable, excType);
        }
        return isInstanceOf;
    }

    public static boolean isInstanceOf(Object exception, String componentType, String signature) {
        if (CILUtils.isUncaughtableException(exception) || exception == null) {
            return false;
        }
        if (ComponentType.JAVA.getText().equals(componentType) && "Ljava.lang.Object;".equals(signature)) {
            return true;
        }
        if (exception instanceof RuntimeCILExecutionException) {
            RuntimeCILExecutionException re = (RuntimeCILExecutionException)exception;
            return CILUtils.isInstanceOf(re.getObject(), componentType, signature);
        }
        if (exception instanceof ComponentExecutionException && ((ComponentExecutionException)exception).getCause() != null) {
            exception = ((ComponentExecutionException)exception).getCause();
            return CILUtils.isInstanceOf(exception, componentType, signature);
        }
        if (exception instanceof Invokeable) {
            Invokeable invokeable = (Invokeable)exception;
            return invokeable.isInstanceOf(componentType, signature);
        }
        if (ComponentType.JAVA.getText().equals(componentType) || ComponentType.XOBJECT.getText().equals(componentType)) {
            String className = ComponentType.JAVA.getText().equals(componentType) ? signature : JavaClass.getClassNameFromSignature(signature);
            for (Class<?> javaClass = exception.getClass(); javaClass != null; javaClass = javaClass.getSuperclass()) {
                if (!javaClass.getName().equals(className)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean like(String str, String pattern) {
        pattern = Str.replace(pattern, "_", ".");
        pattern = Str.replace(pattern, "%", ".*");
        RegExp exp = RegExp.valueOf("/" + pattern + "/g");
        return exp.isMatch(str);
    }

    private static boolean isUncaughtableException(Object exception) {
        if (exception instanceof Uncaughtable) {
            return true;
        }
        if (exception != null && exception instanceof Throwable && ((Throwable)exception).getCause() != null) {
            return CILUtils.isUncaughtableException(((Throwable)exception).getCause());
        }
        return false;
    }
}

