/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type.catalog;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.catalog.CatalogListener;

public final class CatalogListeners {
    private final Queue<CatalogListener> listeners = new ConcurrentLinkedQueue<CatalogListener>();

    public void fireTypeAdded(String typeName) {
        for (CatalogListener listener : this.listeners) {
            listener.typeAdded(typeName);
        }
    }

    public void fireTypeRemoved(TypeRef typeRef) {
        for (CatalogListener listener : this.listeners) {
            listener.typeRemoved(typeRef.getText());
        }
    }

    public void firePostSync() {
        for (CatalogListener listener : this.listeners) {
            listener.postSync();
        }
    }

    public void firePreSync() {
        for (CatalogListener listener : this.listeners) {
            listener.preSync();
        }
    }

    public void addListener(CatalogListener listener) {
        this.listeners.add(listener);
    }

    public void removeListeners() {
        this.listeners.clear();
    }
}

