/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.UnknownTypeException;
import oracle.bpm.type.impl.TypeErrorImpl;
import org.jetbrains.annotations.NotNull;

public class UnknownType
extends ObjectTypeDescription {
    private String malformedMsg;
    private TypeRef resolvedType;
    private final String text;

    private UnknownType(String text) {
        super(text.substring(text.lastIndexOf(46) + 1));
        this.setComponentType(ComponentType.UNKNOWN.getText());
        this.text = text;
    }

    public static UnknownType create(String component, ComponentCatalog catalog) {
        if (component == null) {
            throw new IllegalArgumentException("Null component name");
        }
        if (catalog == null) {
            throw new IllegalArgumentException("Null catalog");
        }
        return UnknownType.create(component, catalog, (String)null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static UnknownType create(String component, ComponentCatalog catalog, DefaultException exc) {
        if (component == null) {
            throw new IllegalArgumentException("Null component name");
        }
        UnknownType result = new UnknownType(component);
        result.setCatalog(catalog);
        result.malformedMsg = exc.getMessage();
        result.addError(TypeErrorImpl.create(exc.getKey(), LibMsg.QUOTE(exc.getKey().toString()), exc));
        UnknownType unknownType = result;
        if (unknownType == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/UnknownType.create must not return null");
        }
        return unknownType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static UnknownType create(String component, ComponentCatalog catalog, String msgError) {
        UnknownType unknownType = UnknownType.create(component, catalog, new UnknownTypeException(msgError));
        if (unknownType == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/UnknownType.create must not return null");
        }
        return unknownType;
    }

    @Override
    public Class getJavaClass() {
        return null;
    }

    @Override
    public String getJavaSignature() {
        return "";
    }

    @Override
    public String getJavaType() {
        return "";
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public TypeDescription get() {
        if (this.resolvedType != null) {
            return this.resolvedType.get();
        }
        TypeDescription result = this;
        try {
            if (this.getCatalog() != null) {
                TypeRef ref;
                String component = this.getText();
                String memberName = null;
                if (component.indexOf(58) != -1) {
                    String[] elements = Str.split(component, ':', false);
                    component = elements[0];
                    memberName = elements[1];
                }
                if ((ref = this.getCatalog().find(component)) != null) {
                    result = ref.get();
                    this.resolvedType = ref;
                    if (memberName != null) {
                        MethodTypeDescription member = result.findMember(memberName);
                        result = member != null ? member : this;
                    }
                } else {
                    result = this;
                }
            }
        }
        catch (AmbiguousTypeNameException e) {
            this.malformedMsg = e.getMessage();
            this.addError(TypeErrorImpl.create(e.getKey(), LibMsg.QUOTE(e.getKey().toString()), e));
            result = this;
        }
        return result;
    }

    @Override
    public String getMalformedMessage() {
        return this.malformedMsg;
    }
}

