/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.Arrays;
import java.util.HashMap;
import oracle.bpm.lang.ArrayTypeDescription;
import oracle.bpm.lang.DynamicTypeDescription;
import oracle.bpm.lang.IllegalTypeException;
import oracle.bpm.lang.IteratorTypeDescription;
import oracle.bpm.lang.JavaObjectTypeDescription;
import oracle.bpm.lang.Kind;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SetTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.ComponentNotFoundException;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeMappings;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.UnknownType;
import oracle.bpm.type.impl.TypeDescriptionImpl;
import oracle.bpm.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeFactory {
    @NonNls
    private static HashMap<String, TypeDescription> wellKnown;
    @NonNls
    private static final String ROOT_OBJECT = "Java.Lang.Object";
    private static final int PRECISION_DEFAULT = 0;
    private static final int PRECISION_8 = 1;
    private static final int PRECISION_16 = 2;
    private static final int PRECISION_32 = 3;
    private static final int PRECISION_64 = 4;
    private static final TypeDescription[] defaultSingletons;
    private static final TypeDescription[] intSingletons;
    private static final TypeDescription[] primIntSingletons;
    private static final TypeDescription[] realSingletons;
    private static final TypeDescription[] primRealSingletons;
    private static final ArrayTypeDescription[] defaultArraySingletons;
    private static final TypeDescription PRIMITIVE_BOOL_SINGLETON;
    private static final TypeDescription CHAR_SINGLETON;
    private static final TypeDescription PRIMITIVE_CHAR_SINGLETON;
    private static final TypeDescription ITERATOR_ANY_SINGLETON;
    private static final TypeDescription SET_ANY_SINGLETON;
    private static final TypeDescription NONE;
    private static ObjectTypeDescription rootObjectSingleton;

    public static TypeDescription getNone() {
        return NONE;
    }

    public static TypeDescription getVoid() {
        return defaultSingletons[0];
    }

    public static TypeDescription getNull() {
        return defaultSingletons[9];
    }

    public static TypeDescription getBool() {
        return defaultSingletons[1];
    }

    public static TypeDescription getPrimitiveBool() {
        return PRIMITIVE_BOOL_SINGLETON;
    }

    public static TypeDescription getInt() {
        return defaultSingletons[2];
    }

    public static TypeDescription getInt(int len) {
        return intSingletons[TypeFactory.offsetFromLength(len)];
    }

    public static TypeDescription getPrimitiveInt(int len) {
        return primIntSingletons[TypeFactory.offsetFromLength(len)];
    }

    public static TypeDescription getDecimal() {
        return defaultSingletons[3];
    }

    public static TypeDescription getDecimal(int length, int scale) {
        return length < 0 && scale < 0 ? TypeFactory.getDecimal() : TypeDescriptionImpl.createTypeDescription(3, length, scale, false);
    }

    public static TypeDescription getReal() {
        return defaultSingletons[4];
    }

    public static TypeDescription getReal(int len) {
        return realSingletons[TypeFactory.offsetFromLength(len)];
    }

    public static TypeDescription getPrimitiveReal(int len) {
        return primRealSingletons[TypeFactory.offsetFromLength(len)];
    }

    public static TypeDescription getString() {
        return defaultSingletons[5];
    }

    public static TypeDescription getString(int length) {
        return length == -1 ? TypeFactory.getString() : (length == 1 ? CHAR_SINGLETON : TypeFactory.create(5, length));
    }

    public static TypeDescription getPrimitiveChar() {
        return PRIMITIVE_CHAR_SINGLETON;
    }

    public static TypeDescription getTime() {
        return defaultSingletons[6];
    }

    public static TypeDescription getTime(int scale) {
        return scale < 0 ? TypeFactory.getTime() : TypeDescriptionImpl.createTypeDescription(6, -1, scale, false);
    }

    public static TypeDescription getInterval() {
        return defaultSingletons[7];
    }

    public static TypeDescription getBinary() {
        return defaultSingletons[8];
    }

    public static TypeDescription getAny() {
        return defaultSingletons[10];
    }

    public static ObjectTypeDescription getRootObject() {
        if (rootObjectSingleton == null) {
            rootObjectSingleton = TypeUtils.loadType(ROOT_OBJECT);
        }
        return rootObjectSingleton;
    }

    public static ArrayTypeDescription getArray(@NotNull TypeRef elementType) {
        int k;
        if (elementType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeFactory.getArray must not be null");
        }
        ArrayTypeDescription result = null;
        if (elementType instanceof TypeDescription && (k = elementType.getKind()) >= 0 && k < defaultSingletons.length && defaultSingletons[k] == elementType) {
            result = defaultArraySingletons[k];
        }
        if (result == null) {
            result = TypeFactory.createArray(elementType);
        }
        return result;
    }

    public static TypeDescription getPrimitiveArray(TypeRef td) {
        return new ArrayTypeDescription(td, null, false, true, null);
    }

    public static TypeDescription getIterator(TypeRef elementType) {
        return elementType == TypeFactory.getAny() ? ITERATOR_ANY_SINGLETON : TypeFactory.createIterator(elementType);
    }

    public static TypeDescription getMap(TypeRef elementType, TypeRef indexType) {
        return TypeFactory.createMap(elementType, indexType, false);
    }

    public static TypeDescription getSortedMap(TypeRef elementType, TypeRef indexType) {
        return TypeFactory.createMap(elementType, indexType, true);
    }

    public static TypeDescription getSet(TypeRef elementType) {
        return elementType == TypeFactory.getAny() ? SET_ANY_SINGLETON : TypeFactory.createSet(elementType);
    }

    public static TypeDescription forKind(int kind, int length, int scale) {
        switch (kind) {
            case 0: {
                return TypeFactory.getVoid();
            }
            case 5: {
                return TypeFactory.getString(length);
            }
            case 2: {
                return TypeFactory.getPrimitiveInt(length);
            }
            case 4: {
                return TypeFactory.getPrimitiveReal(length);
            }
            case 3: {
                return TypeFactory.getDecimal(length, scale);
            }
            case 1: {
                return TypeFactory.getPrimitiveBool();
            }
            case 6: {
                return TypeFactory.getTime(scale);
            }
            case 7: {
                return TypeFactory.getInterval();
            }
            case 8: {
                return TypeFactory.getBinary();
            }
            case 10: {
                return TypeFactory.getAny();
            }
            case 15: {
                return DynamicTypeDescription.INSTANCE;
            }
            case 16: {
                return IteratorTypeDescription.ANY_ITERATOR;
            }
            case 11: {
                return TypeFactory.getRootObject();
            }
        }
        return TypeFactory.getNone();
    }

    public static TypeRef forName(String typeSpec) throws IllegalTypeException {
        return TypeFactory.createFromName(typeSpec, null, null, null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TypeRef forName(@NotNull String typeSpec, ComponentCatalog catalog) throws IllegalTypeException {
        if (typeSpec == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeFactory.forName must not be null");
        }
        TypeRef typeRef = TypeFactory.createFromName(typeSpec, catalog, null, null, false);
        if (typeRef == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeFactory.forName must not return null");
        }
        return typeRef;
    }

    public static TypeRef forName(String typeSpec, ComponentCatalog catalog, String javaType, TypeDescription context) {
        return TypeFactory.createFromName(typeSpec, catalog, javaType, context, false);
    }

    public static TypeRef forNameLazy(String typeSpec, ComponentCatalog catalog) throws IllegalTypeException {
        return TypeFactory.createFromName(typeSpec, catalog, null, null, true);
    }

    public static TypeRef forNameLazy(String typeSpec, ComponentCatalog catalog, String javaType) throws IllegalTypeException {
        return TypeFactory.createFromName(typeSpec, catalog, javaType, null, true);
    }

    @Deprecated
    public static TypeRef forNameLazy(String typeSpec, ComponentCatalog catalog, String javaType, TypeDescription context) {
        return TypeFactory.createFromName(typeSpec, catalog, javaType, context, true);
    }

    public static TypeDescription forName(String name, ComponentCatalog catalog, int[] intParameters, TypeDescription[] typeParameters, TypeDescription context) throws AmbiguousTypeNameException, ComponentNotFoundException {
        TypeDescription result;
        int kind = Kind.getKind(name);
        if (Kind.isPredefined(kind)) {
            result = TypeFactory.create(kind, intParameters);
        } else if (kind == 16 || kind == 19) {
            TypeDescription p = TypeFactory.firstOrAny(typeParameters);
            result = kind == 16 ? TypeFactory.getIterator(p) : TypeFactory.getSet(p);
            result.setTypeParameters(p);
        } else {
            result = TypeFactory.wellKnown(name);
            if (result == null) {
                ObjectTypeDescription otd;
                TypeRef typeRef = catalog.find(name, context);
                if (typeRef == null) {
                    throw new ComponentNotFoundException(name);
                }
                result = typeRef.get();
                if (!Arrays.equals(typeParameters, result.getTypeParameters()) && result.isObject() && typeParameters != null && ((otd = result.asObject()).isJavaMap() && typeParameters.length == 2 || otd.isJavaList() && typeParameters.length == 1)) {
                    otd = otd.clone();
                    otd.setTypeParameters(typeParameters);
                    otd.setElementType(null);
                    otd.setParent(result.getParent());
                    result = otd;
                }
            }
        }
        return result;
    }

    public static TypeDescription wellKnown(String name) {
        if (wellKnown == null) {
            wellKnown = new HashMap();
            wellKnown.put("RegExp", TypeUtils.loadType("Fuego.Internal.RegExp"));
            wellKnown.put("FormatException", JavaObjectTypeDescription.forName("oracle.bpm.lang.FormatException"));
        }
        return wellKnown.get(name);
    }

    public static TypeDescription forNameNonPrimitive(String type, String size) {
        int kind = Kind.getKind(type);
        int length = kind == 2 ? 32 : -1;
        int scale = -1;
        if (!(kind != 5 && kind != 3 || size == null || "".equals(size))) {
            StringTokenizer s = new StringTokenizer(size, ",");
            length = Integer.parseInt(s.nextToken());
            if (s.hasMoreTokens()) {
                scale = Integer.parseInt(s.nextToken());
            }
        }
        return TypeFactory.forKind(kind, length, scale).primitiveEquivalent(false);
    }

    public static ArrayTypeDescription createArray(@NotNull TypeRef elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/TypeFactory.createArray must not be null");
        }
        return new ArrayTypeDescription(elementType, null, false, false, null);
    }

    private static SetTypeDescription createSet(TypeRef elementType) {
        return new SetTypeDescription(elementType, false);
    }

    private static ArrayTypeDescription createMap(TypeRef elementType, TypeRef indexType, boolean ordered) {
        return new ArrayTypeDescription(elementType, indexType, ordered, false, null);
    }

    private static IteratorTypeDescription createIterator(TypeRef elementType) {
        return new IteratorTypeDescription(elementType);
    }

    private static int offsetFromLength(int len) {
        return len <= 0 ? 0 : (len <= 8 ? 1 : (len <= 16 ? 2 : (len <= 32 ? 3 : 4)));
    }

    private static TypeDescription createPrimitive(int kind, int len) {
        return TypeDescriptionImpl.createTypeDescription(kind, len, -1, true);
    }

    private static TypeDescription create(int kind, int len) {
        int scale = -1;
        if (6 == kind) {
            scale = 2;
        } else if (8 == kind) {
            scale = 0;
        }
        return TypeDescriptionImpl.createTypeDescription(kind, len, scale, false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static TypeRef createFromName(@Nullable String typeSpec, ComponentCatalog catalog, String javaType, TypeDescription context, boolean lazy) throws IllegalTypeException {
        void var10_18;
        void var10_12;
        int kind;
        TypeRef typeRef;
        if (typeSpec == null) {
            throw new IllegalTypeException(typeSpec);
        }
        int tsLength = (typeSpec = typeSpec.trim()).length();
        if (tsLength == 0) {
            throw new IllegalTypeException(typeSpec);
        }
        if (Kind.getName(-1).equalsIgnoreCase(typeSpec)) {
            typeRef = TypeFactory.getNone();
            if (typeRef == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeFactory.createFromName must not return null");
            return typeRef;
        }
        int indexPos = TypeFactory.indexSpec(typeSpec);
        if (indexPos != -1) {
            String indexSpec = typeSpec.substring(indexPos, tsLength - 1).trim();
            typeRef = ArrayTypeDescription.valueOf(indexSpec, typeSpec.substring(0, indexPos - 1), javaType, catalog, lazy, context);
            if (typeRef == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeFactory.createFromName must not return null");
            return typeRef;
        }
        String parameter = null;
        int precisionPos = typeSpec.indexOf(40);
        if (precisionPos != -1) {
            int rightParent;
            parameter = typeSpec.substring(precisionPos).trim();
            if (parameter.charAt(rightParent = parameter.length() - 1) != ')') {
                throw new IllegalTypeException(typeSpec);
            }
            if ((parameter = parameter.substring(1, parameter.length() - 1).trim()).length() == 0) {
                parameter = null;
            }
            typeSpec = typeSpec.substring(0, precisionPos).trim();
        }
        if ((kind = Kind.getKind(typeSpec)) == 16) {
            typeRef = TypeFactory.createIterator(catalog, parameter, lazy);
            if (typeRef == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeFactory.createFromName must not return null");
            return typeRef;
        }
        if (kind == 19) {
            typeRef = TypeFactory.createSet(catalog, parameter, lazy);
            if (typeRef == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeFactory.createFromName must not return null");
            return typeRef;
        }
        if (Kind.isPredefined(kind)) {
            typeRef = TypeFactory.createPredefined(kind, typeSpec, javaType, parameter);
            if (typeRef == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeFactory.createFromName must not return null");
            return typeRef;
        }
        if (typeSpec.charAt(0) == '{') {
            typeRef = DynamicRef.parse(typeSpec, catalog);
            if (typeRef == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeFactory.createFromName must not return null");
            return typeRef;
        }
        boolean bl = false;
        while (var10_12 < tsLength) {
            char ch = typeSpec.charAt((int)var10_12);
            if (!Character.isJavaIdentifierPart(ch) && ch != '.') {
                throw new IllegalTypeException(typeSpec);
            }
            ++var10_12;
        }
        if (typeSpec.contains(" ")) {
            throw new IllegalTypeException(typeSpec);
        }
        if (catalog == null) {
            ObjectTypeDescription objectTypeDescription = JavaObjectTypeDescription.forName(typeSpec);
        } else {
            try {
                TypeRef typeRef2 = catalog.find(typeSpec, context);
                if (typeRef2 == null) {
                    if (!lazy) {
                        throw new IllegalTypeException(CoreMsg.TYPECLASSNOTFOUND(typeSpec));
                    }
                    UnknownType unknownType = UnknownType.create(typeSpec, catalog);
                }
            }
            catch (AmbiguousTypeNameException e) {
                if (!lazy) {
                    throw new IllegalTypeException(e.getKey());
                }
                UnknownType unknownType = UnknownType.create(typeSpec, catalog);
            }
        }
        if (var10_18 == null) {
            throw new IllegalTypeException(typeSpec);
        }
        typeRef = var10_18;
        if (typeRef != null) return typeRef;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/type/TypeFactory.createFromName must not return null");
    }

    private static TypeRef createPredefined(int kind, String typeSpec, String javaType, String parameter) {
        TypeDescription t;
        int length = -1;
        int scale = -1;
        if (parameter != null) {
            try {
                switch (kind) {
                    case 2: 
                    case 4: 
                    case 5: {
                        length = Integer.parseInt(parameter);
                        if (length < 0) {
                            throw new IllegalTypeException(typeSpec);
                        }
                        break;
                    }
                    case 3: 
                    case 6: {
                        int comma = parameter.indexOf(44);
                        if (comma == -1) {
                            scale = Integer.parseInt(parameter);
                            break;
                        }
                        String ltext = parameter.substring(0, comma).trim();
                        String ptext = parameter.substring(comma + 1).trim();
                        length = Integer.parseInt(ltext);
                        scale = Integer.parseInt(ptext);
                        if (length < 0 || scale < 0 || kind == 6) {
                            throw new IllegalTypeException(typeSpec);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalTypeException(typeSpec);
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalTypeException(CoreMsg.NUMBERFORMATEXC(e.getMessage(), typeSpec));
            }
        }
        TypeDescription result = TypeFactory.forKind(kind, length, scale);
        if (javaType != null && (t = TypeMappings.getType(javaType)) != null && t.isPrimitive() != result.isPrimitive()) {
            result = result.primitiveEquivalent(!result.isPrimitive());
        }
        return result;
    }

    private static TypeRef createIterator(ComponentCatalog catalog, String parameter, boolean lazy) {
        if (parameter == null) {
            return TypeFactory.getIterator(TypeFactory.getAny());
        }
        return lazy ? IteratorTypeDescription.createLazyIterator(parameter, catalog) : TypeFactory.getIterator(TypeFactory.forName(parameter, catalog));
    }

    private static TypeRef createSet(ComponentCatalog catalog, String parameter, boolean lazy) {
        return parameter == null ? TypeFactory.getSet(TypeFactory.getAny()) : (!lazy ? TypeFactory.getSet(TypeFactory.forName(parameter, catalog)) : SetTypeDescription.createLazySet(parameter, catalog));
    }

    private static int indexSpec(String typeSpec) {
        int result = -1;
        int tsLength = typeSpec.length();
        if (typeSpec.charAt(tsLength - 1) == ']') {
            int i;
            int level = 1;
            for (i = tsLength - 2; i >= 0 && level > 0; --i) {
                char ch = typeSpec.charAt(i);
                if (ch == ']') {
                    ++level;
                    continue;
                }
                if (ch != '[') continue;
                --level;
            }
            if (level > 0) {
                throw new IllegalTypeException(typeSpec);
            }
            result = i + 2;
        }
        return result;
    }

    private static TypeDescription firstOrAny(TypeDescription[] typeParameters) {
        return typeParameters != null && typeParameters.length > 0 ? typeParameters[0] : TypeFactory.getAny();
    }

    private static TypeDescription create(int kind, int[] intParameters) {
        if (intParameters == null) {
            return TypeFactory.forKind(kind, -1, -1);
        }
        if (intParameters.length > 1) {
            return TypeFactory.forKind(kind, intParameters[0], intParameters[1]);
        }
        return kind == 3 ? TypeFactory.forKind(kind, -1, intParameters[0]) : TypeFactory.forKind(kind, intParameters[0], -1);
    }

    static {
        defaultSingletons = new TypeDescription[11];
        intSingletons = new TypeDescription[5];
        primIntSingletons = new TypeDescription[5];
        realSingletons = new TypeDescription[5];
        primRealSingletons = new TypeDescription[5];
        defaultArraySingletons = new ArrayTypeDescription[11];
        TypeFactory.intSingletons[1] = TypeFactory.create(2, 8);
        TypeFactory.intSingletons[2] = TypeFactory.create(2, 16);
        TypeFactory.intSingletons[3] = TypeFactory.create(2, 32);
        TypeFactory.intSingletons[4] = TypeFactory.create(2, 64);
        TypeFactory.intSingletons[0] = intSingletons[3];
        TypeFactory.defaultSingletons[2] = intSingletons[0];
        TypeFactory.primIntSingletons[1] = TypeFactory.createPrimitive(2, 8);
        TypeFactory.primIntSingletons[2] = TypeFactory.createPrimitive(2, 16);
        TypeFactory.primIntSingletons[3] = TypeFactory.createPrimitive(2, 32);
        TypeFactory.primIntSingletons[4] = TypeFactory.createPrimitive(2, 64);
        TypeFactory.primIntSingletons[0] = primIntSingletons[3];
        TypeFactory.realSingletons[1] = TypeFactory.create(4, 32);
        TypeFactory.realSingletons[2] = realSingletons[1];
        TypeFactory.realSingletons[3] = realSingletons[1];
        TypeFactory.realSingletons[4] = TypeFactory.create(4, 64);
        TypeFactory.realSingletons[0] = realSingletons[4];
        TypeFactory.defaultSingletons[4] = realSingletons[0];
        TypeFactory.primRealSingletons[1] = TypeFactory.createPrimitive(4, 32);
        TypeFactory.primRealSingletons[2] = primRealSingletons[1];
        TypeFactory.primRealSingletons[3] = primRealSingletons[1];
        TypeFactory.primRealSingletons[4] = TypeFactory.createPrimitive(4, 64);
        TypeFactory.primRealSingletons[0] = primRealSingletons[4];
        for (int i = 0; i < defaultSingletons.length; ++i) {
            if (i != 2 && i != 4) {
                TypeFactory.defaultSingletons[i] = TypeFactory.create(i, -1);
            }
            if (i == 0) continue;
            TypeFactory.defaultArraySingletons[i] = TypeFactory.createArray(defaultSingletons[i]);
        }
        PRIMITIVE_BOOL_SINGLETON = TypeFactory.createPrimitive(1, -1);
        CHAR_SINGLETON = TypeFactory.create(5, 1);
        PRIMITIVE_CHAR_SINGLETON = TypeFactory.createPrimitive(5, 1);
        ITERATOR_ANY_SINGLETON = TypeFactory.createIterator(TypeFactory.getAny());
        SET_ANY_SINGLETON = TypeFactory.createSet(TypeFactory.getAny());
        NONE = TypeFactory.create(-1, -1);
    }
}

