/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.type.AbstractPresentationMigrator;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeRef;
import oracle.bpm.util.Identifier;
import oracle.bpm.xobject.presentationmodel.EasyFullBorderPropertiesSetter;
import oracle.bpm.xobject.presentationmodel.XFormArray;
import oracle.bpm.xobject.presentationmodel.XFormCell;
import oracle.bpm.xobject.presentationmodel.XFormTable;
import oracle.bpm.xobject.presentationmodel.XFormUserInputPresentationXMLObject;

public class Presentation4Migrator
extends AbstractPresentationMigrator {
    public Presentation4Migrator(XObjectTypeDescription obj, String currentParentName, StringList requiredAttributes) {
        super(obj, currentParentName, requiredAttributes);
    }

    @Override
    protected void migrateGroupMethod(Map<String, String> groupMethods) {
        for (Map.Entry<String, String> entry : groupMethods.entrySet()) {
            String key = entry.getKey();
            int pointPos = key.indexOf(".");
            String array = key.substring(0, pointPos);
            String method = key.substring(pointPos + 1);
            TypeRef groupType = this.obj.findInnerType(Identifier.classname(array));
            if (groupType == null || !(groupType instanceof ObjectTypeDescription)) continue;
            ObjectTypeDescription group = (ObjectTypeDescription)groupType;
            MethodTypeDescription methodTD = new MethodTypeDescription(method, 33024L);
            methodTD.setCode(SourceCode.create((this.currentParentName != null ? this.currentParentName + "." : "") + this.obj.getName() + "." + entry.getValue(), "Fuego"));
            group.addMember(methodTD);
        }
    }

    @Override
    protected void migrateCellSetting(XFormCell cll) {
        if (cll.hexpand == 0) {
            cll.hexpand = 1;
        }
        if (cll.vexpand == 0) {
            cll.vexpand = 1;
        }
    }

    @Override
    protected void migratePresentationComponent(XFormUserInputPresentationXMLObject comp, String arrayRef, Map<String, String> groupMethods) {
        if (comp.getReference() != null && this.requiredAttributes.contains(comp.getReference())) {
            comp.setPresentationRequired(true);
        }
        if (arrayRef != null) {
            String onChangeSign;
            if (comp.getReference() != null) {
                String newRef = arrayRef + "[]." + comp.getReference();
                comp.setReference(this.cachedString(newRef));
            }
            if ((onChangeSign = comp.getOnChange()) != null) {
                String argPattern = "\\((.*)\\)";
                String oldStatement = onChangeSign.replaceFirst("\\((.*)\\)", "(currentRow)");
                oldStatement = oldStatement.substring(1, oldStatement.length() - 1);
                String newOnChange = onChangeSign.replaceFirst("\\((.*)\\)", "()");
                groupMethods.put(arrayRef + "." + newOnChange.substring(1, newOnChange.length() - 3), oldStatement);
                comp.setOnChange(arrayRef + "[].:" + newOnChange);
            }
        }
    }

    @Override
    protected void migratePresentationLabel(XFormCell cll) {
        if (cll.label != null) {
            cll.label.setFgcolor(cll.getFgcolor());
            cll.label.setFontStyle(cll.getFontStyle());
            cll.label.setFontsize(cll.getFontsize());
            cll.label.setFonttype(cll.getFonttype());
        }
    }

    @Override
    protected void migrateArraySetting(XFormArray array) {
        array.setHeaderfgcolor("#000000");
        array.setBgcolor("#DEDFE1");
        array.setHeaderbgcolor("#C2C2C2");
        array.setHeaderfgcolor("#000000");
        array.setIndexbgcolor("#DEDFE1");
        array.setIndexfgcolor("#000000");
        array.setPagingbgcolor("#C2C2C2");
        array.setPagingfgcolor("#000000");
        if (array.row != null) {
            array.reference = Identifier.attribute(array.reference);
            if (array.headers != null) {
                array.headerswidth = new int[array.headers.length];
                for (int i = 0; i < array.headerswidth.length; ++i) {
                    array.headerswidth[i] = -1;
                }
            }
        }
    }

    @Override
    protected void migrateTableSetting(XFormTable table) {
        if (table.border) {
            EasyFullBorderPropertiesSetter.setMigratedDefaultBorder(table);
        } else {
            table.border = true;
        }
    }
}

