/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.util.List;
import java.util.Map;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.IntrospectorMetadata;
import oracle.bpm.lang.Any;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Platform;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.IntrospectionException;
import oracle.bpm.util.ProgressMonitor;

public interface Introspector {
    public static final String CONFIG_MANAGER = "configurationManager";
    public static final String CONFIGS_CREATED = "configsCreated";
    public static final String CONFIGS_CREATED_TYPES = "configsCreatedtypes";
    public static final String CONNECTOR_SESSION = "connectorSession";
    public static final String EXTERNAL_RESOURCE_FACTORY = "EXTERNAL_RESOURCE_FACTORY";
    public static final String MODULE_NAME = "moduleName";
    public static final String PROJECT_BASE_DIR = "projectBaseDir";
    public static final String REINTROSPECTING = "reintrospecting";
    public static final String SELECTED_COMPONENTS = "SELECTED_COMPONENTS";
    public static final String SELECTED_OBJECT = "selected_object";
    public static final String TYPE_PREFIX = "TYPE_PREFIX";

    public void setCustomProperties(Map<String, Object> var1, ObjectTypeDescription var2);

    public Map<String, Object> defaultProperties();

    public void interrupt();

    public ObjectTypeDescription[] introspect(Map<String, Object> var1, ComponentCatalog var2, ProgressMonitor var3) throws IntrospectionException;

    public boolean supportsReIntrospection();

    public static class Extension {
        private Extension() {
        }

        public static Introspector instantiate(String type) {
            try {
                return Extension.find(type).instantiateAs(Introspector.class);
            }
            catch (InstantiationException e) {
                return null;
            }
        }

        public static oracle.bpm.extension.Extension<IntrospectorMetadata> find(String type) {
            oracle.bpm.extension.Extension<IntrospectorMetadata> result = null;
            for (oracle.bpm.extension.Extension<IntrospectorMetadata> extension : Extension.getIntrospectors()) {
                IntrospectorMetadata metadata = extension.getMetadata();
                if (!metadata.type().equals(type)) continue;
                result = extension;
                break;
            }
            return result;
        }

        public static List<oracle.bpm.extension.Extension<IntrospectorMetadata>> getAll() {
            return Any.clone(Extension.getIntrospectors());
        }

        private static List<oracle.bpm.extension.Extension<IntrospectorMetadata>> getIntrospectors() {
            return Introspectors.INSTANCE;
        }

        private static class Introspectors {
            static final List<oracle.bpm.extension.Extension<IntrospectorMetadata>> INSTANCE;

            private Introspectors() {
            }

            static {
                ExtensionService extensionService = Platform.getExtensionService();
                INSTANCE = extensionService.getExtensionsByPoint(IntrospectorMetadata.class);
            }
        }
    }
}

