/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentExecutionException;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.Invokeable;
import oracle.bpm.lang.JavaClass;
import oracle.bpm.lang.JavaEnumTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TransformTypeDescription;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.AbstractTypeRef;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.Argument;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.NoSuchComponentTypeException;
import oracle.bpm.type.PropertyIndex;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.UnknownType;
import oracle.bpm.type.catalog.CatalogListener;
import oracle.bpm.type.catalog.ComponentBundle;
import oracle.bpm.type.catalog.MutableComponentBundle;
import oracle.bpm.util.Locales;
import oracle.bpm.util.documentation.DocumentationType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FuegoClass {
    private static final Map<ClassLoader, SoftReference<PropertyIndex>> propertiesCache = new WeakHashMap<ClassLoader, SoftReference<PropertyIndex>>();
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private static final String ROOT = "";
    private static final String NULL_VALUE = "$null$";
    private static final Map<ClassLoader, ComponentCatalog> catalogs = new WeakHashMap<ClassLoader, ComponentCatalog>();
    private static final int VERSION = 8;
    private static final int ENCODE_UTF8 = 1;
    private static final int ENCODE_LONG_UTF8 = 2;
    private static final ThreadLocal<ComponentCatalog> PROJECT_CATALOG = new InheritableThreadLocal<ComponentCatalog>();

    public static Object getFieldValue(Object instance, String fieldName) throws InvocationTargetException {
        if (instance instanceof Invokeable) {
            Invokeable invokeable = (Invokeable)instance;
            TypeDescription type = (TypeDescription)invokeable.getType();
            if (type == null) {
                type = FuegoClass.forName(invokeable.getFuegoName());
            }
            assert (type != null) : "Cannot get field value from '" + invokeable.getClass() + "' because it does not" + " have metadata.";
            try {
                return FuegoClass.getAttribute(type, fieldName).invoke(instance, null);
            }
            catch (ComponentExecutionException e) {
                throw new InvocationTargetException(e);
            }
        }
        return JavaClass.getFieldValue(instance, fieldName);
    }

    public static ObjectTypeDescription forName(String qualifiedName) {
        return FuegoClass.forName(qualifiedName, Thread.currentThread().getContextClassLoader());
    }

    public static SortedSet<String> findByPropertyValue(@NotNull String property, @NotNull String value) throws IOException, ClassNotFoundException {
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/FuegoClass.findByPropertyValue must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/FuegoClass.findByPropertyValue must not be null");
        }
        return FuegoClass.findByPropertyValue(property, value, Thread.currentThread().getContextClassLoader());
    }

    public static SortedSet<String> findByPropertyValue(@NotNull String property, @NotNull String value, @NotNull ClassLoader cl) throws IOException, ClassNotFoundException {
        PropertyIndex index;
        if (property == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/FuegoClass.findByPropertyValue must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/FuegoClass.findByPropertyValue must not be null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/type/FuegoClass.findByPropertyValue must not be null");
        }
        MutableComponentCatalog projectCatalog = (MutableComponentCatalog)FuegoClass.getProjectCatalog();
        SortedSet<Object> result = projectCatalog != null ? projectCatalog.findByPropertyValue(property, value) : ((index = FuegoClass.findPropertyIndex(cl)) == null ? new TreeSet() : index.findByPropertyValue(property, value));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectTypeDescription forName(String qualifiedName, ClassLoader cl) {
        ObjectTypeDescription type;
        ComponentCatalog catalog;
        ComponentCatalog componentCatalog = FuegoClass.getProjectCatalog();
        if (componentCatalog != null) {
            catalog = componentCatalog;
        } else {
            Map<ClassLoader, ComponentCatalog> map = catalogs;
            synchronized (map) {
                catalog = catalogs.get(cl);
                if (catalog == null) {
                    catalog = new CatalogImpl(cl);
                    catalogs.put(cl, catalog);
                }
            }
        }
        try {
            type = catalog.find(qualifiedName).get().asObject();
        }
        catch (AmbiguousTypeNameException e) {
            IllegalStateException exception = new IllegalStateException("Could not load '" + qualifiedName + '\'');
            exception.initCause(e);
            throw exception;
        }
        return type;
    }

    public static ObjectTypeDescription fromClass(Object object) throws ClassNotFoundException {
        ObjectTypeDescription result = null;
        if (object instanceof Invokeable) {
            String fuegoName;
            Invokeable invokeable = (Invokeable)object;
            result = (ObjectTypeDescription)invokeable.getType();
            if (result == null && (fuegoName = invokeable.getFuegoName()) != null) {
                result = FuegoClass.forName(fuegoName);
            }
        } else {
            String className = object.getClass().getName();
            if (className.startsWith("xobject.")) {
                className = className.substring("xobject.".length());
                result = FuegoClass.forName(className);
            }
        }
        if (result == null) {
            throw new ClassNotFoundException("Could not found Fuego class for object: " + object + ". " + "Perhaps it is not a component from the catalog.");
        }
        return result;
    }

    public static ObjectTypeDescription read(DataInput in, ComponentCatalog catalog) throws IOException {
        short version = in.readShort();
        assert (version <= 8) : "Unknown version";
        ObjectTypeDescription type = FuegoClass.readTypeHeader(in, version, catalog);
        FuegoClass.readMembers(in, type, catalog, version);
        return type;
    }

    public static void write(DataOutput out, ObjectTypeDescription type) throws IOException {
        out.writeShort(8);
        FuegoClass.writeTypeHeader(out, type);
        FuegoClass.writeMembers(out, type);
    }

    public static void setProjectCatalog(ComponentCatalog catalog) {
        PROJECT_CATALOG.set(catalog);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static MethodTypeDescription getAttribute(TypeDescription type, String fieldName) throws ComponentExecutionException {
        AttributeTypeDescription attribute = type.findAttribute(fieldName);
        if (attribute == null) {
            throw new ComponentExecutionException("No such field: " + fieldName);
        }
        AttributeTypeDescription attributeTypeDescription = attribute;
        if (attributeTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/type/FuegoClass.getAttribute must not return null");
        }
        return attributeTypeDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyIndex findPropertyIndex(@NotNull ClassLoader cl) throws IOException, ClassNotFoundException {
        if (cl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/FuegoClass.findPropertyIndex must not be null");
        }
        PropertyIndex index = null;
        Map<ClassLoader, SoftReference<PropertyIndex>> map = propertiesCache;
        synchronized (map) {
            SoftReference<PropertyIndex> indexRef = propertiesCache.get(cl);
            if (indexRef != null) {
                index = indexRef.get();
            }
            if (index == null) {
                index = (PropertyIndex)StreamUtils.readSerializedObject(cl.getResourceAsStream("property.index"), cl);
                propertiesCache.put(cl, new SoftReference<PropertyIndex>(index));
            }
        }
        return index;
    }

    private static int countMembers(ObjectTypeDescription type) {
        int count = 0;
        int length = type.getMemberCount();
        for (int i = 0; i < length; ++i) {
            for (MethodTypeDescription member = type.getMember(i); member != null; member = member.getNextMethod()) {
                ++count;
            }
        }
        return count;
    }

    private static Argument readArgument(DataInput in, ComponentCatalog catalog, int version) throws IOException {
        String name = in.readUTF();
        long modifiers = in.readLong();
        TypeRef type = FuegoClass.readType(in, catalog);
        Argument arg = new Argument(name, type, modifiers);
        if (version >= 3) {
            String holderType;
            String javaType = FuegoClass.readString(in);
            if (javaType != null) {
                arg.setJavaType(javaType);
            }
            if ((holderType = FuegoClass.readString(in)) != null) {
                arg.setHolderJavaType(holderType);
            }
        }
        arg.setProperties(FuegoClass.readProperties(in, version));
        String property = arg.getProperty("primitive");
        if (property != null) {
            boolean primitive = "true".equals(property);
            arg.setType(arg.getType().primitiveEquivalent(primitive));
            arg.setProperty("primitive", null);
        }
        return arg;
    }

    private static void readAttribute(DataInput in, AttributeTypeDescription attribute) throws IOException {
        String precision = attribute.getProperty("precision");
        if (precision != null) {
            int precInt = Integer.parseInt(precision);
            attribute.setProperty("precision", null);
            attribute.setPrecision(precInt);
        }
        attribute.setWriteSignature(FuegoClass.readString(in));
        attribute.setDefaultValue(FuegoClass.readString(in));
        attribute.setPosition(in.readShort());
        int length = in.readShort();
        if (length > 0) {
            StringList validValues = StringList.create(length);
            for (int i = 0; i < length; ++i) {
                validValues.add(in.readUTF());
            }
            attribute.setValidValues(validValues);
        }
    }

    private static MethodTypeDescription readMember(DataInput in, ComponentCatalog catalog, int version) throws IOException {
        MethodTypeDescription member;
        int kind = in.readInt();
        String name = in.readUTF();
        String signature = FuegoClass.readString(in);
        if (kind == 18) {
            member = new AttributeTypeDescription(name, TypeFactory.getAny());
        } else if (kind == 20) {
            member = new TransformTypeDescription();
            member.setName(name);
        } else if (kind == 14) {
            member = new MethodTypeDescription(name);
        } else {
            throw new RuntimeException("Invalid \"" + name + "\" member kind:" + kind);
        }
        member.setSignature(signature);
        member.setProperties(FuegoClass.readProperties(in, version));
        if (version >= 6) {
            FuegoClass.readDisplayNames(in, member);
        }
        if (!member.isAttribute() || version >= 3) {
            Argument result = FuegoClass.readArgument(in, catalog, version);
            member.setReturnArgument(result);
        }
        if (member.isMethod()) {
            FuegoClass.readMethod(in, member, catalog, version);
        } else if (member.isTransformation() && version >= 6) {
            FuegoClass.readMethod(in, member, catalog, version);
        } else if (member.isAttribute()) {
            FuegoClass.readAttribute(in, member.asAttribute());
        }
        if (version >= 8) {
            FuegoClass.readDocumentation(in, member, DocumentationType.DOCUMENTATION);
            FuegoClass.readDocumentation(in, member, DocumentationType.USE_CASE_DOCUMENTATION);
        }
        return member;
    }

    private static void readMembers(DataInput in, ObjectTypeDescription type, ComponentCatalog catalog, int version) throws IOException {
        int count = in.readShort();
        MethodTypeDescription last = null;
        for (int i = 0; i < count; ++i) {
            MethodTypeDescription member = FuegoClass.readMember(in, catalog, version);
            if (last != null && last.getName().equals(member.getName()) && last.getKind() == member.getKind()) {
                last.setNextMethod(member);
            } else {
                String defaultValue = member.isAttribute() ? member.asAttribute().getDefaultValue() : null;
                if (type.isEnum() && member.isAttribute() && defaultValue != null) {
                    type.asEnum().addItem(member.getName(), Integer.parseInt(defaultValue));
                } else {
                    type.addMember(member);
                }
            }
            last = member;
        }
    }

    private static void readMethod(DataInput in, MethodTypeDescription member, ComponentCatalog catalog, int version) throws IOException {
        int argc = in.readShort();
        for (int i = 0; i < argc; ++i) {
            Argument arg = FuegoClass.readArgument(in, catalog, version);
            member.addArgument(arg);
        }
    }

    private static SortedMap<String, String> readProperties(DataInput in, int version) throws IOException {
        TreeMap<String, String> properties = null;
        int length = in.readShort();
        if (length > 0) {
            properties = new TreeMap<String, String>();
            for (int i = 0; i < length; ++i) {
                String name = in.readUTF();
                String value = FuegoClass.readLongString(in, version);
                properties.put(name, value);
            }
        }
        return properties;
    }

    private static String readLongString(DataInput in, int version) throws IOException {
        String value;
        if (version >= 7) {
            int encoding = in.readByte() & 0xFF;
            switch (encoding) {
                case 1: {
                    value = in.readUTF();
                    break;
                }
                case 2: {
                    CharsetDecoder decoder = CHARSET.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    int length = in.readInt();
                    byte[] buf = new byte[length];
                    in.readFully(buf);
                    CharBuffer cbuf = decoder.reset().decode(ByteBuffer.wrap(buf));
                    value = cbuf.toString();
                    break;
                }
                default: {
                    throw new StreamCorruptedException("unexpected encoding: " + encoding);
                }
            }
        } else {
            value = in.readUTF();
        }
        return value;
    }

    private static void readDisplayNames(DataInput in, TypeDescription type) throws IOException {
        int length = in.readShort();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                String name = in.readUTF();
                String value = in.readUTF();
                type.setDisplayName(Locales.valueOf(name), value);
            }
        }
    }

    private static void readDocumentation(DataInput in, TypeDescription type, DocumentationType docType) throws IOException {
        int length = in.readShort();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                String name = in.readUTF();
                int valueLength = in.readInt();
                StringBuilder value = new StringBuilder(valueLength);
                for (int j = 0; j < valueLength; ++j) {
                    value.append(in.readChar());
                }
                type.setDocumentation(docType, Locales.valueOf(name), value.toString());
            }
        }
    }

    private static String readString(DataInput in) throws IOException {
        String value = in.readUTF();
        return NULL_VALUE.equals(value) ? null : value;
    }

    private static void readSuperTypes(DataInput in, ObjectTypeDescription type, ComponentCatalog catalog) throws IOException {
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            long modifiers = in.readLong();
            TypeRef superType = FuegoClass.readType(in, catalog);
            type.addSuperType(new SuperType(superType, modifiers));
        }
    }

    private static TypeRef readType(DataInput in, ComponentCatalog catalog) throws IOException {
        try {
            String type = in.readUTF();
            return type.equals(ROOT) ? catalog.find(ROOT) : (NULL_VALUE.equals(type) ? null : TypeFactory.forNameLazy(type, catalog));
        }
        catch (AmbiguousTypeNameException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private static ObjectTypeDescription readTypeHeader(DataInput in, int version, ComponentCatalog catalog) throws IOException {
        int kind = 11;
        if (version >= 5) {
            kind = in.readInt();
        }
        String name = in.readUTF();
        ObjectTypeDescription type = kind == 17 ? new JavaEnumTypeDescription(name, null) : new ObjectTypeDescription(name);
        type.setComponentType(in.readUTF());
        type.setModifiers(in.readLong());
        type.setSignature(in.readUTF());
        if (version >= 2) {
            TypeRef parent = FuegoClass.readType(in, catalog);
            type.setParent(parent);
        }
        type.setProperties(FuegoClass.readProperties(in, version));
        if (version >= 6) {
            FuegoClass.readDisplayNames(in, type);
        }
        if (version >= 4) {
            FuegoClass.readSuperTypes(in, type, catalog);
        }
        if (version >= 8) {
            FuegoClass.readDocumentation(in, type, DocumentationType.DOCUMENTATION);
            FuegoClass.readDocumentation(in, type, DocumentationType.USE_CASE_DOCUMENTATION);
        }
        return type;
    }

    private static void writeArgument(DataOutput out, Argument arg) throws IOException {
        out.writeUTF(arg.getName());
        out.writeLong(arg.getModifiers());
        FuegoClass.writeType(out, arg.getTypeRef());
        String javaType = arg.getJavaType();
        FuegoClass.writeString(out, javaType);
        if (arg.isOut()) {
            String defaultHolderType;
            String holderJavaType = arg.getHolderJavaType();
            FuegoClass.writeString(out, holderJavaType.equals(defaultHolderType = arg.getType().getHolderType().getDefaultHolder()) ? null : holderJavaType);
        } else {
            FuegoClass.writeString(out, null);
        }
        TypeDescription resultType = arg.getType();
        if (resultType.isPredefined()) {
            boolean primitive = resultType.isPrimitive();
            arg.setProperty("primitive", String.valueOf(primitive));
        }
        if (arg.hasProperties()) {
            FuegoClass.writeProperties(out, arg.getProperties());
        } else {
            FuegoClass.writeProperties(out, null);
        }
    }

    private static void writeAttribute(DataOutput out, AttributeTypeDescription attribute) throws IOException {
        FuegoClass.writeString(out, attribute.getWriteSignature());
        FuegoClass.writeString(out, attribute.getDefaultValue());
        out.writeShort(attribute.getPosition());
        StringList validValues = attribute.getValidValues();
        if (validValues == null) {
            out.writeShort(0);
        } else {
            int length = validValues.size();
            out.writeShort(length);
            for (String value : validValues) {
                out.writeUTF(value);
            }
        }
    }

    private static void writeMember(DataOutput out, MethodTypeDescription member) throws IOException {
        out.writeInt(member.getKind());
        out.writeUTF(member.getName());
        FuegoClass.writeString(out, member.getSignature());
        Argument resultArgument = member.getResultArgument();
        if (member.isAttribute()) {
            AttributeTypeDescription attribute = member.asAttribute();
            if (member.getResultType().isTime() && attribute.getPrecision() != -1) {
                attribute.setProperty("precision", String.valueOf(attribute.getPrecision()));
            }
        }
        if (member.hasProperties()) {
            FuegoClass.writeProperties(out, member.getProperties());
        } else {
            FuegoClass.writeProperties(out, null);
        }
        FuegoClass.writeDisplayNames(member, out);
        FuegoClass.writeArgument(out, resultArgument);
        if (member.isMethod() || member.isTransformation()) {
            FuegoClass.writeMethod(out, member);
        } else if (member.isAttribute()) {
            FuegoClass.writeAttribute(out, member.asAttribute());
        }
        FuegoClass.writeDocumentation(member, out, DocumentationType.DOCUMENTATION);
        FuegoClass.writeDocumentation(member, out, DocumentationType.USE_CASE_DOCUMENTATION);
    }

    private static void writeMembers(DataOutput out, ObjectTypeDescription type) throws IOException {
        int count = FuegoClass.countMembers(type);
        out.writeShort(count);
        int length = type.getMemberCount();
        for (int i = 0; i < length; ++i) {
            MethodTypeDescription member = type.getMember(i);
            while (member != null) {
                FuegoClass.writeMember(out, member);
                member = member.getNextMethod();
                --count;
            }
        }
        assert (count == 0) : count;
    }

    private static void writeMethod(DataOutput out, MethodTypeDescription member) throws IOException {
        int argc = member.getArgumentCount();
        out.writeShort(argc);
        for (int i = 0; i < argc; ++i) {
            FuegoClass.writeArgument(out, member.getArgument(i));
        }
    }

    private static void writeProperties(DataOutput out, Map<String, String> properties) throws IOException {
        if (properties == null || properties.isEmpty()) {
            out.writeShort(0);
        } else {
            int length = properties.size();
            out.writeShort(length);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                out.writeUTF(entry.getKey());
                String value = entry.getValue();
                FuegoClass.writeLongString(value, out);
            }
        }
    }

    private static void writeLongString(String str, DataOutput out) throws IOException {
        if (FuegoClass.utfLen(str) > 65535) {
            out.writeByte(2);
            CharsetEncoder encoder = CHARSET.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            encoder.reset();
            ByteBuffer data = encoder.encode(CharBuffer.wrap(str));
            int remaining = data.remaining();
            out.writeInt(remaining);
            if (data.hasArray()) {
                out.write(data.array(), data.arrayOffset(), remaining);
            } else {
                for (int i = 0; i < remaining; ++i) {
                    out.write(data.get());
                }
            }
        } else {
            out.writeByte(1);
            out.writeUTF(str);
        }
    }

    private static int utfLen(String str) {
        int len = str.length();
        int byteCount = 0;
        for (int i = 0; i < len; ++i) {
            byteCount += FuegoClass.charUtf8ByteCount(str.charAt(i));
        }
        return byteCount;
    }

    private static int charUtf8ByteCount(int c) {
        int charLen = c >= 1 && c <= 127 ? 1 : (c > 2047 ? 3 : 2);
        return charLen;
    }

    private static void writeString(DataOutput out, String value) throws IOException {
        out.writeUTF(value == null ? NULL_VALUE : value);
    }

    private static void writeSuperTypes(ObjectTypeDescription type, DataOutput out) throws IOException {
        List<SuperType> superTypes = type.getSuperTypes();
        out.writeInt(superTypes.size());
        for (SuperType superType : superTypes) {
            out.writeLong(superType.getModifiers());
            FuegoClass.writeType(out, superType.getType());
        }
    }

    private static void writeType(DataOutput out, TypeRef type) throws IOException {
        out.writeUTF(type != null ? type.getText() : NULL_VALUE);
    }

    private static void writeTypeHeader(DataOutput out, ObjectTypeDescription type) throws IOException {
        out.writeInt(type.getKind());
        out.writeUTF(type.getName());
        out.writeUTF(type.getComponentType());
        out.writeLong(type.getModifiers());
        out.writeUTF(type.getSignature());
        TypeRef parent = type.getParentRef();
        FuegoClass.writeType(out, parent);
        FuegoClass.writeProperties(out, type.getProperties());
        FuegoClass.writeDisplayNames(type, out);
        FuegoClass.writeSuperTypes(type, out);
        FuegoClass.writeDocumentation(type, out, DocumentationType.DOCUMENTATION);
        FuegoClass.writeDocumentation(type, out, DocumentationType.USE_CASE_DOCUMENTATION);
    }

    private static void writeDisplayNames(TypeDescription type, DataOutput out) throws IOException {
        LocaleStringMap displayNames = type.getDisplayNames();
        if (displayNames == null || displayNames.isEmpty()) {
            out.writeShort(0);
        } else {
            out.writeShort(displayNames.size());
            for (Map.Entry<Locale, String> displayName : displayNames) {
                out.writeUTF(displayName.getKey().getLanguage());
                out.writeUTF(displayName.getValue());
            }
        }
    }

    private static void writeDocumentation(TypeDescription type, DataOutput out, DocumentationType docType) throws IOException {
        LocaleStringMap documentation = type.getDocumentation(docType);
        if (documentation == null || documentation.isEmpty()) {
            out.writeShort(0);
        } else {
            out.writeShort(documentation.size());
            for (Map.Entry<Locale, String> doc : documentation) {
                out.writeUTF(doc.getKey().getLanguage());
                String value = doc.getValue();
                out.writeInt(value.length());
                out.writeChars(value);
            }
        }
    }

    private static ComponentCatalog getProjectCatalog() {
        return PROJECT_CATALOG.get();
    }

    private static class CatalogImpl
    implements ComponentCatalog {
        private ClassLoader classLoader;
        private final Map<String, TypeRef> typeCache;

        CatalogImpl(ClassLoader classLoader) {
            this.classLoader = classLoader;
            this.typeCache = new HashMap<String, TypeRef>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TypeRef find(String typeName) throws AmbiguousTypeNameException {
            Map<String, TypeRef> typeCache;
            Map<String, TypeRef> map = typeCache = this.getTypeCache();
            synchronized (map) {
                TypeRef result = typeCache.get(typeName);
                if (result == null) {
                    result = new LazyRef(typeName, this);
                    typeCache.put(typeName, result);
                }
                return result;
            }
        }

        @Override
        public TypeRef find(String typeName, TypeDescription context) throws AmbiguousTypeNameException {
            return this.find(typeName);
        }

        @Override
        public TypeRef find(String typeName, TypeDescription context, Map<String, String> usages) throws AmbiguousTypeNameException {
            return this.find(typeName);
        }

        @Override
        public Iterable<TypeRef> allComponents() {
            return Collections.emptyList();
        }

        @Override
        public boolean hasChildren(TypeRef ref) {
            return ref.get().asObject().getInnerTypeCount() > 0;
        }

        @Override
        public SortedMap<String, ? extends TypeRef> findByPartialName(String partialName) {
            return null;
        }

        @Override
        public SortedMap<String, ? extends TypeRef> findByPartialName(String partialName, boolean findInParent) {
            return this.findByPartialName(partialName);
        }

        @Override
        public TypeRef findBpmObjectBySchemaId(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/FuegoClass$CatalogImpl.findBpmObjectBySchemaId must not be null");
            }
            return null;
        }

        @Override
        public TypeRef findExceptionObjectBySchemaId(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/FuegoClass$CatalogImpl.findExceptionObjectBySchemaId must not be null");
            }
            return null;
        }

        @Override
        @Nullable
        public TypeRef findById(@NotNull String componentType, @NotNull String nativeId) {
            if (componentType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/FuegoClass$CatalogImpl.findById must not be null");
            }
            if (nativeId == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/FuegoClass$CatalogImpl.findById must not be null");
            }
            return null;
        }

        @Override
        public TypeRef findById(@NotNull ComponentType componentType, @NotNull String nativeId) {
            if (componentType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/FuegoClass$CatalogImpl.findById must not be null");
            }
            if (nativeId == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/FuegoClass$CatalogImpl.findById must not be null");
            }
            return null;
        }

        @Override
        public ObjectTypeDescription getRoot() {
            return null;
        }

        @Override
        public TypeRef reload(TypeRef type) {
            return null;
        }

        @Override
        public void sync() {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.sync");
        }

        @Override
        public boolean isDisposed() {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.isDisposed");
        }

        @Override
        @NotNull
        public SortedSet<String> findByPropertyValue(@NotNull String property, @NotNull String value) {
            if (property == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/type/FuegoClass$CatalogImpl.findByPropertyValue must not be null");
            }
            if (value == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/type/FuegoClass$CatalogImpl.findByPropertyValue must not be null");
            }
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.findByPropertyValue");
        }

        @Override
        @NotNull
        public PropertyIndex getPropertyIndex() {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.getPropertyIndex");
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isWorkingInMemory() {
            return false;
        }

        @Override
        public MutableComponentCatalog getParentCatalog() {
            return null;
        }

        @Override
        public void dispose() {
        }

        @Override
        public DynamicRef getLazyRef(String text) {
            return null;
        }

        @Override
        public void putLazyRef(String text, DynamicRef type) {
        }

        @Override
        public boolean isReadOnly(TypeRef type) {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.isReadOnly");
        }

        @Override
        public ComponentBundle getComponentBundleForType(String typeName) throws NoSuchComponentTypeException {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.getComponentBundleForType");
        }

        @Override
        public MutableComponentBundle getDefaultStorageBundle() {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.getDefaultStorageBundle");
        }

        @Override
        public List<TypeRef> getModuleCollisions() {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.getModuleCollisions");
        }

        @Override
        public TypeRef findType(String typeName, TypeDescription context, Map<String, String> usages, boolean useExactMaching) throws AmbiguousTypeNameException {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.findType");
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.getDescription");
        }

        @Override
        public VFile getFileForType(String qname) throws TypeCatalogException {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.getFileForType");
        }

        @Override
        public TypeInfo getInfo(TypeRef ref) {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.getInfo");
        }

        @Override
        public Object getOwner() {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.getOwner");
        }

        @Override
        public void addListener(CatalogListener listener) {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.addListener");
        }

        @Override
        public void removeListeners() {
            throw new UnsupportedOperationException("oracle.bpm.type.FuegoClass.CatalogImpl.removeListeners");
        }

        Map<String, TypeRef> getTypeCache() {
            return this.typeCache;
        }
    }

    static class LazyRef
    extends AbstractTypeRef {
        private CatalogImpl catalog;
        private String qname;
        private SoftReference<TypeDescription> ref;

        LazyRef(String qname, CatalogImpl catalog) {
            this.qname = qname;
            this.catalog = catalog;
        }

        @Override
        public ComponentCatalog getCatalog() {
            return this.catalog;
        }

        @Override
        public boolean isFromCatalog(ComponentCatalog catalog) {
            return this.getCatalog() == catalog;
        }

        @Override
        public String getComponentType() {
            return this.get().getComponentType();
        }

        @Override
        public int getKind() {
            return this.get().getKind();
        }

        @Override
        public long getLastModifiedTime() {
            return this.get().getLastModifiedTime();
        }

        @Override
        public long getModifiers() {
            return this.get().getModifiers();
        }

        @Override
        public String getName() {
            return this.get().getName();
        }

        @Override
        public TypeRef getRef() {
            return this;
        }

        @Override
        public String getText() {
            return this.get().getText();
        }

        @Override
        public TypeDescription get() {
            TypeDescription result;
            TypeDescription typeDescription = result = this.ref != null ? this.ref.get() : null;
            if (result == null) {
                try {
                    result = LazyRef.loadFromDisk(this.qname, this.catalog.classLoader, this.catalog);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    TypeRef typeRef;
                    try {
                        typeRef = TypeUtils.getDefaultCatalog().find(this.qname);
                    }
                    catch (AmbiguousTypeNameException e1) {
                        typeRef = null;
                    }
                    result = typeRef == null ? UnknownType.create(this.qname, this.catalog) : typeRef.get();
                }
                this.ref = new SoftReference<TypeDescription>(result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ObjectTypeDescription loadFromDisk(String qualifiedName, ClassLoader loader, ComponentCatalog catalog) throws ClassNotFoundException, IOException {
            ObjectTypeDescription type;
            qualifiedName = qualifiedName.replace('.', '/');
            String fuegoClass = qualifiedName + ".fuegoclass";
            InputStream in = null;
            try {
                in = loader.getResourceAsStream(fuegoClass);
                if (in == null) {
                    if (!qualifiedName.startsWith("xobject.")) {
                        in = loader.getResourceAsStream("xobject/" + fuegoClass);
                    }
                    if (in == null) {
                        throw new ClassNotFoundException("Could not find '" + fuegoClass + "' in '" + loader + '\'');
                    }
                }
                DataInputStream dis = new DataInputStream(new BufferedInputStream(in));
                type = FuegoClass.read(dis, catalog);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            return type;
        }
    }

    public static interface Loader {
        public ObjectTypeDescription loadClass(String var1);
    }
}

