/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.type;

import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentRenderer;

public final class ComponentType {
    private ComponentType() {
    }

    public static String getComponentTypeLabel(ObjectTypeDescription type) {
        Msg msg = ComponentType.getComponentTypeMsg(type);
        return msg != null ? msg.getString() : type.getComponentType();
    }

    public static Msg getComponentTypeMsg(ObjectTypeDescription type) {
        if (type.isModule()) {
            return LibMsg.TYPE_MODULE;
        }
        if (Modifier.isException(type.getModifiers())) {
            return LibMsg.TYPE_EXCEPTION;
        }
        if (Modifier.isPUnitSuite(type.getModifiers())) {
            return LibMsg.TYPE_PUNIT_SUITE;
        }
        if (type.isEnum()) {
            return LibMsg.TYPE_ENUMERATION;
        }
        if (type.isBpmObject()) {
            return LibMsg.TYPE_FUEGO_OBJECT;
        }
        ComponentRenderer renderer = ComponentRenderer.Extension.find(type.getComponentType());
        return renderer == null ? null : renderer.getLabel(type);
    }
}

